//
//  WCTSalesForceSearchRecord.m
//  Pods
//
//  Created by Howard on 2020/4/28.
//

#import "WCTSalesForceSearchRecord.h"

@implementation WCTSalesForceSearchRecord

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.identifier = nil;
    self.name = nil;
  
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{identifier:%@, name:%@}",
            [super description],
            self.identifier,
            self.name];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTSalesForceSearchRecord *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.identifier = [[self.identifier copyWithZone:zone] autorelease];
            object.name = [[self.name copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"id":@"identifier",
             @"name":@"name"
        }];
        
    }
    
    return responseMapping;
}
@end
