//
//  WCTRCAccountLessInfo.m
//  
//
//  Created by Howard on 2016/5/25.
//
//

#import "WCTRCAccountLessInfo.h"

@implementation WCTRCAccountLessInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_email release];
    _email = nil;
    
    [_guid release];
    _guid = nil;
    
    [_name release];
    _name = nil;
    
    [_status release];
    _status = nil;
    
    [_accountSubscriptionStatus release];
    _accountSubscriptionStatus = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{email:%@, guid:%@, name:%@, status:%@, accountSubscriptionStatus:%@}",
            [super description],
            self.email,
            self.guid,
            self.name,
            self.status,
            self.accountSubscriptionStatus];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAccountLessInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.email = [[self.email copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.name = [[self.name copyWithZone:zone] autorelease];
            object.status = [[self.status copyWithZone:zone] autorelease];
            object.accountSubscriptionStatus = [[self.accountSubscriptionStatus copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"email" : @"email",
                                                              @"guid" : @"guid",
                                                              @"name" : @"name",
                                                              @"status" : @"status",
                                                              @"accountSubscriptionStatus":@"accountSubscriptionStatus"}];
    }
    
    return responseMapping;
}

@end
