//
//  WCTRestClient+APIDefine.h
//
//
//  Created by Howard on 2016/3/9.
//  Copyright © 2016年 penpower. All rights reserved.
//

#ifndef WCTRestClient_APIDefine_h
#define WCTRestClient_APIDefine_h

// Login
static NSString *WCTClientPath_Login = @"auth/login";
static NSString *WCTClientPath_LoginV3 = @"auth/login_with_ad";
static NSString *WCTClientPath_Logout = @"auth/logout";
static NSString *WCTClientPath_RefreshToken = @"auth/refreshToken";//重置token的expired & invalid time

// User Account
static NSString *WCTClientPath_User_Account_Logo = @"api/user/account/get_logo";
static NSString *WCTClientPath_User_Account_ChangePassword = @"api/user/account/change_password";
static NSString *WCTClientPath_User_Account_ResetPassword = @"api/user/account/reset_password";
static NSString *WCTClientPath_User_Account_Info = @"api/user/account/get_account_details";
static NSString *WCTClientPath_User_Account_OtherAccounts = @"api/user/account/get_other_account_list";
static NSString *WCTClientPath_User_Account_Boss = @"api/user/account/get_boss";
static NSString *WCTClientPath_User_Account_Subordinates = @"api/user/account/get_subordinates";
static NSString *WCTClientPath_User_Account_ChangeDisplayName = @"api/user/account/change_display_name";

// Admin Account
static NSString *WCTClientPath_User_Account_UpLoadLogo = @"api/admin/account/upload_logo";

// Category
static NSString *WCTClientPath_Category_Create = @"api/contact/category/create";
static NSString *WCTClientPath_Category_Delete = @"api/contact/category/delete";
static NSString *WCTClientPath_Category_ListOfAccount = @"api/contact/category/get_list_by_account";
static NSString *WCTClientPath_Category_GetOrder = @"api/contact/category/get_order";
static NSString *WCTClientPath_Category_SetOrder = @"api/contact/category/set_order";
static NSString *WCTClientPath_Category_Update = @"api/contact/category/update";

// MultiLayer Category

static NSString *WCTClientPath_MultiLayerCategory_Create = @"api/multi_layer_category/create";
static NSString *WCTClientPath_MultiLayerCategory_CreateWithLayers = @"api/multi_layer_category/create_with_layers";

static NSString *WCTClientPath_MultiLayerCategory_Delete = @"api/multi_layer_category/delete";
static NSString *WCTClientPath_MultiLayerCategory_GetAllByAccount = @"api/multi_layer_category/get_all_by_account";

static NSString *WCTClientPath_MultiLayerCategory_GetListForMove = @"api/multi_layer_category/get_list_for_move";
static NSString *WCTClientPath_MultiLayerCategory_GetOneLayerList = @"api/multi_layer_category/get_one_layer_list";
static NSString *WCTClientPath_MultiLayerCategory_GetToggledList = @"api/multi_layer_category/get_toggled_list";
static NSString *WCTClientPath_MultiLayerCategory_Move = @"api/multi_layer_category/move";
static NSString *WCTClientPath_MultiLayerCategory_SetOrderForToggledCateries = @"api/multi_layer_category/set_order_for_toggled_categories";
static NSString *WCTClientPath_MultiLayerCategory_ToggleCategories = @"api/multi_layer_category/toggle_categories";
static NSString *WCTClientPath_MultiLayerCategory_Update = @"api/multi_layer_category/update";


// Contact
static NSString *WCTClientPath_Contact_ExportContactsToSalesforce = @"api/contact/export_contacts_to_salesforce";
static NSString *WCTClientPath_Contact_ExportContactsToContactServer = @"api/contact/export_contacts_to_contact_server";
static NSString *WCTClientPath_Contact_GetByGuidList = @"api/contact/get_by_guid_list";

// Private Contact
static NSString *WCTClientPath_PrivateContact_OperateCategory = @"api/contact/private/add_or_set_categories";
static NSString *WCTClientPath_PrivateContact_Update = @"api/contact/private/update";
static NSString *WCTClientPath_PrivateContact_UploadImage = @"api/contact/private/upload_image";
static NSString *WCTClientPath_PrivateContact_BatchCreateWithUploadImage = @"api/contact/private/create_with_image";
static NSString *WCTClientPath_PrivateContact_CreateWithPreUploadImage = @"api/contact/private/create_with_pre_upload_image";
static NSString *WCTClientPath_PrivateContact_CreateWithPreUploadImageForAccount = @"api/contact/private/create_with_pre_upload_image_for_account";

static NSString *WCTClientPath_PrivateContact_GetContact = @"api/contact/private/get";
static NSString *WCTClientPath_PrivateContact_GetByCategory = @"api/contact/private/get_by_category";
static NSString *WCTClientPath_PrivateContact_GetByAccount = @"api/contact/private/get_uncorrected_list";
static NSString *WCTClientPath_PrivateContact_GetNumberByAccount = @"api/contact/private/get_uncorrected_number";
static NSString *WCTClientPath_PrivateContact_ToggleFavorite = @"api/contact/private/toggle_favorite_contacts";
static NSString *WCTClientPath_PrivateContact_Delete = @"api/contact/private/delete";
static NSString *WCTClientPath_PrivateContact_ListAsCorrected = @"api/contact/private/set_list_as_corrected";
static NSString *WCTClientPath_PrivateContact_RemoveFromCategory = @"api/contact/private/remove_list_from_category";
static NSString *WCTClientPath_PrivateContact_ImageBase64 = @"api/contact/private/get_contact_image_base64";
static NSString *WCTClientPath_PrivateContact_Image = @"api/contact/private/get_contact_image";
static NSString *WCTClientPath_PrivateContact_AddOrSetCategory = @"api/contact/private/add_or_set_categories_multi_layer";

// TSMC methods
static NSString *WCTClientPath_PrivateContact_UnexportedToSalesforce = @"api/contact/private/get_unexported_to_salesforce";

// Public Contact
static NSString *WCTClientPath_PublicContact_DowloadByCaregories =@"api/contact/public/download_shared_contacts_with_their_categories";
static NSString *WCTClientPath_PublicContact_SharedAccounts = @"api/contact/public/get_accounts_share_to_me";
static NSString *WCTClientPath_PublicContact_ContactNumberByAccounts = @"api/contact/public/get_contact_number_shared_by_accounts";
static NSString *WCTClientPath_PublicContact_AllContactNumber = @"api/contact/public/get_contact_number_shared_by_all";
static NSString *WCTClientPath_PublicContact_ContactNumberBySelf = @"api/contact/public/get_contact_number_shared_by_all_subordinates";
static NSString *WCTClientPath_PublicContact_SharedContactStatus = @"api/contact/public/get_download_status_of_shared_contacts";
static NSString *WCTClientPath_PublicContact_ContactsByAccount = @"api/contact/public/get_shared_contacts_of_account";
static NSString *WCTClientPath_PublicContact_ShareStatusForOneContact = @"api/contact/public/get_shared_status_of_all_accounts_for_private_contact";
static NSString *WCTClientPath_PublicContact_ShareContactsToAccounts = @"api/contact/public/share_contacts_to_accounts";
static NSString *WCTClientPath_PublicContact_SetOwnerOfContacts = @"api/contact/public/set_owner_of_contacts";
static NSString *WCTClientPath_PublicContact_GetContactNumberSharedByAccountUnCategory = @"api/contact/public/get_contact_number_shared_by_account_uncategory";
static NSString *WCTClientPath_PublicContact_GetContactNumberSharedByCategoryGuids = @"api/contact/public/get_contact_number_shared_by_categories";
static NSString *WCTClientPath_PublicContact_GetContactsSharedByAccountUnCategory = @"api/contact/public/get_contacts_shared_by_account_uncategory";
static NSString *WCTClientPath_PublicContact_GetContactsSharedByCategory = @"api/contact/public/get_contacts_shared_by_category";

//　Search
static NSString *WCTClientPath_Search_PublicContactsByKeyword = @"api/search/normal/search_public_contact_by_keyword";
static NSString *WCTClientPath_Search_PrivateContactsByKeyword = @"api/search/normal/search_private_contact_by_keyword";
static NSString *WCTClientPath_Search_PublicContactsByKeywordSorted = @"api/search/normal/search_public_contact_by_keyword_sorted";
static NSString *WCTClientPath_AdvancedSearch = @"api/search/advanced/search_contact";


// Normal Setting
static NSString *WCTClientPath_NormalUserSetting_AllUserSettings = @"api/account/normal/setting/get_all_user_settings";
static NSString *WCTClientPath_NormalUserSetting_SupportMapEngine = @"api/account/normal/setting/get_support_map_engines";
static NSString *WCTClientPath_NormalUserSetting_AsianSurnameOrder = @"api/account/normal/setting/get_asian_surname_order_setting";
static NSString *WCTClientPath_NormalUserSetting_WesternSurnameOrder =  @"api/account/normal/setting/get_western_surname_order_setting";
static NSString *WCTClientPath_NormalUserSetting_NowMapEngine = @"api/account/normal/setting/get_map_engine_setting";
static NSString *WCTClientPath_NormalUserSetting_AutoShareSetting = @"api/account/normal/setting/get_auto_share_setting";
static NSString *WCTClientPath_NormalUserSetting_AccountSharedTargets = @"api/account/normal/setting/get_account_share_targets";
static NSString *WCTClientPath_NormalUserSetting_GlobalShareRole = @"api/account/normal/setting/get_global_share_rule";
static NSString *WCTClientPath_NormalUserSetting_ChineseRecognizeOutput = @"api/account/normal/setting/get_identification_result_setting";
static NSString *WCTClientPath_NormalUserSetting_SortByField = @"api/account/normal/setting/get_sorting_order_setting";
static NSString *WCTClientPath_NormalUserSetting_GetCustomFieldsByCategory = @"api/account/normal/setting/get_all_custom_fields_by_category";
static NSString *WCTClientPath_NormalUserSetting_GetProperty = @"api/account/normal/setting/GetProperty";

static NSString *WCTClientPath_NormalUserSetting_SetAsianSurnameOrder = @"api/account/normal/setting/set_asian_surname_order_setting";
static NSString *WCTClientPath_NormalUserSetting_SetWesternSurnameOrder = @"api/account/normal/setting/set_western_surname_order_setting";
static NSString *WCTClientPath_NormalUserSetting_SetUserMapEngineSetting = @"api/account/normal/setting/set_map_engine_setting";
static NSString *WCTClientPath_NormalUserSetting_SetAutoShareSetting = @"api/account/normal/setting/set_auto_share_setting";
static NSString *WCTClientPath_NormalUserSetting_AddAccountSharedTarget = @"api/account/normal/setting/add_account_share_target";
static NSString *WCTClientPath_NormalUserSetting_RemoveAccountSharedTarget = @"api/account/normal/setting/remove_account_share_target";
static NSString *WCTClientPath_NormalUserSetting_UpdateAccountSharedTargetList = @"api/account/normal/setting/update_account_share_target_list";
static NSString *WCTClientPath_NormalUserSetting_SetChineseRecognizeOutput = @"api/account/normal/setting/set_identification_result_setting";
static NSString *WCTClientPath_NormalUserSetting_SetSortByField = @"api/account/normal/setting/set_sorting_order_setting";
static NSString *WCTClientPath_NormalUserSetting_SetEditAfterRecog = @"api/account/normal/setting/set_edit_after_recog_setting";
static NSString *WCTClientPath_NormalUserSetting_SetAddNoteInfo = @"api/account/normal/setting/set_addnote_after_recog_setting";

// 登入qcontactz
static NSString *WCTClientPath_NormalUserSetting_SetQContactzAccount = @"api/account/normal/setting/set_qcontactz_account_setting";

// 寄送qcontactz驗證信
static NSString *WCTClientPath_NormalUserSetting_SendQContactzEmailSecurityCode = @"api/account/normal/setting/send_qcontactz_email_security_code";

// 變更qcontactz同步/匯出模式: MANUAL_EXPORT : 手動匯出AUTO_EXPORT : 自動匯出AUTO_SYNC_CONTACT : 自動同步聯絡人
static NSString *WCTClientPath_NormalUserSetting_SetQContactzExportMode = @"api/account/normal/setting/set_qcontactz_export_mode";

 


// CRM settings
static NSString *WCTClientPath_NormalUserSetting_SetCRMSettings = @"api/account/normal/setting/set_CRM_settings";
static NSString *WCTClientPath_NormalUserSetting_CRMSettings = @"api/account/normal/setting/get_CRM_settings";
static NSString *WCTClientPath_NormalUserSetting_CRMSystemInfo = @"api/account/normal/setting/get_CRM_system";
static NSString *WCTClientPath_NormalUserSetting_CRMSystemInfoWithURL = @"api/account/normal/setting/get_CRM_system_with_url";
static NSString *WCTClientPath_NormalUserSetting_LogoutCRM = @"api/account/normal/setting/logout_CRM";
static NSString *WCTClientPath_NormalUserSetting_LastCRMExportInfo = @"api/account/normal/setting/get_user_CRM_last_export_info";
static NSString *WCTClientPath_NormalUserSetting_SetCRMExportMode = @"api/account/normal/setting/set_CRM_export_mode";
static NSString *WCTClientPath_NormalUserSetting_UpdateCRMAccessToken = @"api/account/normal/setting/update_CRM_access_token";
static NSString *WCTClientPath_NormalUserSetting_GetSalesforceOAuthToken = @"api/account/normal/setting/get_salesforce_oauth_token";

// MS Contact server
static NSString *WCTClientPath_NormalUserSetting_SetContactServerSettings = @"api/account/normal/setting/set_contact_server_settings";
static NSString *WCTClientPath_NormalUserSetting_ContactServerSettings = @"api/account/normal/setting/get_contact_server_settings";
static NSString *WCTClientPath_NormalUserSetting_ContactServerInfo = @"api/account/normal/setting/get_contact_server_system";
static NSString *WCTClientPath_NormalUserSetting_LogoutContactServer = @"api/account/normal/setting/logout_contact_server";
static NSString *WCTClientPath_NormalUserSetting_LastContactServerExportInfo = @"api/account/normal/setting/get_user_contact_server_last_export_info";
static NSString *WCTClientPath_NormalUserSetting_SetContactServerExportMode = @"api/account/normal/setting/set_contact_server_export_mode";
static NSString *WCTClientPath_NormalUserSetting_UpdateContactServerAccessToken = @"api/account/normal/setting/update_contact_server_access_token";

// 精準校正
static NSString *WCTClientPath_NormalUserSetting_PCSSetting = @"api/account/normal/setting/get_pcs_setting";
static NSString *WCTClientPath_NormalUserSetting_PCSTransferQuota = @"api/account/normal/setting/transfer_pcs_quota";


// Notice
static NSString *WCTClientPath_Notice_UnreadCount = @"api/notice/get_unviewed_notice_count";
static NSString *WCTClientPath_Notice_List = @"api/notice/get_notice_list";
static NSString *WCTClientPath_Notice_ListPageable = @"api/notice/get_notice_list_pageable";
static NSString *WCTClientPath_Notice_SetLastNoticeRead = @"api/notice/set_last_notice_viewed";
static NSString *WCTClientPath_Notice_Content = @"api/notice/get_notice_content";
static NSString *WCTClientPath_Notice_SendContactsSharedNotice = @"api/notice/send_contacts_shared_notice";

// Statistic
static NSString *WCTClientPath_ActivityTotalCount = @"api/statistics/get_activity_total_count";
static NSString *WCTClientPath_AuthorizedInfo = @"api/statistics/get_authorized_Info";
static NSString *WCTClientPath_ContactTotalCount = @"api/statistics/get_contact_total_count";
static NSString *WCTClientPath_StorageInfo = @"api/statistics/get_storage_info";
static NSString *WCTClientPath_TaskTotalCount = @"api/statistics/get_task_total_count";

// Test
static NSString *WCTClientPath_Server_Test = @"api/test";

// Sync
static NSString *WCTClientPath_Sync_CategoryCreate = @"api/Sync/Category/Create";
static NSString *WCTClientPath_Sync_CategoryDelete = @"api/Sync/Category/Delete";
static NSString *WCTClientPath_Sync_CategoryGet = @"api/Sync/Category/Get";
static NSString *WCTClientPath_Sync_CategoryUpdate = @"api/Sync/Category/Update";

static NSString *WCTClientPath_Sync_ContactCreate = @"api/Sync/Contact/Create";
static NSString *WCTClientPath_Sync_ContactIsExist = @"api/Sync/Contact/IsExist";
static NSString *WCTClientPath_Sync_ContactDelete = @"api/Sync/Contact/Delete";
static NSString *WCTClientPath_Sync_ContactGet = @"api/Sync/Contact/Get";
static NSString *WCTClientPath_Sync_ContactUpdate = @"api/Sync/Contact/Update";
static NSString *WCTClientPath_Sync_ContactUpdateCheck = @"api/Sync/Contact/UpdateCheck";
static NSString *WCTClientPath_Sync_ContactCheckStatus = @"api/Sync/Contact/CheckStatus";

static NSString *WCTClientPath_Sync_IsNeedForceCompare = @"api/Sync/IsNeedFullSync";
static NSString *WCTClientPath_Sync_Start = @"api/Sync/StartSync";
static NSString *WCTClientPath_Sync_Done = @"api/Sync/SyncDone";

// System
static NSString *WCTClientPath_System_ServerIsAlive = @"system/IsAlive";
static NSString *WCTClientPath_System_GetVersion = @"system/GetVersionInfo";
static NSString *WCTClientPath_System_CheckServiceStatus = @"system/CheckServiceStatus";
static NSString *WCTClientPath_System_ServerIsActived = @"system/IsServerActived";
static NSString *WCTClientPath_System_ServerNeedReActived = @"system/IsServerNeedReActived";
static NSString *WCTClientPath_System_GetASUSDDNSName = @"system/GetASUSDDNSName";
static NSString *WCTClientPath_System_GetRegisterStatus = @"system/GetRegisterStatus";
static NSString *WCTClientPath_System_GetDBBuildTime = @"system/GetDBBuildTime";
static NSString *WCTClientPath_System_GetLicense = @"system/GetLicense";
static NSString *WCTClientPath_System_GetIsMultiCompanyFrame = @"system/getIsMultiCompanyFrame";
static NSString *WCTClientPath_System_GetIsSimplifyUI = @"system/getIsSimplifyUI";
static NSString *WCTClientPath_System_GetUIDisplayOption = @"system/getUIDisplayOption";

//  for TSMC register
static NSString *WCTClientPath_System_ApplyAccount = @"system/ApplyAccount";

// Register
static NSString *WCTClientPath_Register_GetAllRegistry = @"api/register/getAllRegistry";

// Subscribe
static NSString *WCTClientPath_Subscribe_GetSubscriptionInfo  = @"api/Subscribe/GetSubscriptionInfo";
static NSString *WCTClientPath_Subscribe_RefreshSubscriptionInfoToServer  = @"api/Subscribe/RefreshSubscriptionInfoToServer";
static NSString *WCTClientPath_Subscribe_GetAccountLimit  = @"api/Subscribe/getAccountLimit";
static NSString *WCTClientPath_Subscribe_GetSubscriptionURL  = @"api/Subscribe/getSubscriptionURL";
static NSString *WCTClientPath_Subscribe_UpgradeFromRetail  = @"api/Subscribe/upgradeFromRetail";

// CRM

static NSString *WCTClientPath_CRM_RecentViewAccounts = @"api/crm/get_salesforce_recentview_accounts";
static NSString *WCTClientPath_CRM_SearchSalesforceAccounts = @"api/crm/search_salesforce_accounts";

// MyCard (E-Card)
static NSString *WCTClientPath_MyCard_GetCard = @"api/mycard/get_mycard";
static NSString *WCTClientPath_MyCard_GetCardImage = @"api/mycard/get_mycard_image_base64";
static NSString *WCTClientPath_MyCard_GetCardSetting = @"api/mycard/get_mycard_setting";
static NSString *WCTClientPath_MyCard_EnableOption = @"api/mycard/update_mycard_enable_option";
static NSString *WCTClientPath_MyCard_UpsertMyCard = @"api/mycard/upsert_mycard";

#endif /* WCTRestClient_APIDefine_h */
