//
//  WCTRestClient+System.m
//
//
//  Created by Howard on 2016/9/5.
//
//

#import "WCTRestClient+System.h"
#import "PPSystemInfoController.h"

@implementation WCTRestClient (System)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Server Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serverIsAliveWithSuccess:(void (^)(WCTRCServerIsAliveResponseResult *serverIsAliveResponseResult))success
                                               failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCServerIsAliveResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_ServerIsAlive]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_System_ServerIsAlive
                          parameters:nil
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
//                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serverVersionWithSuccess:(void (^)(WCTRCVersionInfoResponseResult *versionInfoResponseResult))success
                                               failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCVersionInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_GetVersion]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_GetVersion
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
//                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serviceStatusWithSuccess:(void (^)(WCTRCServiceStatusResponseResult *serviceStatusResponseResult))success
                                               failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCServiceStatusResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_CheckServiceStatus]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_CheckServiceStatus
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
//                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serviceIsActivedWithSuccess:(void (^)(WCTRCServerIsActivedResult *serverIsActivedResult))success
                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCServerIsActivedResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_ServerIsActived]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_ServerIsActived
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
                         //                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serviceNeedBeActivedWithSuccess:(void (^)(WCTRCServerNeedBeActivedResult *serverNeedBeActivedResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCServerNeedBeActivedResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_ServerNeedReActived]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_ServerNeedReActived
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
                         //                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serverDnsNameWithSuccess:(void (^)(WCTRCDNSNameResponseResult *serverDnsNameResponseResult))success
                                               failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCDNSNameResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_GetASUSDDNSName]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_GetASUSDDNSName
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
                         //                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serverRegisterStatusWithSuccess:(void (^)(WCTRCServerRegisterStatusResponseResult *serverRegisterStatusResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCServerRegisterStatusResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_GetRegisterStatus]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_GetRegisterStatus
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
                         //                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serverDBBuildTimeWithSuccess:(void (^)(WCTRCDateTimeResponseResult *serverDBBuildTimeResponseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCDateTimeResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_GetDBBuildTime]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_GetDBBuildTime
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
                         //                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)serverLicenseWithSuccess:(void (^)(WCTRCServerLicenseResponseResult *serverLicenseResponseResult))success
                                               failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCServerLicenseResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_GetLicense]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_GetLicense
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
                         //                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)getIsMultiCompanyWithSuccess:(void (^)(WCTRCBooleanResponseResult *isMultiCompanyResponseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCBooleanResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_GetIsMultiCompanyFrame]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_GetIsMultiCompanyFrame
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
                         //                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)getIsSimplifyUIWithSuccess:(void (^)(WCTRCBooleanResponseResult *isSimplifyUIResponseResult))success
                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCBooleanResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_GetIsSimplifyUI]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_GetIsSimplifyUI
                         parameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
                         //                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (NSString *)applyAccountLanguageCode
{
    PPSystemInfoLanguage language = [PPSystemInfoController language];
    
    switch (language)
    {
        case PPSystemInfoLanguage_ChineseTraditional:
        {
            return @"TW";
        }
        case PPSystemInfoLanguage_ChineseSimplified:
        {
            return @"CN";
        }
        case PPSystemInfoLanguage_French:
        {
            return @"FR";
        }
        case PPSystemInfoLanguage_German:
        {
            return @"DE";
        }
        case PPSystemInfoLanguage_Italian:
        {
            return @"IT";
        }
        case PPSystemInfoLanguage_Spanish:
        {
            return @"ES";
        }
        case PPSystemInfoLanguage_Portuguese:
        {
            return @"PT";
        }
        case PPSystemInfoLanguage_Dutch:
        {
            return @"NL";
        }
        case PPSystemInfoLanguage_Japanese:
        {
            return @"JA";
        }
        case PPSystemInfoLanguage_Korean:
        {
            return @"OK";
        }
        default:
            return @"EN";
    }
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)applyAccountWithAccountInfo:(WCTRCApplyAccountInfo *)accountInfo
                                                   success:(void (^)(WCTRCMessageResponseResult *responseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(accountInfo==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCApplyAccountInfo class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_ApplyAccount]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        NSString *pathPattern = [NSString stringWithFormat:@"%@?languageCode=%@",WCTClientPath_System_ApplyAccount, [self applyAccountLanguageCode]];
        
        //////////////////////////////////////////////////
        operation = [self postObject:accountInfo
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:nil
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)displayOptionWithSuccess:(void (^)(WCTRCUIDisplayOptionResponseResult *responseResult))success
                                               failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCUIDisplayOptionResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_System_GetUIDisplayOption]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_System_GetUIDisplayOption
                         parameters:nil
               httpHeaderParameters:nil
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}

@end
