//
//  WCTRestClient+Search.m
//
//
//  Created by Howard on 2016/3/29.
//
//

#import "WCTRestClient+Search.h"

@implementation WCTRestClient (Search)



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)searchPublicContactsByKeywordWithLoginToken:(NSString *)loginToken
                                                                  keyword:(NSString *)keyword
                                                                  success:(void (^)(WCTRCSearchPublicContactsByKeywordResponseResult *searchPublicContactsByKeywordResponseResult))success
                                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [keyword length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSearchPublicContactsByKeywordResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Search_PublicContactsByKeyword]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Search_PublicContactsByKeyword
                          parameters:@{@"keyWord":keyword}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)searchPublicContactsByKeywordSortedWithLoginToken:(NSString *)loginToken
                                                                        keyword:(NSString *)keyword
                                                                           page:(NSUInteger)page
                                                                       pageSize:(NSUInteger)pageSize
                                                     contactsimpleinfoSortField:(NSString *)contactsimpleinfoSortField
                                                                  sortDirection:(NSString *)sortDirection
                                                                        success:(void (^)(WCTRCSearchPublicContactsByKeywordSortedResponseResult *searchPublicContactsByKeywordSortedResponseResult))success
                                                                        failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [keyword length]<=0 ||
           pageSize<=0 ||
           [contactsimpleinfoSortField length]<=0 ||
           [sortDirection length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSearchPublicContactsByKeywordSortedResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Search_PublicContactsByKeywordSorted]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Search_PublicContactsByKeywordSorted
                          parameters:@{@"keyWord":keyword,
                                       @"page":@(page),
                                       @"pageSize":@(pageSize),
                                       @"contactsimpleinfoSortField":contactsimpleinfoSortField,
                                       @"sortDirection":sortDirection}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)searchPrivateContactsByKeywordWithLoginToken:(NSString *)loginToken
                                                                   keyword:(NSString *)keyword
                                                                   success:(void (^)(WCTRCSearchPrivateContactsByKeywordResponseResult *searchPrivateContactsByKeywordResponseResult))success
                                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [keyword length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSearchPrivateContactsByKeywordResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Search_PrivateContactsByKeyword]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Search_PrivateContactsByKeyword
                          parameters:@{@"keyWord":keyword}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)advancedSearchWithLoginToken:(NSString *)loginToken
                                                   request:(WCTRCAdvancedSearchVoRequest *)request
                                                   success:(void (^)(WCTRCAdvancedSearchContactListResposeResult *searchResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           request==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCAdvancedSearchVoRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }

        if([self addResponseDescriptorForObjectClass:[WCTRCAdvancedSearchContactListResposeResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_AdvancedSearch]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_AdvancedSearch
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}

@end
