//
//  WCTRestClient+PublicContact.m
//
//
//  Created by Howard on 2016/3/25.
//
//

#import "WCTRestClient+PublicContact.h"

@implementation WCTRestClient (PublicContact)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)downloadPublicContactsWithLoginToken:(NSString *)loginToken
                                                      contactGuids:(NSArray *)contactGuids
                                                           success:(void (^)(WCTRCPublicContactsDownloadByContactGuidReponseResult *publicContactsDownloadByContactGuidReponseResult))success
                                                           failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuids count]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPublicContactsDownloadByContactGuidReponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_DowloadByCaregories]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation =  [self postWithPath:WCTClientPath_PublicContact_DowloadByCaregories
                        byObjectManager:objectManager
                         parameterArray:contactGuids
                   httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                                success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                      {
                          
                          self.lastOperationDate = [NSDate date];
                          
                          //////////////////////////////////////////////////
                          
                          if(success!=NULL)
                          {
                              success(mappingResult.firstObject);
                          }
                      }
                                failure:^(RKObjectRequestOperation *operation, NSError *error)
                      {
                          
                          //////////////////////////////////////////////////
                          
                          if(failure!=NULL)
                          {
                              failure(error);
                          }
                      }
                      ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)shareAccountsWithLoginToken:(NSString *)loginToken
                                                  success:(void (^)(WCTRCSharedAccountsResponseResult *sharedAccountsResponseResult))success
                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSharedAccountsResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_SharedAccounts]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_PublicContact_SharedAccounts
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)contactNumberWithLoginToken:(NSString *)loginToken
                                             accountGuids:(NSArray *)accountGuids
                                                  success:(void (^)(WCTRCContactNubmerByAccountGuidsResponseResult *contactNubmerByAccountGuidsResponseResult))success
                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [accountGuids count]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactNubmerByAccountGuidsResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_ContactNumberByAccounts]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postWithPath:WCTClientPath_PublicContact_ContactNumberByAccounts
                       byObjectManager:objectManager
                        parameterArray:accountGuids
                  httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                               success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                               failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)allContactNumberWithLoginToken:(NSString *)loginToken
                                                     success:(void (^)(WCTRCAllContactNumberResponseResult *allContactNumberResponseResult))success
                                                     failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAllContactNumberResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_AllContactNumber]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postWithPath:WCTClientPath_PublicContact_AllContactNumber
                       byObjectManager:objectManager
                        parameterArray:nil
                  httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                               success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                               failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)contactNumberBySelfWithLoginToken:(NSString *)loginToken
                                                        success:(void (^)(WCTRCContactNumberBySelfResponseResult *contactNumberBySelfResponseResult))success
                                                        failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactNumberBySelfResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_ContactNumberBySelf]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postWithPath:WCTClientPath_PublicContact_ContactNumberBySelf
                       byObjectManager:objectManager
                        parameterArray:nil
                  httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                               success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                               failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)shareContactStatusWithLoginToken:(NSString *)loginToken
                                                  contactGuids:(NSArray *)contactGuids
                                                       success:(void (^)(WCTRCSharedContactStatusResponseResult *sharedContactStatusResponseResult))success
                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuids count]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSharedContactStatusResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_SharedContactStatus]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postWithPath:WCTClientPath_PublicContact_SharedContactStatus
                       byObjectManager:objectManager
                        parameterArray:contactGuids
                  httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                               success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                               failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)shareContactListWithLoginToken:(NSString *)loginToken
                                  contactGetByAccountRequest:(WCTRCContactGetByAccountRequest *)contactGetByAccountRequest
                                                     success:(void (^)(WCTRCContactListPageResponseResult *sharedContactsByAccountResponseResult))success
                                                     failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactGetByAccountRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactGetByAccountRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResquestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactListPageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_ContactsByAccount]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactGetByAccountRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PublicContact_ContactsByAccount
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)shareStatusForOneContactWithLoginToken:(NSString *)loginToken
                                                         contactGuid:(NSString *)contactGuid
                                                             success:(void (^)(WCTRCShareStatusForOneContactResponseResult *shareStatusForOneContactResponseResult))success
                                                             failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCShareStatusForOneContactResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_ShareStatusForOneContact]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_PublicContact_ShareStatusForOneContact stringByAppendingString:[NSString stringWithFormat:@"?contactGuid=%@",contactGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)contactShareOperationWithLoginToken:(NSString *)loginToken
                                       contactShareAccountRequest:(WCTRCContactShareAccountRequest *)contactShareAccountRequest
                                                          success:(void (^)(WCTRCContactShareAccountResponseResult *contactShareAccountResponseResult))success
                                                          failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactShareAccountRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactShareAccountRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactShareAccountResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_ShareContactsToAccounts]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactShareAccountRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PublicContact_ShareContactsToAccounts
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setContactOwnerWithLoginToken:(NSString *)loginToken
                                               contactGuids:(NSArray *)contactGuids
                                        newOwnerAccountGuid:(NSString *)newOwnerAccountGuid
                                                    success:(void (^)(WCTRCSetOwnerOfContactResponseResult *setOwnerOfContactResponseResult))success
                                                    failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [contactGuids count]<=0 ||
           [newOwnerAccountGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetOwnerOfContactResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_SetOwnerOfContacts]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_PublicContact_SetOwnerOfContacts
                          parameters:@{@"contactGuids":contactGuids,@"newOwnerAccountGuid":newOwnerAccountGuid}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}




//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)contactsWithLoginToken:(NSString *)loginToken
                                             request:(WCTRCContactGetByGuidListRequest *)request
                                             success:(void (^)(WCTRCContactListPageResponseResult *contactListPageResponseResult))success
                                             failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactGetByGuidListRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactListPageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Contact_GetByGuidList]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_Contact_GetByGuidList
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Public Contact Method (V1.3)


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)sharedContactNumberIsntAccountCategoryWithLoginToken:(NSString *)loginToken
                                                                       accountGuid:(NSString *)accountGuid
                                                                           success:(void (^)(WCTRCSharedContactNumberIsntAccountCategoryResponseResult *multiLayerCategorySharedContactNumberIsntAccountCategoryResponseResult))success
                                                                           failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [accountGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSharedContactNumberIsntAccountCategoryResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_GetContactNumberSharedByAccountUnCategory]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////

        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_PublicContact_GetContactNumberSharedByAccountUnCategory stringByAppendingString:[NSString stringWithFormat:@"?accountGuid=%@",accountGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }

        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
                                 self.lastOperationDate = [NSDate date];
                                 
                                 //////////////////////////////////////////////////
                                 
                                 if(success!=NULL)
                                 {
                                     success(mappingResult.firstObject);
                                 }
                             } failure:^(RKObjectRequestOperation *operation, NSError *error) {
                                 if(failure!=NULL)
                                 {
                                     failure(error);
                                 }
                             }];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)sharedContactNumberWithLoginToken:(NSString *)loginToken
                                                  categoryGuids:(NSArray *)categoryGuids
                                              categoryOwnerGuid:(NSString *)categoryOwnerGuid
                                                        success:(void (^)(WCTRCMLCategorySharedContactNumberWithCategoryGuidsResponseResult *multiLayerSharedContactNumberWithCategoryGuidsResponseResult))success
                                                        failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [categoryGuids count]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategorySharedContactNumberWithCategoryGuidsResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_GetContactNumberSharedByCategoryGuids]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_PublicContact_GetContactNumberSharedByCategoryGuids
                          parameters:@{@"categoryGuids":categoryGuids,
                                       @"categoryOwnerGuid":categoryOwnerGuid}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
                                 self.lastOperationDate = [NSDate date];
                                 
                                 //////////////////////////////////////////////////
                                 
                                 if(success!=NULL)
                                 {
                                     success(mappingResult.firstObject);
                                 }
                             } failure:^(RKObjectRequestOperation *operation, NSError *error) {
                                 if(failure!=NULL)
                                 {
                                     failure(error);
                                 }
                             }];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)sharedContactListIsntAccountCategoryWithLoginToken:(NSString *)loginToken
                                                      contactGetByAccountRequest:(WCTRCContactGetByAccountRequest *)contactGetByAccountRequest
                                                                         success:(void (^)(WCTRCContactListPageResponseResult *listPageResponseResult))success
                                                                         failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactGetByAccountRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        

        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactGetByAccountRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResquestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactListPageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_GetContactsSharedByAccountUnCategory]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////

        operation = [self postObject:contactGetByAccountRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PublicContact_GetContactsSharedByAccountUnCategory
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
                                 self.lastOperationDate = [NSDate date];
                                 
                                 //////////////////////////////////////////////////
                                 
                                 if(success!=NULL)
                                 {
                                     success(mappingResult.firstObject);
                                 }
                             } failure:^(RKObjectRequestOperation *operation, NSError *error) {
                                 if(failure!=NULL)
                                 {
                                     failure(error);
                                 }
                             }];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)sharedContactListWithLoginToken:(NSString *)loginToken
                        contactGetByCategoryAndOwnerVoRequest:(WCTRCContactGetByCategoryAndOwnerVoRequest *)contactGetByCategoryAndOwnerVoRequest
                                                      success:(void (^)(WCTRCContactListPageResponseResult *contactListPageResponseResult))success
                                                      failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactGetByCategoryAndOwnerVoRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCContactGetByCategoryAndOwnerVoRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResquestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCContactListPageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_PublicContact_GetContactsSharedByCategory]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactGetByCategoryAndOwnerVoRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_PublicContact_GetContactsSharedByCategory
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
                                 self.lastOperationDate = [NSDate date];
                                 
                                 //////////////////////////////////////////////////
                                 
                                 if(success!=NULL)
                                 {
                                     success(mappingResult.firstObject);
                                 }
                             } failure:^(RKObjectRequestOperation *operation, NSError *error) {
                                 if(failure!=NULL)
                                 {
                                     failure(error);
                                 }
                             }];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}
@end
