//
//  WCTRestClient+Notice.m
//  Pods
//
//  Created by sanhue on 2016/8/17.
//
//

#import "WCTRestClient+Notice.h"
#import "NSString+Additions.h"

@implementation WCTRestClient (Notice)





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Notice methods


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setLastNoticeReadWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCMessageResponseResult *lastNoticeReadResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Notice_SetLastNoticeRead]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Notice_SetLastNoticeRead
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)unreadNoticeWithLoginToken:(NSString *)loginToken
                                          noticeCategory:(NSString *)noticeCategory
                                                 success:(void (^)(WCTRCLongResponseResult *unreadNoticeResponseResult))success
                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [noticeCategory length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCLongResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Notice_UnreadCount]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Notice_UnreadCount
                          parameters:@{@"notifyCategory":noticeCategory}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)noticeListWithLoginToken:(NSString *)loginToken
                                        noticeCategory:(NSString *)noticeCategory
                                               success:(void (^)(WCTRCNoticeListResponseResult *noticeListResponseResult))success
                                               failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [noticeCategory length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCNoticeListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Notice_List]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Notice_List
                          parameters:@{@"notifyCategory":noticeCategory}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)noticeListPageWithLoginToken:(NSString *)loginToken
                                            noticeCategory:(NSString *)noticeCategory
                                          noticeReadStatus:(NSString *)noticeReadStatus
                                                 pageIndex:(NSInteger)pageIndex
                                                  pageSize:(NSInteger)pageSize
                                                 sortField:(NSString *)sortField
                                             sortDirection:(NSString *)sortDirection
                                                   success:(void (^)(WCTRCNoticeListPageResponseResult *noticeListPageResponseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [noticeCategory length]<=0||
           [noticeReadStatus length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        if([sortField isEqualToString:WCTRC_NoticeSortField_Type]==NO &&
           [sortField isEqualToString:WCTRC_NoticeSortField_Category]==NO &&
           [sortField isEqualToString:WCTRC_NoticeSortField_Time]==NO)
        {
            NSString *errMsg = [NSString stringWithFormat:@"unsuppported sortField value: %@", sortField];
            error = PPErrorParameterInvalidity(errMsg);
            break;
        }
        
        if([sortDirection isEqualToString:WCTRC_NoticeSortDirection_ASC]==NO &&
           [sortDirection isEqualToString:WCTRC_NoticeSortDirection_DESC]==NO )
        {
            NSString *errMsg = [NSString stringWithFormat:@"unsuppported sortDirection value: %@", sortDirection];
            error = PPErrorParameterInvalidity(errMsg);
            break;
        }
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCNoticeListPageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Notice_ListPageable]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Notice_ListPageable
                          parameters:@{@"notifyCategory":noticeCategory,
                                       @"noticeReadStatus":noticeReadStatus,
                                       @"page":[NSString stringWithInteger:pageIndex],
                                       @"pageSize":[NSString stringWithInteger:pageSize],
                                       @"noticeSortField":sortField,
                                       @"sortDirection":sortDirection}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)noticeContentWithLoginToken:(NSString *)loginToken
                                               noticeGuid:(NSString *)noticeGuid
                                                  success:(void (^)(WCTRCMessageResponseResult *noticeContentResponseResult))success
                                                  failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [noticeGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Notice_Content]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Notice_Content
                          parameters:@{@"noticeGuid":noticeGuid}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)noticeShareContactsToAccountsWithLoginToken:(NSString *)loginToken
                                                                 contacts:(NSArray *)contacts
                                                                 accounts:(NSArray *)accounts
                                                                  success:(void (^)(WCTRCMessageResponseResult *noticeContentResponseResult))success
                                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////

        if([contacts count]<=0)
        {
            error = WCTRestClientErrorMake(@"no contacts be shared", error);
            break;
        }
        
        //////////////////////////////////////////////////

        if([accounts count]<=0)
        {
            error = WCTRestClientErrorMake(@"no accounts assigned", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Notice_SendContactsSharedNotice]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_Notice_SendContactsSharedNotice
                          parameters:@{@"receiverAccountGuids":accounts,
                                       @"sharedContactGuids":contacts}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}
@end
