//
//  WCTRestClient+NormalUserSetting.m
//
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRestClient+NormalUserSetting.h"
#import "PPSystemInfoController.h"

@implementation WCTRestClient (NormalUserSetting)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)allUserSettingsWithLoginToken:(NSString *)loginToken
                                                    success:(void (^)(WCTRCAllUserSettingsResponseResult *allUserSettingsResponseResult))success
                                                    failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(loginToken==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAllUserSettingsResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_AllUserSettings]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_AllUserSettings
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
    
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)supportMapEnginesWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCSupportMapEngineResponseResult *listResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if(loginToken==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSupportMapEngineResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SupportMapEngine]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SupportMapEngine
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)nowMapEnginesWithLoginToken:(NSString *)loginToken
                                                  success:(void (^)(WCTRCNowMapEngineResponseResult *nowMapEngineResponseResult))success
                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCNowMapEngineResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_NowMapEngine]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_NowMapEngine
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)asianSurnameOrderWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCAsianSurnameOrderResult *asianSurnameOrderResult))success
                                                      failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAsianSurnameOrderResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_AsianSurnameOrder]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_AsianSurnameOrder
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)westernSurnameOrderWithLoginToken:(NSString *)loginToken
                                                        success:(void (^)(WCTRCWesternSurnameOrderSettingResult *westernSurnameOrderSettingResult))success
                                                        failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCWesternSurnameOrderSettingResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_WesternSurnameOrder]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_WesternSurnameOrder
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)autoShareSettingWithLoginToken:(NSString *)loginToken
                                                     success:(void (^)(WCTRCAutoShareResponseResult *autoShareResponseResult))success
                                                     failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAutoShareResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_AutoShareSetting]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_AutoShareSetting
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)accountSharedTargetsWithLoginToken:(NSString *)loginToken
                                                       shareItem:(NSString *)shareItem
                                                         success:(void (^)(WCTRCAccountSharedTargetsResponseResult *accountSharedTargetsResponseResult))success
                                                         failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCAccountSharedTargetsResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_AccountSharedTargets]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_AccountSharedTargets
                          parameters:@{@"shareItem":shareItem}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)globalShareRoleWithLoginToken:(NSString *)loginToken
                                                    success:(void (^)(WCTRCShareRoleResponseResult *shareRoleResponseResult))success
                                                    failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCShareRoleResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_GlobalShareRole]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_GlobalShareRole
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)chineseRecognizeResultOutputWithLoginToken:(NSString *)loginToken
                                                                 success:(void (^)(WCTRCChineseRecognizeResultOutputResponseResult *chineseRecognizeResultOutputResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCChineseRecognizeResultOutputResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_ChineseRecognizeOutput]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_ChineseRecognizeOutput
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)sortByFieldWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCSortByFieldResponseResult *sortByFieldResponseResult))success
                                                failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSortByFieldResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SortByField]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SortByField
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)customFieldInfosWithLoginToken:(NSString *)loginToken
                                         customFieldCategory:(NSString *)customFieldCategory
                                                     success:(void (^)(WCTRCCustomFieldListResponseResult *customFieldListResponseResult))success
                                                     failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([customFieldCategory isEqualToString:WCTRC_CustomField_Category_Contact]==NO &&
           [customFieldCategory isEqualToString:WCTRC_CustomField_Category_Task]==NO &&
           [customFieldCategory isEqualToString:WCTRC_CustomField_Category_Activity]==NO)
        {
            error = PPErrorParameterInvalidity(@"Invalid value of customFieldCategory");
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCCustomFieldListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_GetCustomFieldsByCategory]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_GetCustomFieldsByCategory
                          parameters:@{@"customFieldCategory":customFieldCategory}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)propertyWithLoginToken:(NSString *)loginToken
                                        propertyType:(NSString *)propertyType
                                             success:(void (^)(WCTRCMessageResponseResult *maxContactsCountResponseResult))success
                                             failure:(void (^)(NSError *error))failure;
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_GetProperty]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_NormalUserSetting_GetProperty
                         parameters:@{@"systemProperty":propertyType}
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setAsianSurnameOrderWithLoginToken:(NSString *)loginToken
                                                       nameOrder:(NSString *)nameOrder
                                                         success:(void (^)(WCTRCSetSurnameOrderResponseResult *setSurnameOrderResponseResult))success
                                                         failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           ([nameOrder compare:WCTRC_NameOrder_FirstNameLastName]==NO &&
            [nameOrder compare:WCTRC_NameOrder_LastNameFirstName]==NO))
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetSurnameOrderResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetAsianSurnameOrder]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetAsianSurnameOrder
                          parameters:@{@"nameOrder":nameOrder}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setWesternSurnameOrderWithLoginToken:(NSString *)loginToken
                                                         nameOrder:(NSString *)nameOrder
                                                           success:(void (^)(WCTRCSetSurnameOrderResponseResult *setSurnameOrderResponseResult))success
                                                           failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           ([nameOrder compare:WCTRC_NameOrder_FirstNameLastName]==NO &&
            [nameOrder compare:WCTRC_NameOrder_LastNameFirstName]==NO))
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetSurnameOrderResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetWesternSurnameOrder]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetWesternSurnameOrder
                          parameters:@{@"nameOrder":nameOrder}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setMapEngineWithLoginToken:(NSString *)loginToken
                                               mapEngine:(NSString *)mapEngine
                                                 success:(void (^)(WCTRCSetUserMapEngineResponseResult *setUserMapEngineResponseResult))success
                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           ([mapEngine compare:WCTRC_MapEngine_Auto]==NO &&
            [mapEngine compare:WCTRC_MapEngine_Baidu]==NO &&
            [mapEngine compare:WCTRC_MapEngine_Google]))
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetUserMapEngineResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetUserMapEngineSetting]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetUserMapEngineSetting
                          parameters:@{@"mapEngine":mapEngine}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setAutoShareSettingWithLoginToken:(NSString *)loginToken
                                                         enable:(BOOL)enable
                                                        success:(void (^)(WCTRCSetAutoShareSettingResponseResult *setAutoShareSettingResponseResult))success
                                                        failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetAutoShareSettingResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetAutoShareSetting]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetAutoShareSetting
                          parameters:@{@"enable":@(enable)}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)addAccountShareTargetWithLoginToken:(NSString *)loginToken
                                                          request:(WCTRCAccountSharedTargetRequest *)request
                                                          success:(void (^)(WCTRCMessageResponseResult *addAccountSahreTargetResponseResult))success
                                                          failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCAccountSharedTargetRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_AddAccountSharedTarget]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_AddAccountSharedTarget
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)removeAccountShareTargetWithLoginToken:(NSString *)loginToken
                                                             request:(WCTRCAccountSharedTargetRequest *)request
                                                             success:(void (^)(WCTRCMessageResponseResult *removeAccountSahreTargetResponseResult))success
                                                             failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCAccountSharedTargetRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_RemoveAccountSharedTarget]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_RemoveAccountSharedTarget
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)updateAccountShareTargetWithLoginToken:(NSString *)loginToken
                                                             request:(WCTRCAccountSharedTargetListRequest *)request
                                                             success:(void (^)(WCTRCMessageResponseResult *updateAccountSahreTargetResponseResult))success
                                                             failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCAccountSharedTargetListRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_UpdateAccountSharedTargetList]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_UpdateAccountSharedTargetList
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setChineseRecognizeOutputWithLoginToken:(NSString *)loginToken
                                                               output:(NSString *)output
                                                              success:(void (^)(WCTRCSetChineseRecognizeOutputResponseResult *setChineseRecognizeOutputResponseResult))success
                                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetChineseRecognizeOutputResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetChineseRecognizeOutput]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetChineseRecognizeOutput
                          parameters:@{@"identificationResult":output}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setSortByFieldWithLoginToken:(NSString *)loginToken
                                                     field:(NSString *)field
                                                   success:(void (^)(WCTRCSetSortByFieldResponseResult *setSortByFieldResponseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetSortByFieldResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetSortByField]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetSortByField
                          parameters:@{@"sortingOrder":field}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setEditAfterRecogWithLoginToken:(NSString *)loginToken
                                                       enable:(BOOL)enable
                                                      success:(void (^)(WCTRCSetEditAfterRecogResponseResult *setEditAfterRecogResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetEditAfterRecogResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetEditAfterRecog]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetEditAfterRecog
                          parameters:@{@"enable":@(enable)}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
            
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setAddNoteInfoAfterRecogWithLoginToken:(NSString *)loginToken
                                                              enable:(BOOL)enable
                                                             success:(void (^)(WCTRCSetAddNoteInfoAfterRecogResponseResult *setAddNoteInfoAfterRecogResponseResult))success
                                                             failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCSetAddNoteInfoAfterRecogResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetAddNoteInfo]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetAddNoteInfo
                          parameters:@{@"enable":@(enable)}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
            
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - CRM settings


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setCRMSettingsWithLoginToken:(NSString *)loginToken
                                               crmSettings:(WCTRCCRMSettings *)crmSettings
                                                   success:(void (^)(WCTRCMessageResponseResult *setCRMSettingsResponseResult))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           crmSettings == nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCCRMSettings class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetCRMSettings]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:crmSettings
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetCRMSettings
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
    
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)CRMSettingsWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCCRMSettingsResponseResult *setCRMSettingsResponseResult))success
                                                failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCCRMSettingsResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_CRMSettings]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_CRMSettings
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)CRMSystemWithLoginToken:(NSString *)loginToken
                                              success:(void (^)(WCTRCMessageResponseResult *CRMSystemResponseResult))success
                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_CRMSystemInfo]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_CRMSystemInfo
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)CRMSystemV7WithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCCRMSystemResponseResult *CRMSystemResponseResult))success
                                                failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCCRMSystemResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_CRMSystemInfoWithURL]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_CRMSystemInfoWithURL
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)logoutCRMWithLoginToken:(NSString *)loginToken
                                              CRMType:(NSString *)CRMType
                                              success:(void (^)(WCTRCMessageResponseResult *logoutCRMResponseResult))success
                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [CRMType length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_LogoutCRM]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_LogoutCRM
                          parameters:@{@"supportCRM":CRMType}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)lastCRMExportInfoWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCUserExportInfoResponseResult *lastCRMExportInfoResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCUserExportInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_LastCRMExportInfo]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_LastCRMExportInfo
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setCRMExportModeWithLoginToken:(NSString *)loginToken
                                                     CTMType:(NSString *)CRMType
                                               CRMExportMode:(NSString *)CRMExportMode
                                  CRMCompanyAssignmentOption:(NSString *)CRMCompanyAssignmentOption
                                                     success:(void (^)(WCTRCMessageResponseResult *setCRMExportModeResponseResult))success
                                                     failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [CRMType length]<=0 ||
           [CRMExportMode length]<=0 ||
           [CRMCompanyAssignmentOption length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetCRMExportMode]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetCRMExportMode
                          parameters:@{@"supportCRM":CRMType,
                                       @"CRMExportMode":CRMExportMode,
                                       @"CRMCompanyAssignmentOption":CRMCompanyAssignmentOption}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setCRMAccessTokenWithLoginToken:(NSString *)loginToken
                                              CRMTokenRequest:(WCTRCUpdateCRMTokenRequest *)CRMTokenRequest
                                                      success:(void (^)(WCTRCMessageResponseResult *setCRMAccessTokenResponseResult))success
                                                      failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCUpdateCRMTokenRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_UpdateCRMAccessToken]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:CRMTokenRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_UpdateCRMAccessToken
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)salesforceOAuthTokenWithLoginToken:(NSString *)loginToken
                                                            code:(NSString *)code
                                                         success:(void (^)(WCTRCCRMUserAgentOAuthTokenResponseResult *userAgentOAuthTokenResponseResult))success
                                                         failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [code length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCCRMUserAgentOAuthTokenResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_GetSalesforceOAuthToken]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_GetSalesforceOAuthToken
                          parameters:@{@"code":code}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Contact Server settings


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setExchangeServerSettingsWithLoginToken:(NSString *)loginToken
                                                             settings:(WCTRCExchangeServerSettings *)settings
                                                              success:(void (^)(WCTRCMessageResponseResult *setContactServerSettingsResponseResult))success
                                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           settings == nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCExchangeServerSettings class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetContactServerSettings]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:settings
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetContactServerSettings
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
    
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)exchangeServerSettingsWithLoginToken:(NSString *)loginToken
                                                           success:(void (^)(WCTRCExchangeServerSettingsResponseResult *contactServerSettingsResponseResult))success
                                                           failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCExchangeServerSettingsResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_ContactServerSettings]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_ContactServerSettings
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)exchangeServerInfoWithLoginToken:(NSString *)loginToken
                                                       success:(void (^)(WCTRCExchangeServerSystemResponseResult *contactServerInfoResponseResult))success
                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCExchangeServerSystemResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_ContactServerInfo]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_ContactServerInfo
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)logoutExchangeServerWithLoginToken:(NSString *)loginToken
                                                         success:(void (^)(WCTRCMessageResponseResult *logoutContactServerResponseResult))success
                                                         failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 )
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_LogoutContactServer]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_LogoutContactServer
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)lastExchangeServerExportInfoWithLoginToken:(NSString *)loginToken
                                                                 success:(void (^)(WCTRCUserExportInfoResponseResult *lastContactServerExportInfoResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCUserExportInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_LastContactServerExportInfo]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_LastCRMExportInfo
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setExchangeServerExportModeWithLoginToken:(NSString *)loginToken
                                                                   mode:(NSString *)mode
                                                                success:(void (^)(WCTRCMessageResponseResult *setContactServerExportModeResponseResult))success
                                                                failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0||
           [mode length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetContactServerExportMode]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetContactServerExportMode
                          parameters:@{@"contactServerExportMode":mode}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)setExchangeServerAccessTokenWithLoginToken:(NSString *)loginToken
                                                           tokenSettings:(WCTRCExchangeServerTokenSettings *)tokenSettings
                                                                 success:(void (^)(WCTRCMessageResponseResult *setCRMAccessTokenResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCExchangeServerTokenSettings class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_UpdateContactServerAccessToken]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:tokenSettings
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_UpdateContactServerAccessToken
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - QContact Method (QNAP)

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)qContactzLoginWithLoginToken:(NSString *)loginToken
                                                 tokenVo:(WCTRCQContactzAuthTokenVo *)tokenVo
                                                                 success:(void (^)(WCTRCQContactzAuthInfoResponseResult *qContactzAuthInfoResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
  
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCQContactzAuthTokenVo class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCQContactzAuthInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetQContactzAccount]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *langcode = nil;
        
        PPSystemInfoLanguage language = [PPSystemInfoController language];
        
        switch (language)
        {
            case PPSystemInfoLanguage_ChineseTraditional:
            {
                langcode = @"TW";
                break;
            }
            case PPSystemInfoLanguage_ChineseSimplified:
            {
                langcode = @"CN";
                break;
            }
            case PPSystemInfoLanguage_Japanese:
            {
                langcode = @"JA";
                break;
            }
            case PPSystemInfoLanguage_Korean:
            {
                langcode = @"KO";
                break;
            }
            default:
            {
                langcode = @"EN";
                break;
            }
        }
        
        //////////////////////////////////////////////////

        NSString *pathPattern = [WCTClientPath_NormalUserSetting_SetQContactzAccount stringByAppendingFormat:@"?langCode=%@",langcode];
        
        operation = [self postObject:tokenVo
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setQContactzExportModeWithLoginToken:(NSString *)loginToken
                                                  exportMode:(NSString *)exportMode
                                                                 success:(void (^)(WCTRCMessageResponseResult *messageResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [exportMode length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_URLEncoding];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SetQContactzExportMode]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SetQContactzExportMode
                          parameters:@{@"contactServerExportMode":exportMode}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setQContactzEmailSecurityCodeWithLoginToken:(NSString *)loginToken
                                                               basicInfo:(WCTRCAuthInfo *)basicInfo
                                                                 success:(void (^)(WCTRCQContactzEmailResponseResult *qContactzEmailResponseResult))success
                                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
  
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCAuthInfo class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCQContactzEmailResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_SendQContactzEmailSecurityCode]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:basicInfo
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_SendQContactzEmailSecurityCode
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PCS Method (精準校正)


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)getPCSSettingWithLoginToken:(NSString *)loginToken
                                                  success:(void (^)(WCTRCPCSSettingResponseResult *responseResult))success
                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCPCSSettingResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_PCSSetting]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_NormalUserSetting_PCSSetting
                         parameters:nil
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)transferPCSQuotaWithLoginToken:(NSString *)loginToken
                                                     request:(WCTRCTransferQuotaRequest *)request
                                                     success:(void (^)(WCTRCMessageResponseResult *responseResult))success
                                                     failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0||
           request==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_NormalUserSetting_PCSTransferQuota]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_NormalUserSetting_PCSTransferQuota
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}
@end
