//
//  WCTRestClient+MyCard.m
//  WCTRestClientController
//
//  Created by sanhue cheng on 2020/10/26.
//

#import "WCTRestClient+MyCard.h"

#import "NSData+Base64.h"

#if TARGET_OS_IPHONE

#elif TARGET_OS_MAC

#import "NSImage+Additions.h"

#endif

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTRestClient (MyCard)




//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)getMyCardWithLoginToken:(NSString *)loginToken
                                             myCardID:(NSString *)myCardID
                                              success:(void (^)(WCTRCMyCardInfoResponseResult *myCardResponseResult))success
                                              failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0 ||
           [myCardID length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMyCardInfoResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MyCard_GetCard]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_MyCard_GetCard
                         parameters:@{@"mycardId":myCardID}
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)getMyCardImageWithLoginToken:(NSString *)loginToken
                                                  myCardID:(NSString *)myCardID
                                                 imageType:(NSString *)imageType
                                                   success:(void (^)(CPImage *image))success
                                                   failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [imageType length]<=0 ||
           [myCardID length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_Image];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MyCard_GetCardImage]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        operation = [self getObject:nil
                    byObjectManager:objectManager
                               path:WCTClientPath_MyCard_GetCardImage
                         parameters:@{@"imageType":imageType, @"mycardId":myCardID}
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            if(success!=NULL)
            {
                // 直接轉為Image回傳
                CPImage *image = nil;
                WCTRCMessageResponseResult *responseResult = mappingResult.firstObject;
                if (responseResult)
                {
                    image = [CPImage imageWithData:[NSData dataWithBase64EncodedStandardString:responseResult.data]];
                }
                success(image);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];

        if(operation==nil)
        {
            error = WCTRestClientErrorMake(@"operation = nil", error);
            break;
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)myCardSettingWithLoginToken:(NSString *)loginToken
                                                  success:(void (^)(WCTRCMyCardSettingResponseResult *responseResult))success
                                                  failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMyCardSettingResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MyCard_GetCardSetting]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_MyCard_GetCardSetting
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}



//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)enableMyCardWithLoginToken:(NSString *)loginToken
                                                myCardID:(NSString *)myCardID
                                                  enable:(BOOL)enable
                                                 success:(void (^)(WCTRCBooleanResponseResult *responseResult))success
                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0||
           [myCardID length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCBooleanResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MyCard_EnableOption]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_MyCard_EnableOption stringByAppendingString:[NSString stringWithFormat:@"?enableMycard=%@&mycardId=%@",(enable?@"true":@"false"), myCardID]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//==============================================================================
//
//==============================================================================
- (RKObjectRequestOperation *)upsertMyCardWithLoginToken:(NSString *)loginToken
                                                myCardID:(NSString *)myCardID
                                                cardInfo:(WCTRCUpdateMyCardInfoRequest *)cardInfo
                                                 success:(void (^)(WCTRCMessageResponseResult *responseResult))success
                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]==0||
           [myCardID length]==0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCUpdateMyCardInfoRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MyCard_UpsertMyCard]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRespoinseDescriptor fail", error);
            break;
        }
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_MyCard_UpsertMyCard stringByAppendingString:[NSString stringWithFormat:@"?mycardId=%@", myCardID]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        //////////////////////////////////////////////////
        
        operation = [self postObject:cardInfo
                    byObjectManager:objectManager
                               path:pathPattern
                          parameters:nil
               httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                            success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult) {
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        } failure:^(RKObjectRequestOperation *operation, NSError *error) {
            
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}
@end
