//
//  WCTRestClient+MultiLayerCategory.m
//  
//
//  Created by Howard on 2018/2/13.
//

#import "WCTRestClient+MultiLayerCategory.h"

// Category
#import "NSString+Additions.h"

@implementation WCTRestClient (MultiLayerCategory)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)createMultiLayerCategoryWithLoginToken:(NSString *)loginToken
                                   multiLayerCategoryCreationRequest:(WCTRCMLCategoryCreationRequest *)multiLayerCategoryCreationRequest
                                                             success:(void (^)(WCTRCMLCategoryCreationResponseResult *multiLayerCategoryCreationResponseResult))success
                                                             failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           multiLayerCategoryCreationRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////

        if([self addRequestDescriptorForObjectClass:[WCTRCMLCategoryCreationRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryCreationResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_Create]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:multiLayerCategoryCreationRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_MultiLayerCategory_Create
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)createMultiLayerCategoryPathWithLoginToken:(NSString *)loginToken
                                             categoryPathCreationRequest:(WCTRCMLCategoryPathCreationRequest *)categoryPathCreationRequest
                                                                 success:(void (^)(WCTRCMLCategoryPathCreationResponseResult *categoryPathCreationResponseResult))success
                                                                 failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           categoryPathCreationRequest==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCMLCategoryPathCreationRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryPathCreationResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_CreateWithLayers]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:categoryPathCreationRequest
                     byObjectManager:objectManager
                                path:WCTClientPath_MultiLayerCategory_CreateWithLayers
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)deleteMultiLayerCategoryWithLoginToken:(NSString *)loginToken
                                                        categoryGuid:(NSString *)categoryGuid
                                                             success:(void (^)(WCTRCMLCategoryDeleteResponseResult *multiLayerCategoryDeleteResponseResult))success
                                                             failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [categoryGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryDeleteResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_Delete]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_MultiLayerCategory_Delete stringByAppendingString:[NSString stringWithFormat:@"?categoryGuid=%@",categoryGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                            failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         //////////////////////////////////////////////////
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)multiLayerCategoryListWithLoginToken:(NSString *)loginToken
                                                       accountGuid:(NSString *)accountGuid
                                                           success:(void (^)(WCTRCMLCategoryInfoListResponseResult *multiLayerCategoryInfoListResponseResult))success
                                                           failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [accountGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryInfoListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_GetAllByAccount]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_MultiLayerCategory_GetAllByAccount stringByAppendingString:[NSString stringWithFormat:@"?accountGuid=%@",accountGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)movableMultiLayerCategoryListWithLoginToken:(NSString *)loginToken
                                                              accountGuid:(NSString *)accountGuid
                                                        movedCategoryGuid:(NSString *)movedCategoryGuid
                                                                  success:(void (^)(WCTRCMLCategoryInfoListResponseResult *multiLayerCategoryInfoListResponseResult))success
                                                                  failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [accountGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryInfoListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_GetListForMove]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_MultiLayerCategory_GetListForMove stringByAppendingString:[NSString stringWithFormat:@"?accountGuid=%@&movedCategoryGuid=%@",accountGuid,movedCategoryGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)multiLayerCategoryOneLayerListWithLoginToken:(NSString *)loginToken
                                                               accountGuid:(NSString *)accountGuid
                                                        parentCategoryGuid:(NSString *)parentCategoryGuid
                                                          needMarkHasChild:(BOOL)needMarkHasChild
                                                                   success:(void (^)(WCTRCMLCategoryInfoListResponseResult *multiLayerCategoryInfoListResponseResult))success
                                                                   failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [accountGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryInfoListResponseResult class]
                                     toObjectManager:objectManager
                                        pathPattern:WCTClientPath_MultiLayerCategory_GetOneLayerList]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_MultiLayerCategory_GetOneLayerList stringByAppendingString:[NSString stringWithFormat:@"?accountGuid=%@&parentCategoryGuid=%@&needMarkHasChild=%d",accountGuid,parentCategoryGuid,needMarkHasChild]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)toggledMultiLayerCategoryListWithLoginToken:(NSString *)loginToken
                                                                  success:(void (^)(WCTRCMLCategoryInfoListResponseResult *multiLayerCategoryInfoListResponseResult))success
                                                                  failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryInfoListResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_GetToggledList]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
 
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_MultiLayerCategory_GetToggledList
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setOrderToggledMultiLayerCategoryListWithRequest:(WCTRCMLSetOrderListRequest *)request
                                                                    loginToken:(NSString *)loginToken
                                                                       success:(void (^)(WCTRCMLCategorySetOrderForToggledCategoriesResponseResult *toggledCategoriesResponseResult))success
                                                                       failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCMLSetOrderListRequest class] toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add RequestDescript fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategorySetOrderForToggledCategoriesResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_SetOrderForToggledCateries]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:request
                     byObjectManager:objectManager
                                path:WCTClientPath_MultiLayerCategory_SetOrderForToggledCateries
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)setToggledMultiLayerWithCategoryToggleUsualVo:(WCTRCCategoryToggleUsualVo *)categoryToggleUsualVo
                                                                 loginToken:(NSString *)loginToken
                                                                    success:(void (^)(WCTRCMLCategoryToggledCategoriesResponseResult *toggledCategoriesResponseResult))success
                                                                    failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCCategoryToggleUsualVo class] toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add RequestDescription fail", error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryToggledCategoriesResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_ToggleCategories]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:categoryToggleUsualVo
                     byObjectManager:objectManager
                                path:WCTClientPath_MultiLayerCategory_ToggleCategories
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)updateMultiLayerCategoryWithGuid:(NSString *)guid
                                                  categoryName:(NSString *)categoryName
                                                    loginToken:(NSString *)loginToken
                                                       success:(void (^)(WCTRCMLCategoryUpdateResponseResult *categoryUpdateResponseResult))success
                                                       failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryUpdateResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_Update]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_MultiLayerCategory_Update stringByAppendingString:[NSString stringWithFormat:@"?categoryGuid=%@&categoryName=%@",guid,[categoryName stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)moveMultiLayerCategoryWithGuid:(NSString *)guid
                                        toParentCategoryGuid:(NSString *)parentCategoryGuid
                                           categoryOwnerGuid:(NSString *)categoryOwnerGuid
                                                  loginToken:(NSString *)loginToken
                                                     success:(void (^)(WCTRCMLCategoryMoveResponseResult *categoryMoveResponseResult))success
                                                     failure:(void (^)(NSError *failureError))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           [guid length]<=0 ||
           [categoryOwnerGuid length]<=0 ||
           [parentCategoryGuid length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
            
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMLCategoryMoveResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_MultiLayerCategory_Move]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        //POST METHOD, 因為restkit底層會把 uri 的網址，?號後全拿掉只取前面來比，所以註冊時還是以一開始未帶參數為主
        
        NSString *pathPattern = [WCTClientPath_MultiLayerCategory_Move stringByAppendingString:[NSString stringWithFormat:@"?movedCategoryGuid=%@&targetParentCategoryGuid=%@&categoryOwnerGuid=%@",guid,parentCategoryGuid,categoryOwnerGuid]];
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }];
        
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}
@end
