//
//  WCTRestClient+LoginOut.h
//  
//
//  Created by Howard on 2016/3/9.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import "WCTRestClient.h"

// Model
#import "WCTRCLoginRequestObject.h"
#import "WCTRCLoginResponseResult.h"
#import "WCTRCLogoutResponseResult.h"
#import "WCTRCTokenInfoResponseResult.h"

@interface WCTRestClient (Login)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  登入
 *
 *  @param loginRequest 登入需求物件
 *  @param minimumSupportedVersion 最小支援版本
 *  @param success      成功 call back
 *  @param failure      失敗 call back
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)loginWithLoginRequest:(WCTRCLoginRequestObject *)loginRequest
                            minimumSupportedVersion:(NSString *)minimumSupportedVersion
                                            success:(void (^)(WCTRCLoginResponseResult *serverResult))success
                                            failure:(void (^)(NSError *error))failure;



/**
 *  登出
 *
 *  @param loginToken   登入取得的Token
 *  @param success      成功 call back
 *  @param failure      失敗 call back
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)logoutWithLoginToken:(NSString *)loginToken
                                           success:(void (^)(WCTRCLogoutResponseResult *serverResult))success
                                           failure:(void (^)(NSError *error))failure;



/**
 *  重置token的expired & invalid time
 *
 *  @param loginToken 登入取得的Token
 *  @param success    成功 call back
 *  @param failure    失敗 call back
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)refreshLoginToken:(NSString *)loginToken
                                        success:(void (^)(WCTRCTokenInfoResponseResult *tokenInfoResponseResult))success
                                        failure:(void (^)(NSError *error))failure;


@end
