//
//  WCTRestClient+Contact.m
//  
//
//  Created by Howard on 2017/2/3.
//
//

#import "WCTRestClient+Contact.h"

@implementation WCTRestClient (Contact)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)exportToSalesforceWithLoginToken:(NSString *)loginToken
                                                   contactList:(WCTRCListRequest *)contactList
                                                        target:(NSString*)target
                                           salesforceAccountId:(NSString *)salesforceAccountId
                                                       success:(void (^)(WCTRCMessageResponseResult *exportToCRMResponseResult))success
                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactList==nil ||
           [target length]<=0)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCListRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Contact_ExportContactsToSalesforce]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        NSString *pathPattern = [WCTClientPath_Contact_ExportContactsToSalesforce stringByAppendingString:[NSString stringWithFormat:@"?salesforceTarget=%@",target]];
        
        if(salesforceAccountId.length>0)
        {
            pathPattern = [pathPattern stringByAppendingString:[NSString stringWithFormat:@"&salesforceAccountId=%@",salesforceAccountId]];
        }
        
        if(pathPattern==nil || pathPattern.length<=0)
        {
            error = WCTRestClientErrorMake(@"API Query String Fail",error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:contactList
                     byObjectManager:objectManager
                                path:pathPattern
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)exportToExchangeServerWithLoginToken:(NSString *)loginToken
                                                      contactList:(WCTRCListRequest *)contactList
                                                          success:(void (^)(WCTRCMessageResponseResult *exportToContactServerResponseResult))success
                                                          failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([loginToken length]<=0 ||
           contactList==nil)
        {
            error = PPErrorParameterInvalidity(error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addRequestDescriptorForObjectClass:[WCTRCListRequest class]
                                    toObjectManager:objectManager]==NO)
        {
            error = WCTRestClientErrorMake(@"add addRequestDescriptor fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTRCMessageResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_Contact_ExportContactsToContactServer]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }

        //////////////////////////////////////////////////
        
        operation = [self postObject:contactList
                     byObjectManager:objectManager
                                path:WCTClientPath_Contact_ExportContactsToContactServer
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
                         
                         self.lastOperationDate = [NSDate date];
                         
                         //////////////////////////////////////////////////
                         
                         if(success!=NULL)
                         {
                             success(mappingResult.firstObject);
                         }
                     }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
                         
                         if(failure!=NULL)
                         {
                             failure(error);
                         }
                     }
                     ];
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}
@end
