//
//  WCTRestClient+CRM.m
//  AppAuth
//
//  Created by Howard on 2020/4/28.
//

#import "WCTRestClient+CRM.h"

@implementation WCTRestClient (CRM)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)salesforceRecentViewAccountsWithLoginToken:(NSString *)loginToken
                                                                 success:(void (^)(WCTSalesForceSearchRecordResponseResult *result))success
                                                                 failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTSalesForceSearchRecordResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_CRM_RecentViewAccounts]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_CRM_RecentViewAccounts
                          parameters:nil
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}


//================================================================================
//
//================================================================================
- (RKObjectRequestOperation *)salesforceAccountsWithLoginToken:(NSString *)loginToken
                                                       keyword:(NSString *)keyword
                                                       success:(void (^)(WCTSalesForceSearchRecordResponseResult *result))success

                                                       failure:(void (^)(NSError *error))failure
{
    RKObjectRequestOperation    *operation  = nil;
    NSError                     *error      = nil;
    
    //////////////////////////////////////////////////
    
    do
    {
        if([keyword length]<=0)
        {
            error = WCTRestClientErrorMake(@"keyword length is zero", error);
            
            break;
        }
        
        //////////////////////////////////////////////////

        RKObjectManager *objectManager = [self objectManagerForType:PPRCObjectManagerType_JSON];
        
        if(objectManager==nil)
        {
            error = WCTRestClientErrorMake(@"self.objectManager = nil", error);
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([self addResponseDescriptorForObjectClass:[WCTSalesForceSearchRecordResponseResult class]
                                     toObjectManager:objectManager
                                         pathPattern:WCTClientPath_CRM_SearchSalesforceAccounts]==NO)
        {
            error = WCTRestClientErrorMake(@"add ResponseDescript fail", error);
            break;
        }
                
        //////////////////////////////////////////////////

        operation = [self postObject:nil
                     byObjectManager:objectManager
                                path:WCTClientPath_CRM_SearchSalesforceAccounts
                          parameters:@{@"keyword":keyword}
                httpHeaderParameters:@{@"X-Auth-Token":loginToken}
                             success:^(RKObjectRequestOperation *operation, RKMappingResult *mappingResult)
                     {
            
            // !! self.lastOperationDate 是用來記錄locken的生命周期，所以沒有用到loginTocken所以不紀錄時間
            self.lastOperationDate = [NSDate date];
            
            //////////////////////////////////////////////////
            
            if(success!=NULL)
            {
                success(mappingResult.firstObject);
            }
        }
                             failure:^(RKObjectRequestOperation *operation, NSError *error)
                     {
            //////////////////////////////////////////////////
            
            if(failure!=NULL)
            {
                failure(error);
            }
        }];
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    if(error!=nil && failure!=NULL)
    {
        failure(error);
    }
    
    //////////////////////////////////////////////////
    
    return operation;
}

@end
