//
//  WCTRestClient+Account.h
//  
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRestClient.h"

// Model
#import "WCTRCInLineModel.h"
#import "WCTRCResetPasswordResponseResult.h"
#import "WCTRCChangePasswordResponseResult.h"
#import "WCTRCAccountUploadLogoResponseResult.h"
#import "WCTRCAccountInfoResponseResult.h"
#import "WCTRCOtherAccountListResponseResult.h"

@interface WCTRestClient (Account)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  回傳 帳號縮圖
 *
 *  @param loginToken  登入 Token
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出去
 */
- (RKObjectRequestOperation *)accountLogoWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCInLineModel *inLineModel))success
                                                failure:(void (^)(NSError *error))failure;


/**
 *  重設使用者密碼
 *
 *  @param loginToken  登入 Token
 *  @param password    密碼
 *  @param success     成功 回傳
 *  @param failure     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)resetPasswordWithLoginToken:(NSString *)loginToken
                                                 password:(NSString *)password
                                                  success:(void (^)(WCTRCResetPasswordResponseResult *resetPasswordResponseResult))success
                                                  failure:(void (^)(NSError *error))failure;


/**
 *  變更使用者密碼
 *
 *  @param loginToken  登入 Token
 *  @param oldPassword 舊密碼
 *  @param newPassword  新密碼
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)changePasswordWithLoginToken:(NSString *)loginToken
                                               oldPassword:(NSString *)oldPassword
                                               newPassword:(NSString *)newPassword
                                                   success:(void (^)(WCTRCChangePasswordResponseResult *changePasswordResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;

/**
 *  上傳帳號縮圖
 *
 *  @param loginToken 登入 Token
 *  @param image  圖像資料
 *  @param fileName   圖像名稱
 *  @param mineType   圖像類型 WCTRC_MineType_JPG or WCTRC_MineType_PNG
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)uploadAccountLogoWithLoginToken:(NSString *)loginToken
                                                        image:(CPImage *)image
                                                     fileName:(NSString *)fileName
                                                     mineType:(NSString *)mineType
                                                      success:(void (^)(WCTRCAccountUploadLogoResponseResult *accountUploadLogoResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;


/**
 *  取得帳號的所有資訊
 *
 *  @param loginToken  登入Token
 *  @param success     成功 回傳
 *  @param failure     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)accountInfoWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCAccountInfoResponseResult *accountInfoResponseResult))success
                                                failure:(void (^)(NSError *error))failure;


/**
 *  取得其他帳號內些許資訊
 *
 *  @param loginToken  登入Token
 *  @param success     成功 回傳
 *  @param failure     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)otherAccountsInfoWithLoginToken:(NSString *)loginToken
                                                      success:(void (^)(WCTRCOtherAccountListResponseResult *accountInfoResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;


/**
 *  取得上司帳號資訊
 *
 *  @param loginToken  登入Token
 *  @param success     成功 回傳
 *  @param failure     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)accountBossWithLoginToken:(NSString *)loginToken
                                                success:(void (^)(WCTRCAccountInfoResponseResult *accountInfoResponseResult))success
                                                failure:(void (^)(NSError *error))failure;

/**
 *  取得下屬帳號資訊
 *
 *  @param loginToken  登入Token
 *  @param success     成功 回傳
 *  @param failure     失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)accountSubordinatesWithLoginToken:(NSString *)loginToken
                                                        success:(void (^)(WCTRCAccountInfoResponseResult *accountInfoResponseResult))success
                                                        failure:(void (^)(NSError *error))failure;


/**
 *  變更使用者密碼
 *
 *  @param loginToken  登入 Token
 *  @param displayName 新的display name
 *  @param success    成功 回傳
 *  @param failure    失敗 回傳
 *
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)changeDisplayNameWithLoginToken:(NSString *)loginToken
                                                  displayName:(NSString *)displayName
                                                      success:(void (^)(WCTRCMessageResponseResult *changeDisplayNameResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;
@end
