//
//  WCTPasswordExplanationView.m
//  
//
//  Created by Howard on 2016/5/30.
//
//

#import "WCTPasswordExplanationView.h"

// Define
#import "WCTPasswordViewController+ResourceDefine.h"
#import "WCTLoginController+ResourceDefine.h"
@interface WCTPasswordExplanationView ()

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) UITextView *explanationTextView;

@end


@implementation WCTPasswordExplanationView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithV6Server:(BOOL)v6Server
{
    if(self=[super init])
    {
        self.explanationTextView = [[[UITextView alloc] init] autorelease];
    
        if(self.explanationTextView!=nil)
        {
            self.explanationTextView.font = [UIFont systemFontOfSize:[UIFont systemFontSize]];
            
            //////////////////////////////////////////////////

            self.explanationTextView.userInteractionEnabled = NO;
            self.explanationTextView.backgroundColor = [UIColor clearColor];
            
            //////////////////////////////////////////////////
            if (v6Server)
            {
                self.explanationTextView.text = [NSString stringWithFormat:@"%@:\n1. %@\n2. %@\n3. %@",WCTPVC_MLS_Note,WCTLC_MLS_PasswordLengthLimit_v6,WCTLC_MLS_PasswordFormatLimit, WCTLC_MLS_PasswordDuplicateCharLimit];
            }
            else
            {
                self.explanationTextView.text = [NSString stringWithFormat:@"%@:\n1. %@\n2. %@",WCTPVC_MLS_Note,WCTLC_MLS_PasswordLengthLimit,WCTLC_MLS_PasswordFormatLimit];
            }
            
            self.explanationTextView.textColor = [UIColor darkGrayColor];
            
            [self addSubview:self.explanationTextView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [self.explanationTextView removeFromSuperview];
    self.explanationTextView = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of subview

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    self.explanationTextView.frame = CGRectMake(WCTPasswordViewControllerBottomLabelEdgeInset.left,
                                             0,
                                             self.bounds.size.width-WCTPasswordViewControllerBottomLabelEdgeInset.left-WCTPasswordViewControllerBottomLabelEdgeInset.right,
                                             self.bounds.size.height);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (CGFloat)appropriateHeight
{
    [self.explanationTextView sizeToFit];
    
    return self.explanationTextView.bounds.size.height*1.5;
}


@end
