//
//  WCTCPSController.m
//  
//
//  Created by Howard.Lin on 2014/6/5.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "WCTPasswordSectionController.h"

// Define
#import "WCTPasswordViewController+ParameterDefine.h"
#import "WCTPasswordViewController+ResourceDefine.h"

// Category
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCTPasswordSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (PPSectionModel *)originalPasswordSectionModel
{
    PPSectionModel *oringinalPasswordSectionModel = nil;
    
    do
    {
        oringinalPasswordSectionModel = [[[PPSectionModel alloc] init] autorelease];
        
        if(oringinalPasswordSectionModel==nil)
        {
            break;
        }
        
        oringinalPasswordSectionModel.section = WCTCPSControllerSection_OriginalPassword;
        oringinalPasswordSectionModel.title = WCTPVC_MLS_OldPassword;
        
        //////////////////////////////////////////////////
        
        PPRowModel *originalPasswordRowModel = [[[PPRowModel alloc] init] autorelease];
        
        if(originalPasswordRowModel==nil)
        {
            break;
        }
        
        originalPasswordRowModel.row = WCTCPSCSectionOriginalPassword_Row_OriginalPassword;
        originalPasswordRowModel.object = WCTPVC_MLS_ChangePassword;
        [oringinalPasswordSectionModel.rowModels addObject:originalPasswordRowModel];
        
    }
    while (0);
    
    return oringinalPasswordSectionModel;
}


//================================================================================
//
//================================================================================
- (PPSectionModel *)myNewPasswordSectionModel
{
    PPSectionModel *newPasswordSectionModel = nil;
    
    do
    {
        newPasswordSectionModel = [[[PPSectionModel alloc] init] autorelease];
        
        if(newPasswordSectionModel==nil)
        {
            break;
        }
        
        newPasswordSectionModel.section = WCTCPSControllerSection_NewPassword;
        newPasswordSectionModel.title = WCTPVC_MLS_NewPassword;
        
        //////////////////////////////////////////////////
        
        PPRowModel *newPasswordRowModel = [[[PPRowModel alloc] init] autorelease];
        
        if(newPasswordRowModel==nil)
        {
            break;
        }
        
        newPasswordRowModel.row = WCTCPSControllerSectionNewPassword_Row_NewPassword;
        newPasswordRowModel.object = WCTPVC_MLS_ChangePassword;
        [newPasswordSectionModel.rowModels addObject:newPasswordRowModel];
        
    }
    while (0);
    
    return newPasswordSectionModel;
}


//================================================================================
//
//================================================================================
- (PPSectionModel *)checkPasswordSectionModel
{
    PPSectionModel *checkPasswordSectionModel = nil;
    
    do
    {
        checkPasswordSectionModel = [[[PPSectionModel alloc] init] autorelease];
        
        if(checkPasswordSectionModel==nil)
        {
            break;
        }
        
        checkPasswordSectionModel.section = WCTCPSControllerSection_CheckPassword;
        checkPasswordSectionModel.title = WCTPVC_MLS_PleaseEnterPasswordAgain;
        
        //////////////////////////////////////////////////
        
        PPRowModel *checkPasswordRowModel = [[[PPRowModel alloc] init] autorelease];
        
        if(checkPasswordRowModel==nil)
        {
            break;
        }
        
        checkPasswordRowModel.row = WCTCPSControllerSectionCheckPassword_Row_CheckPassword;
        checkPasswordRowModel.object = WCTPVC_MLS_ChangePassword;
        [checkPasswordSectionModel.rowModels addObject:checkPasswordRowModel];
        
    }
    while (0);
    
    return checkPasswordSectionModel;
}


//================================================================================
//
//================================================================================
- (PPSectionModel *)showPasswordSectionModel
{
    PPSectionModel *showPasswordSecitonModel = nil;
    
    do
    {
        showPasswordSecitonModel = [[[PPSectionModel alloc] init] autorelease];
        
        if(showPasswordSecitonModel==nil)
        {
            break;
        }
        
        showPasswordSecitonModel.section = WCTCPSControllerSection_ShowPassword;
        
        //////////////////////////////////////////////////
        
        PPRowModel *showPasswordRowModel = [[[PPRowModel alloc] init] autorelease];
        
        if(showPasswordRowModel==nil)
        {
            break;
        }
        
        showPasswordRowModel.row = WCTCPSControllerSectionShowPassword_Row_ShowPassword;
        showPasswordRowModel.text = WCTPVC_MLS_ShowPassword;
        [showPasswordSecitonModel.rowModels addObject:showPasswordRowModel];
        
    }
    while (0);

    return showPasswordSecitonModel;
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)prepareDataWithChangePasswordViewControllerStyle:(WCTPasswordViewControllerStyle)style
{
    
    do
    {
        if(style==WCTPasswordViewControllerStyle_ChangePassword)
        {
            PPSectionModel *oringinalPasswordSectionModel = [self originalPasswordSectionModel];
            
            if(oringinalPasswordSectionModel==nil ||
               oringinalPasswordSectionModel.rowModels.count<=0)
            {
                break;
            }
            
            [[self sectionModelsForSearching:NO] addObject:oringinalPasswordSectionModel];
        }
        
        //////////////////////////////////////////////////
        
        PPSectionModel *newPasswordSectionModel = [self myNewPasswordSectionModel];
        
        if(newPasswordSectionModel==nil ||
           newPasswordSectionModel.rowModels.count<=0)
        {
            break;
        }
        
        [[self sectionModelsForSearching:NO] addObject:newPasswordSectionModel];
        
        //////////////////////////////////////////////////
        
        PPSectionModel *checkPasswordSectionModel = [self checkPasswordSectionModel];
        
        if(checkPasswordSectionModel==nil ||
           checkPasswordSectionModel.rowModels.count<=0)
        {
            break;
        }
        
        [[self sectionModelsForSearching:NO] addObject:checkPasswordSectionModel];
        
        //////////////////////////////////////////////////
        
        PPSectionModel *showPasswordSectionModel = [self showPasswordSectionModel];
        
        if(showPasswordSectionModel==nil ||
           showPasswordSectionModel.rowModels.count<=0)
        {
            break;
        }
        
        [[self sectionModelsForSearching:NO] addObject:showPasswordSectionModel];
    }
    while (0);
}
@end
