    //
//  WCTNoticeFlowController.m
//  Pods
//
//  Created by sanhue on 2016/9/6.
//
//

#import "WCTNoticeFlowController.h"

// define
#import "WCGroupDefine.h"
#import "WCTNoticeFlowController+ResourceDefine.h"
#import "WCTNoticeFlowController+SettingsKey.h"
#import "WCTFieldLengthDefine.h"
#import "WCTSettingsKey.h"

//model
#import "WCTGroupSyncActionModel.h"

//category
#import "NSObject+PPBusyView.h"
#import "WCGroupModel+WCTRCCategoryInfo.h"
#import "WCGroupModel+Tree.h"
#import "WCGroupModel+WCTRCCategoryInfoMultiLayer.h"

// view

// controller
#import "PPNavigationController.h"
#import "PPNetworkReachabilityController.h"
#import "PPSettingsController.h"
#import "PPWebSocketController.h"
#import "WCGroupAccessFlowController.h"
#import "WCTCRMExportResultViewController.h"
#import "WCTCRMFailedInfoViewController.h"
#import "WCTDataController.h"
#import "WCTNoticeContentViewController.h"
#import "WCTNoticeListViewController.h"
#import "WCTNoticePageViewController.h"
#import "WCToastController.h"
#import "WCTRestClientController.h"
#import "WCTSharedContactNoticeViewController.h"
#import "WCTMatomoController.h"

static WCTNoticeFlowController *staticNoticeFlowController = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTNoticeFlowController ()
<
PPScrollPageControllerDataSource,
PPScrollPageControllerDelegate,
PPWebSocketControllerDelegate,
WCGroupAccessFlowControllerDelegate,
WCTNoticeContentViewControllerDelegate,
WCTNoticeListViewControllerDelegate,
WCTSharedContactNoticeViewControllerDelegate,
WCTCRMExportResultViewControllerDelegate
>

@property (nonatomic, retain) NSMutableArray *categoryList;
@property (nonatomic, retain) NSArray *selectedGroupArray;

@property (nonatomic, retain) NSArray *noticeInfosForNoticePage;

@property (nonatomic, retain) NSString *accountRole;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTNoticeFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        [PPSettingsController setDefaultStringValue:WCTRC_NoticeCategory_All withKey:WCTNoticeFlowControllerSettingsKey_NoticeCategory];
        [PPSettingsController setDefaultStringValue:WCTRC_NoticeReadStatus_All withKey:WCTNoticeFlowControllerSettingsKey_NoticeReadStatus];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    
    self.categoryList = nil;
    self.selectedGroupArray = nil;
    self.noticeInfosForNoticePage = nil;
    self.accountRole = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare data


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)categoryListWithError:(NSError **)error
{
    NSError *returnError = nil;
    NSMutableArray *validCategoryList = nil;
    
    do
    {
        validCategoryList = [NSMutableArray array];
        
        if(validCategoryList==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        NSString *currentAccountID = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
        WCTRCMLCategoryInfoListResponseResult *categoryInfoListResponseResult = [[WCTRestClientController shareRestClientController] multiLayerCategoryListWithAccountGuid:currentAccountID
                                                                                                                                                                   error:&returnError];
        
        if([categoryInfoListResponseResult data]<=0)
        {
            break;
        }
        
        
        //////////////////////////////////////////////////
        
        // 轉換群組資料
        for(WCTRCCategoryInfoMultiLayer *categoryInfo in categoryInfoListResponseResult.data)
        {
            if([categoryInfo.categoryType compare:WCTRC_CategoryType_Favorite]==NSOrderedSame)
            {
                continue;
            }
            
            //////////////////////////////////////////////////
            
            WCGroupModel *groupModel = [WCGroupModel modelWithWCTRCCategoryInfoMultiLayer:categoryInfo];
            
            if(groupModel!=nil)
            {
                [validCategoryList addObject:groupModel];
            }
        }
        
        // 轉為樹狀
        WCGroupModel *rootModel = [WCGroupModel groupTreeWithGroups:validCategoryList];
        
        validCategoryList = [NSMutableArray arrayWithArray:rootModel.subGroups];
    }
    while (0);
    
    if (error!=NULL)
    {
        if (returnError)
        {
            *error = returnError;
        }
    }
    return validCategoryList;
}


//================================================================================
//
//================================================================================
- (void)contactCategoryOperationWithContactGuids:(NSArray *)contactGuids
                                    catgoryGuids:(NSArray *)categoryGuids
                                        complete:(void (^)(NSArray <WCTRCGuidWithData *> *errorDataList,NSError *error))complete
{
    __block NSError *returnError = nil;
    
    do
    {
        if([contactGuids count]<=0)
        {
            returnError = PPErrorParameterInvalidity(returnError);
            
            complete(nil,returnError);
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *behavior = WCTRC_Behavior_Add;
        
        //選到 Other 類別， 使用 OVERRITE + Nil Category 當參數
        if(categoryGuids==nil)
        {
            behavior = WCTRC_Behavior_Overwrite;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCContactSetCategoriesRequest *request = [[WCTRCContactSetCategoriesRequest alloc] init];
        
        if(request==nil)
        {
            break;
        }
        
        request.contactGuids = contactGuids;
        request.behavior = behavior;
        
        if([request.behavior compare:WCTRC_Behavior_Add]==NSOrderedSame)
        {
            request.categoryGuids = categoryGuids;
        }
        
        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            WCTRCPrivateContactOperateCategoryResponseResult *result = [[WCTRestClientController shareRestClientController] privateContactOperateCategoryWithContactSetCategoriesRequest:request
                                                                                                                                                                         progressHandler:^(CGFloat progress) {
                                                                                                                                                                             
                                                                                                                                                                             [PPBusyView postMessage:[NSString stringWithFormat:@"%.02f%%", progress*100.0]];
                                                                                                                                                                         }
                                                                                                                                                                                   error:&returnError];
            
            NSArray *errorDataList = [result.data retain];
            
            [request release];
            
            [returnError retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                complete(errorDataList,returnError);
                
                [errorDataList release];
                
                [returnError release];
            });
        });
    }
    while (0);
}


//==============================================================================
// 進入WCTNoticePageViewController後才可使用
//==============================================================================
- (NSInteger)noticeIndexByGuid:(NSString *)guid
{
    NSInteger index = 0;
    for (WCTRCNoticeInfo *noticeInfo in self.noticeInfosForNoticePage)
    {
        if ([noticeInfo.guid isEqualToString:guid])
        {
            return index;
        }
        
        index++;
    }
    
    return 0;
}


//==============================================================================
// 進入WCTNoticePageViewController後才可使用
//==============================================================================
- (WCTRCNoticeInfo *)noticeInfoWithIndex:(NSInteger)index
{
    if (index>=[self.noticeInfosForNoticePage count])
    {
        return nil;
    }
    
    return [self.noticeInfosForNoticePage objectAtIndex:index];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPWebSocketControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)webSocketControllerDidConnectedServer:(PPWebSocketController *)webSocketController
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
}


//==============================================================================
//
//==============================================================================
- (void)webSocketController:(PPWebSocketController *)webSocketController didReceiveMessage:(id)message
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
    
    NSError *error = nil;
    NSDictionary *jsonDict = [NSJSONSerialization JSONObjectWithData:[(NSString *)message dataUsingEncoding:NSUTF8StringEncoding]
                                    options:NSJSONReadingMutableContainers
                                      error:&error];
    if([jsonDict count]>0)
    {
        NSString *webSocketNotifyEvent = [jsonDict objectForKey:@"webSocketNotifyEvent"];
        if([webSocketNotifyEvent isEqualToString:@"NOTICE_COUNT_CHANGED"])
        {
            if([self.delegate respondsToSelector:@selector(wctNoticeFlowController:count:)])
            {
                // !! 再這邊取得notice count可能會因為token失效，造成又收到401，所以先不做
                [self.delegate wctNoticeFlowController:self count:0];

//                __block typeof(self) blockSelf = self;
//                
//                dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
//                    
//                    // TODO: 取得目前的通知數量
//                    NSInteger noticeCount = 0;//[WCTNoticeFlowController unreadNoticeCount];
//                    
//                    //////////////////////////////////////////////////
//                    dispatch_async(dispatch_get_main_queue(), ^{
//                        [blockSelf.delegate wctNoticeFlowController:blockSelf count:noticeCount];
//                    });
//                });
            }
        }
        else
        {
            if([self.delegate respondsToSelector:@selector(wctNoticeFlowControllerDidRequestLogout:)])
            {
                [self.delegate wctNoticeFlowControllerDidRequestLogout:self];
            }
        }
    }

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTNoticeContentViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSString *)noticeContentViewController:(WCTNoticeContentViewController *)noticeContentViewController requestErrorMessageWithError:(NSError *)error
{
    if ([self.delegate respondsToSelector:@selector(wctNoticeFlowController:requestErrorMessageWithError:)])
    {
        return [self.delegate wctNoticeFlowController:self requestErrorMessageWithError:error];
    }
    return nil;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTNoticeListViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSString *)noticeListViewController:(WCTNoticeListViewController *)noticeListViewController requestErrorMessageWithError:(NSError *)error
{
    if ([self.delegate respondsToSelector:@selector(wctNoticeFlowController:requestErrorMessageWithError:)])
    {
        return [self.delegate wctNoticeFlowController:self requestErrorMessageWithError:error];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)noticeListViewController:(WCTNoticeListViewController *)noticeListViewController didSelectNoticeInfo:(WCTRCNoticeInfo *)noticeInfo
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        // 取得內容會把這一筆通知設為已讀
//        NSError *error = nil;
//        [[WCTRestClientController shareRestClientController] noticeContentWithGuid:noticeInfo.guid error:&error];
//        
        // 建立pageViewController;
        self.noticeInfosForNoticePage = [noticeListViewController currentNoticeInfo];

        NSInteger pageIndex = [blockSelf noticeIndexByGuid:noticeInfo.guid];
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            WCTNoticePageViewController *noticePageViewController = [[WCTNoticePageViewController alloc] init];
            noticePageViewController.dataSource = blockSelf;
            noticePageViewController.delegate = blockSelf;
            noticePageViewController.currentPageIndex = pageIndex;
            [noticeListViewController.navigationController pushViewController:noticePageViewController animated:YES];
            [noticePageViewController release];
        });
    });
}


//==============================================================================
//
//==============================================================================
- (void)didFinishNoticeListViewController:(WCTNoticeListViewController *)noticeListViewController
{
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        self.noticeInfosForNoticePage = nil;
    });
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPScrollPageController


//================================================================================
//
//================================================================================
- (NSInteger)numberOfPageAtController:(PPScrollPageController *)scrollTabController
{
    return [self.noticeInfosForNoticePage count] ;
}


//================================================================================
// MARK: 設定點下通知後的頁面要長什麼樣子
//================================================================================
- (UIViewController *)scrollPageController:(PPScrollPageController *)scrollPageController viewControllerAtIndex:(NSInteger)index
{
    if (index>=[self.noticeInfosForNoticePage count])
    {
        return nil;
    }
    
    WCTRCNoticeInfo *noticeInfo = [self.noticeInfosForNoticePage objectAtIndex:index];
    
    if([noticeInfo.notifyCategory isEqualToString:WCTRC_NoticeCategory_Contact] &&
       [noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ContactBeShared])
    {
        // 顯示下載流程
        WCTSharedContactNoticeViewController *sharedConactNoticeViewController = [[[WCTSharedContactNoticeViewController alloc] initWithMode:PPSIC_M_None] autorelease ];
        sharedConactNoticeViewController.delegate = self;
        sharedConactNoticeViewController.titleString = WCTNoticeFlowControllerString_SharedNotice;
        sharedConactNoticeViewController.noticeInfo = noticeInfo;
        return sharedConactNoticeViewController;
    }
    else if([noticeInfo.notifyCategory isEqualToString:WCTRC_NoticeCategory_System] &&
            ([noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ContactExported] ||
             [noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithCRM]||
             [noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ExportedToExchangeServer]||
             [noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ContactSyncWithExchangeServer]))
        
    {
        
        WCTCRMExportResultViewController *viewController = [[[WCTCRMExportResultViewController alloc] init] autorelease ];
        viewController.delegate = self;
        viewController.titleString = WCTNoticeFlowControllerString_SystemNotice;
        viewController.noticeInfo = noticeInfo;
        
        if([noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ContactExported]||
           [noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ExportedToExchangeServer])
        {
            viewController.showSuccessInfo = YES;
        }
        else
        {
            viewController.showSuccessInfo = NO;
        }
        return viewController;
    }
    else
    {
        WCTNoticeContentViewController *noticeContentViewController = [[[WCTNoticeContentViewController alloc] init] autorelease];
        noticeContentViewController.delegate = self;
        noticeContentViewController.titleString = WCTNoticeFlowControllerString_NoticeType_System;
        noticeContentViewController.noticeInfo = noticeInfo;
        return noticeContentViewController;
    }
    return nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPScrollPageControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)scrollPageController:(PPScrollPageController *)scrollPageController didShowPageAtIndex:(NSInteger)index
{
    __block typeof(self) blockSelf = self;

    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        WCTRCNoticeInfo *noticeInfo = [blockSelf noticeInfoWithIndex:index];
        if (noticeInfo)
        {
            noticeInfo.viewed = YES;
            // 切換Title, 全選按鈕
            BOOL showSelectAll = NO;
            NSString *noticeTitle = WCTNoticeFlowControllerString_SystemNotice;
            if([noticeInfo.notifyCategory isEqualToString:WCTRC_NoticeCategory_Contact] &&
               [noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ContactBeShared])
            {
                noticeTitle = WCTNoticeFlowControllerString_SharedNotice;
                showSelectAll = YES;
            }
            else if([noticeInfo.notifyCategory isEqualToString:WCTRC_NoticeCategory_System] &&
               [noticeInfo.notifyType isEqualToString:WCTRC_NoticeType_ContactExported])
            {
                // CRM匯出通知也顯示系統通知
                noticeTitle = WCTNoticeFlowControllerString_SystemNotice;
            }
            //////////////////////////////////////////////////
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                WCTNoticePageViewController *noticePageViewController = (WCTNoticePageViewController *)scrollPageController;
                noticePageViewController.titleString = [NSString stringWithFormat:@"%@(%@/%@)",
                                                        noticeTitle,
                                                        @(index+1),
                                                        @([blockSelf.noticeInfosForNoticePage count])];
                noticePageViewController.showSelectAll = showSelectAll;
            });
        }
    });
    
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTSharedContactNoticeViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSString *)sharedContactNoticeViewController:(WCTSharedContactNoticeViewController *)sharedContactNoticeViewController requestErrorMessageWithError:(NSError *)error
{
    if ([self.delegate respondsToSelector:@selector(wctNoticeFlowController:requestErrorMessageWithError:)])
    {
        return [self.delegate wctNoticeFlowController:self requestErrorMessageWithError:error];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)sharedContactNoticeViewController:(WCTSharedContactNoticeViewController *)sharedContactNoticeViewController requestDownloadWithGuids:(NSArray *)guids
{    
    // !! 唯讀帳號不能下載
    if ([self.accountRole isEqualToString:WCTRC_Role_ReadOnlyUser])
    {
        [WCToastController showMessageToastFromSuperView:sharedContactNoticeViewController.view
                                             withMessage:WCTNoticeFlowControllerString_PermissionDenied
                                                position:PPToastPositionCenter];
        return ;
    }
    
    // 選取要下載到哪幾個類別
    [WCGroupAccessFlowController sharedInstance].delegate = self;
    [WCGroupAccessFlowController sharedInstance].userInfo = guids;
    [[WCGroupAccessFlowController sharedInstance] showMultiSelectGroupViewControllerFromViewController:sharedContactNoticeViewController
                                                                                           titleString:WCTNoticeFlowControllerString_DownloadContact
                                                                                          forcePresent:NO];
//    WCGroupViewController *downloadGroupSelectViewController = [[WCGroupViewController alloc] init];
//    downloadGroupSelectViewController.delegate = self;
//    downloadGroupSelectViewController.style = WCGroupSelectorViewControllerStyle_ChangeGroupWithoutAdd;
//    downloadGroupSelectViewController.titleString = WCTNoticeFlowControllerString_DownloadContact;
//    downloadGroupSelectViewController.userInfo = guids;
//    downloadGroupSelectViewController.maxGroupLength = WCT_FML_Group;
//
//    if([sharedContactNoticeViewController navigationController]==nil)
//    {
//        PPNavigationController * ppNavigationController = [[PPNavigationController alloc] initWithRootViewController:downloadGroupSelectViewController];
//        if (ppNavigationController)
//        {
//            [sharedContactNoticeViewController presentViewController:ppNavigationController animated:YES completion:nil];
//            [ppNavigationController release];
//        }
//    }
//    else
//    {
//        [sharedContactNoticeViewController.navigationController pushViewController:downloadGroupSelectViewController animated:YES];
//    }
//    [downloadGroupSelectViewController release];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTCRMExportResultViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)crmExportResultViewController:(WCTCRMExportResultViewController *)crmExportResultViewController didClickFailedWithNoticeInfo:(WCTRCNoticeInfo *)noticeInfo
{
    WCTCRMFailedInfoViewController *viewController = [[WCTCRMFailedInfoViewController alloc] initWithMode:PPSIC_M_None];
    
    viewController.noticeInfo = noticeInfo;
    if ([self.delegate respondsToSelector:@selector(userNameWithWCTNoticeFlowController:)])
    {
        viewController.userName = [self.delegate userNameWithWCTNoticeFlowController:self];
    }
    [crmExportResultViewController.navigationController pushViewController:viewController animated:YES];
    
    [viewController release];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCGroupAccessFlowControllerDelegate Method


//==============================================================================
// 取得錯誤訊息
//==============================================================================
- (NSString *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController requestErrorMessageForError:(NSError *)error
{
    if([self.delegate respondsToSelector:@selector(wctNoticeFlowController:requestErrorMessageWithError:)])
    {
        return [self.delegate wctNoticeFlowController:self requestErrorMessageWithError:error];
    }
    
    return nil;
}


//================================================================================
// MARK: 所有的群組清單
//================================================================================
- (NSMutableArray *)sourceGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController error:(NSError **)error
{
    self.categoryList = [self categoryListWithError:error];
    return self.categoryList;
}


//================================================================================
// MARK:詢問group名稱是否已存在，不存在才可以新增
//================================================================================
- (BOOL)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController requestIsExistGroupNamed:(NSString *)groupNamed
{
    for (WCGroupModel *groupModel in self.categoryList)
    {
        if([groupModel.name isEqualToString:groupNamed])
        {
            return YES;
        }
    }
    return NO;
}


//================================================================================
// MARK:新增按下確定後，通知要新增群組，並回傳新增後的群組資訊
//================================================================================
- (WCGroupModel *)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController requestGroupModelByNewGroupName:(NSString *)groupName superGroupGuid:(NSString *)superGroupGuid
{
    return nil;
//    if([groupName length]==0)
//    {
//        return nil;
//    }
//
//    WCGroupModel *groupModel = nil;
//
//    // TODO: 新增到local
//    WCTDataController *dataController = [[WCTDataController alloc] initWithAccessMode:WCDC_AM_Text];
//    WCTGroupSyncActionModel *groupSyncActionModel = nil;
//
//    groupSyncActionModel = [[WCTGroupSyncActionModel alloc] init];
//    groupSyncActionModel.dataGuid = [NSString GUID];
//    groupSyncActionModel.actionType = WCTSyncActionType_Add;
//    groupSyncActionModel.modifiedTime = [NSDate date];
//
//    groupModel = [dataController newGroupWithName:groupName syncActionModel:groupSyncActionModel];
//
//    //////////////////////////////////////////////////
//    // 新增到server
//    NSError *error = nil;
//
//    [[WCTRestClientController shareRestClientController] createCategoryWithCategoryName:groupName
//                                                              clientCreatedCategoryGuid:groupSyncActionModel.dataGuid
//                                                                                  error:&error];
//
//    [groupSyncActionModel release];
//    [dataController release];
//
//    //////////////////////////////////////////////////
//    // 記錄到categoryList
//    if (groupModel)
//    {
//        [self.categoryList addObject:groupModel];
//    }
//    return [groupModel autorelease];
}


//================================================================================
// MARK:已選擇的群組清單
//================================================================================
- (NSArray *)selectedGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController error:(NSError **)error
{
    // 這個要實作，才會預設勾選其他
    return nil;
}


//================================================================================
// MARK:點下完成時，通知選擇了哪些群組(WCGroupModel的Array, 未分類直接回傳nil)
//================================================================================
- (void)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController groupsDidSelected:(NSArray *)groupArray
{
    self.selectedGroupArray = groupArray;
}


//================================================================================
// MARK:點下完成, 處理完所有動作後，通知app
//================================================================================
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController didFinishViewController:(UIViewController *)viewController
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [viewController goRootAnimated:YES];
    });
    
    do
    {
        [viewController retain];
        
        if([self.selectedGroupArray count]==0)
        {
            break;
        }

        //////////////////////////////////////////////////

        id userInfo = [groupAccessFlowController userInfo];

        if([userInfo isKindOfClass:[NSArray class]]==NO)
        {
            break;
        }

        //////////////////////////////////////////////////

        NSArray *cardIDs = [userInfo retain];

        [self setBusy:@(YES)];

        //////////////////////////////////////////////////

        NSMutableArray *groupIDs = nil;

        for(WCGroupModel *groupModel in self.selectedGroupArray)
        {
            if(groupModel.ID==WC_GID_Unfiled)
            {
                continue;
            }

            //////////////////////////////////////////////////

            if(groupIDs==nil)
            {
                groupIDs = [NSMutableArray array];
            }

            //////////////////////////////////////////////////

            [groupIDs addObject:groupModel.guid];
        }

        self.selectedGroupArray = nil;

        //////////////////////////////////////////////////


        [self contactCategoryOperationWithContactGuids:cardIDs
                                          catgoryGuids:groupIDs
                                              complete:^(NSArray<WCTRCGuidWithData *> *errorDataList, NSError *error) {

                                                  [cardIDs release];
                                                  [self setBusy:@(NO)];

                                                  // MARK: !! matomo log (從通知下載)
                                                  if (error==nil)
                                                  {
                                                      [WCTMatomoController sendLogWithDownloadSource:WCTMatomoController_DownloadSource_Notification];
                                                  }
                                                  //////////////////////////////////////////////////


                                                  // MARK:下載多筆聯絡人失敗
                                                  if(errorDataList.count>0 && error==nil)
                                                  {
                                                      WCTRCGuidWithData *dataInfo = [errorDataList firstObject];

                                                      if([[dataInfo data] integerValue]==WCTServer_Common_ErrorCode_OverPrivateContactCountLimitation)
                                                      {
                                                          NSString *userName = nil;
                                                          if ([self.delegate respondsToSelector:@selector(userNameWithWCTNoticeFlowController:)])
                                                          {
                                                              userName = [self.delegate userNameWithWCTNoticeFlowController:self];
                                                          }
                                                          NSInteger maxContactCount = [PPSettingsController integerValueWithKey:WCTSettingsKey_MaxPrivateContactCount];
                                                          NSString *customMessage = [NSString stringWithFormat:WCTNoticeFlowControllerString_OverPrivateContactCountLimitation, userName, maxContactCount];

                                                          error = PPErrorMake([[dataInfo data] integerValue], customMessage, nil);
                                                      }
                                                      else
                                                      {
                                                          NSString *customMessage = [NSString stringWithFormat:WCTNoticeFlowControllerString_CouldntDonwloadSomeContacts, [errorDataList count]];
                                                          error = PPErrorMake([[dataInfo data] integerValue], customMessage, nil);
                                                      }
                                                  }

                                                  NSString *message = WCTNoticeFlowControllerString_DownloadSuccess;
                                                  if (error)
                                                  {
                                                      if ([self.delegate respondsToSelector:@selector(wctNoticeFlowController:requestErrorMessageWithError:)])
                                                      {
                                                          message = [self.delegate wctNoticeFlowController:self requestErrorMessageWithError:error];
                                                      }
                                                  }

                                                  [WCToastController showMessageToastFromSuperView:[[UIApplication sharedApplication].keyWindow.rootViewController presentedViewController].view
                                                                                       withMessage:message
                                                                                          position:PPToastPositionCenter];
                                              }];

    }
    while (0);

    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{

        self.categoryList = nil;
    });
    
    return nil;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (instancetype)shareInstance
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        staticNoticeFlowController = [[WCTNoticeFlowController alloc] init];
    });
    return staticNoticeFlowController;
}


//==============================================================================
//
//==============================================================================
+ (void)startListenWithURL:(NSString *)urlString delegate:(id<WCTNoticeFlowControllerDelegate>)delegate
{
    // !!先中斷原本的連線
    [self stopListen];
    
    [PPWebSocketController setDefaultURLString:urlString];
    [PPWebSocketController setDelegate:[self shareInstance]];
    
    WCTNoticeFlowController *noticeFlowController = [WCTNoticeFlowController shareInstance];
    noticeFlowController.delegate = delegate;
    
    [PPWebSocketController connect];
}


//==============================================================================
//
//==============================================================================
+ (void)stopListen
{
    [PPWebSocketController setDefaultURLString:nil];
    [PPWebSocketController setDelegate:nil];
    
    WCTNoticeFlowController *noticeFlowController = [WCTNoticeFlowController shareInstance];
    noticeFlowController.delegate = nil;
   
    [PPWebSocketController disconnect];
}


//==============================================================================
//
//==============================================================================
+ (void)showNoticeFromViewController:(UIViewController *)viewController accountRole:(NSString *)accountRole
{
    if([PPNetworkReachabilityController checkForInternetConnection]==NO)
    {
        [WCToastController showMessageToastFromSuperView:viewController.view
                                             withMessage:WCTNoticeFlowControllerString_FailedToConnectInternet
                                                position:PPToastPositionCenter];
        return ;
    }

    //////////////////////////////////////////////////
    [WCTNoticeFlowController shareInstance].accountRole = accountRole;
    if([WCTNoticeFlowController shareInstance].delegate==nil)
    {
        [WCTNoticeFlowController shareInstance].delegate = (id<WCTNoticeFlowControllerDelegate>)viewController;
    }
    WCTNoticeListViewController *noticeListViewController = [[WCTNoticeListViewController alloc] init];
    noticeListViewController.delegate = [WCTNoticeFlowController shareInstance];
    noticeListViewController.noNoticeString = WCTNoticeFlowControllerString_NoNotice;

    PPNavigationController * ppNavigationController = [[PPNavigationController alloc] initWithRootViewController:noticeListViewController];
    if (ppNavigationController)
    {
        [viewController presentViewController:ppNavigationController animated:YES completion:nil];
        [ppNavigationController release];
    }
    [noticeListViewController release];
}


//==============================================================================
//
//==============================================================================
+ (NSInteger)unreadNoticeCount
{
    NSInteger noticeCount = -1;
    NSError *error = nil;
    WCTRCLongResponseResult *responseResult = [[WCTRestClientController shareRestClientController] unreadNoticeWithNoticeCategory:WCTRC_NoticeCategory_All error:&error];
    if(responseResult!=nil && error == nil)
    {
        noticeCount = responseResult.data;
    }
    
    return noticeCount;
}


@end
