//
//  WCTNoticeFlowController.h
//  Pods
//
//  Created by sanhue on 2016/9/6.
//
//

#import <Foundation/Foundation.h>

@class WCTNoticeFlowController;

@protocol WCTNoticeFlowControllerDelegate <NSObject>

@optional
/**
 * 客制化錯誤訊息
 * @param wctNoticeFlowController WCTNoticeFlowController instance
 * @param error 要客制的錯誤
 * @return 錯誤訊息
 */
- (NSString *)wctNoticeFlowController:(WCTNoticeFlowController *)wctNoticeFlowController requestErrorMessageWithError:(NSError*)error;


/**
 * 回報目前的使用者名稱
 *
 * @param wctNoticeFlowController WCTNoticeFlowController instance
 * @return userName 使用者名稱
 */
- (NSString *)userNameWithWCTNoticeFlowController:(WCTNoticeFlowController *)wctNoticeFlowController;

/**
 * 回報目前的通知數量
 *
 * @param wctNoticeFlowController WCTNoticeFlowController instance
 * @param count current notice count, -1表示取得失敗
 *
 */
- (void)wctNoticeFlowController:(WCTNoticeFlowController *)wctNoticeFlowController count:(NSInteger)count;

/**
 * 收到登出通知
 *
 * @param wctNoticeFlowController WCTNoticeFlowController instance
 *
 */
- (void)wctNoticeFlowControllerDidRequestLogout:(WCTNoticeFlowController *)wctNoticeFlowController;

@end

@interface WCTNoticeFlowController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - property

@property (atomic, assign) id<WCTNoticeFlowControllerDelegate> delegate;






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - methods

/**
 * 開啟監聽web socket的訊息
 * @param urlString web socket的傳線URL
 * @param delegate 通知目前通知數量變更
 */
+ (void)startListenWithURL:(NSString *)urlString delegate:(id<WCTNoticeFlowControllerDelegate>)delegate;

/**
 * 停止監聽web socket的訊息
 */
+ (void)stopListen;

/**
 * 顯示通知列表頁面
 * @param viewController 要顯示列表的view controller
 * @param accountRole 帳號角色，可以是WCTRC_Role_NormalUser，WCTRC_Role_ReadOnlyUser，WCTRC_Role_Admin
 */
+ (void)showNoticeFromViewController:(UIViewController *)viewController accountRole:(NSString *)accountRole;


/**
 * 取得目前未讀的通知筆數
 * @return NSInteger -1表示取得失敗
 */
+ (NSInteger)unreadNoticeCount;
@end
