//
//  WCTNoticePageViewController.m
//  Pods
//
//  Created by sanhue on 2016/10/20.
//
//

#import "WCTNoticePageViewController.h"

// define
#import "WCAppearanceDefine.h"
#import "WCTNoticeFlowController+ResourceDefine.h"

// view
#import "PPNavigationBarView.h"

// category
#import "PPButton+Factory.h"


typedef NS_ENUM(NSInteger, WCTNoticePageViewControllerButtonTag)
{
    WCTNoticePageViewControllerButtonTag_Back = 0,
    WCTNoticePageViewControllerButtonTag_SelectAll,
};


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTNoticePageViewController () <PPButtonDelegate>

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPButton *ppButtonSelectAll;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTNoticePageViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.showSelectAll = YES;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self removeNavigationBarView];
    
    self.titleString = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareNavigationBarView];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeNavigationBarView];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui

//==============================================================================
//
//==============================================================================
- (void)prepareNavigationBarView
{
    self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCTNoticePageViewControllerButtonTag_Back
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    
    self.ppButtonSelectAll = [PPButton ppButtonWithIconImageName:WCTNoticeFlowControllerIcon_SelectAll
                                                             tag:WCTNoticePageViewControllerButtonTag_SelectAll
                                                        delegate:self
                                           normalBackgroundColor:nil
                                      highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                 imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];

    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        [self.ppNavigationBarView.titleLabel setText:self.titleString];
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.ppButtonSelectAll)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonSelectAll];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Right];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeNavigationBarView
{
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppButtonBack = nil;
    self.ppButtonSelectAll = nil;
    
    self.ppNavigationBarView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - setter/getter


//==============================================================================
//
//==============================================================================
- (void)setTitleString:(NSString *)titleString
{
    [titleString retain];
    [_titleString release];
    _titleString = titleString;
    
    //////////////////////////////////////////////////
    
    if(self.ppNavigationBarView)
    {
        [self.ppNavigationBarView.titleLabel setText:titleString];
    }
}


//==============================================================================
//
//==============================================================================
- (void)setShowSelectAll:(BOOL)showSelectAll
{
    _showSelectAll = showSelectAll;
    //////////////////////////////////////////////////
    
    [self.ppButtonSelectAll setHidden:!self.showSelectAll];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTNoticePageViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        case WCTNoticePageViewControllerButtonTag_SelectAll:
        {
            // 如果是分享通知才會有全選動作
            UIViewController *viewController = [self viewControllerAtIndex:self.currentPageIndex];
            if ([viewController isKindOfClass:NSClassFromString(@"WCTSharedContactNoticeViewController")])
            {
                [viewController performSelector:@selector(onSelectAll)];
            }
            
            break;
        }
        default:
            break;
    }
}





@end
