//
//  WCTNoticeListViewController.m
//  Pods
//
//  Created by sanhue on 2016/9/6.
//
//

#import "WCTNoticeListViewController.h"


// define
#import "WCAppearanceDefine.h"
#import "WCTNoticeFlowController+ResourceDefine.h"
#import "WCTNoticeFlowController+SettingsKey.h"

// model
#import "WCTNoticeFilterItemModel.h"

//category
#import "PPButton+Factory.h"
#import "NSObject+PPBusyView.h"
#import "NSDate+Format.h"

// view
#import "PPNavigationBarView.h"
#import "PPTableView.h"
#import "WCTNoticeListCell.h"

// controller
#import "PPSectionController.h"
#import "PPRefreshController.h"
#import "WCTRestClientController.h"
#import "PPSettingsController.h"
#import "PPSelectItemViewController.h"
#import "WCToastController.h"
#import "PPNetworkReachabilityController.h"

// TODO: 等server修改為可以吃-1
NSInteger const WCTNoticeListViewControllerPageSize = 100000;

NSString *const WCTNoticeListViewControllerCellIdentifier = @"NoticeCell";
NSString *const WCTNoticeListViewControllerSettingsKey_NoticeFilter = @"WCTNoticeListViewControllerSettingsKey_NoticeFilter";

typedef NS_ENUM(NSInteger, WCTNoticeListViewControllerButtonTag)
{
    WCTNoticeListViewControllerButtonTag_Back = 100,
    WCTNoticeListViewControllerButtonTag_Filter,
    WCTNoticeListViewControllerButtonTag_FilterBack = 200,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTNoticeListViewController ()
<
PPButtonDelegate,
PPRefreshControllerDelegate,
PPSelectItemViewControllerDelegate,
UITableViewDataSource,
UITableViewDelegate
>

@property (nonatomic, retain) PPSectionController *sectionController;
@property (nonatomic, retain) PPRefreshController *refreshController;

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPButton *ppButtonFilter;

@property (nonatomic, retain) PPTableView *noticeList;
@property (nonatomic, retain) UILabel *noNoticeLabel;

@property (nonatomic, retain) NSArray *layoutConstraints;
@property (nonatomic, retain) NSMutableArray *currentNotices;
@property (nonatomic, retain) NSMutableArray *supportedNoticeFilterItems;

/// 用來把計算後的cellHeight儲存下來，以加快顯示畫面的速度
@property (nonatomic, retain) NSMutableDictionary *cellHeightDict;

@property (nonatomic, assign) NSInteger currentNoticePageIndex;
@property (nonatomic, assign) NSInteger maxPageIndex;

@property (atomic, assign) NSInteger needReloadOnAppear;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTNoticeListViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.needReloadOnAppear = YES;
        
        self.sectionController = [[[PPSectionController alloc] init] autorelease];
        // 建立refresh controller
        self.refreshController = [PPRefreshController refreshControllerWithDelegate:self];
        if(self.refreshController!=nil)
        {
            self.refreshController.enabled = YES;
            self.refreshController.backgroundColor = WCTNoticeLoadInfoViewAppearance_BackgroundColor;
            // 設定indicator顏色
            [[PPActivityIndicatorView appearance] setLineColor:WCTNoticeLoadInfoViewAppearance_IndicatorColor];
        }

        self.refreshController.infoPosition = PPRefreshControllerInfoPosition_Bottom;
        
        self.cellHeightDict = [NSMutableDictionary dictionary];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    
    [self removeLayoutConstraints];
    [self removeNavigationBarView];
    [self removeMainUI];
    
    self.refreshController = nil;
    self.sectionController = nil;
    self.currentNotices = nil;
    self.supportedNoticeFilterItems = nil;
    self.cellHeightDict = nil;
    
    self.noNoticeString = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    [self prepareNavigationBarView];
    [self prepareMainUI];
    
    //////////////////////////////////////////////////
    if(self.needReloadOnAppear)
    {
        // !! 要重load時要清掉相關設定
        self.currentNotices = nil;
        self.maxPageIndex = 0;
        self.currentNoticePageIndex = 0;
        
        [self loadDataByRefresh:NO];
        self.needReloadOnAppear = NO;
    }
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    self.refreshController.targetScrollView = self.noticeList;
    
    //////////////////////////////////////////////////
    [super viewDidAppear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [self.refreshController hideInfoView];
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    [self removeNavigationBarView];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareNavigationBarView
{
    self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCTNoticeListViewControllerButtonTag_Back
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];

    self.ppButtonFilter = [PPButton ppButtonWithIconImageName:WCTNoticeFlowControllerIcon_Filter
                                                        tag:WCTNoticeListViewControllerButtonTag_Filter
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];

    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.ppButtonFilter)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonFilter];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Right];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }
    
    //////////////////////////////////////////////////
    [self updateTitleBySettings];

}


//==============================================================================
//
//==============================================================================
- (void)removeNavigationBarView
{
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppButtonFilter = nil;
    
    self.ppButtonBack = nil;
    
    self.ppNavigationBarView = nil;
}


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.noticeList = [[[PPTableView alloc] init] autorelease];
    if(self.noticeList)
    {
        [self.noticeList setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.noticeList.dataSource = self;
        self.noticeList.delegate = self;
        
        self.noticeList.separatorStyle = UITableViewCellSeparatorStyleSingleLine;
        [self.noticeList setSeparatorColor:WCAppearanceDefine_SeparatorColor];

        self.noticeList.rowHeight = [WCTNoticeListCell defaultCellHeight];
        self.noticeList.estimatedRowHeight = [WCTNoticeListCell defaultCellHeight];
        
        [self.view addSubview:self.noticeList];
    }
    
    //////////////////////////////////////////////////
    self.noNoticeLabel = [[[UILabel alloc] init] autorelease];
    
    if (self.noNoticeLabel)
    {
        [self.noNoticeLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
        
        self.noNoticeLabel.font = [UIFont boldSystemFontOfSize:20];
        self.noNoticeLabel.textColor = [UIColor grayColor];
        self.noNoticeLabel.backgroundColor = [UIColor clearColor];
        self.noNoticeLabel.textAlignment = NSTextAlignmentCenter;

        [self.noNoticeLabel setText:self.noNoticeString?:@"No notice"];
        [self.view addSubview:self.noNoticeLabel];
    }
    

    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    
    //////////////////////////////////////////////////
    
    [self.noNoticeLabel removeFromSuperview];
    self.noNoticeLabel = nil;
    
    [self.noticeList removeFromSuperview];
    self.noticeList = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare data


//==============================================================================
//
//==============================================================================
- (void)loadDataByRefresh:(BOOL)refresh
{
    if (refresh==NO)
    {
        [self setBusy:@(YES)];
    }
    
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        NSMutableArray *allNotice = nil;
        NSMutableArray *addedIndexPathes = nil;
       
        //////////////////////////////////////////////////
        // MARK:讀取通知資料
        NSError *error = nil;
        NSString *noticeCategory = [PPSettingsController stringValueWithKey:WCTNoticeFlowControllerSettingsKey_NoticeCategory];
        NSString *noticeReadStatus = [PPSettingsController stringValueWithKey:WCTNoticeFlowControllerSettingsKey_NoticeReadStatus];
                
        // !! 先取得總筆數
        WCTRCNoticeListPageResponseResult *noticeListResponseResult =
        [[WCTRestClientController shareRestClientController] noticeListPageWithNoticeCategory:noticeCategory
                                                                             noticeReadStatus:noticeReadStatus
                                                                                    pageIndex:self.currentNoticePageIndex
                                                                                     pageSize:WCTNoticeListViewControllerPageSize
                                                                                    sortField:WCTRC_NoticeSortField_Time
                                                                                sortDirection:WCTRC_NoticeSortDirection_DESC
                                                                                        error:&error];
        
        if(noticeListResponseResult)
        {
            // 記錄最多可以幾頁
            if (noticeListResponseResult.totalPages>0)
            {
                self.maxPageIndex = noticeListResponseResult.totalPages-1;
                
                // 如果這一次load完是最後一頁，就不能再load
                self.refreshController.enabled = (self.currentNoticePageIndex<self.maxPageIndex);

            }
            
            //////////////////////////////////////////////////
            // 準備暫存資料
            PPSectionModel *sectionModel = nil;
            
            if(self.currentNotices==nil)
            {
                allNotice = [NSMutableArray array];
                sectionModel = [[PPSectionModel alloc] init];
                [allNotice addObject:sectionModel];
                [sectionModel release];
            }
            else
            {
                allNotice = [NSMutableArray arrayWithArray:self.currentNotices];
            }
            
            for (WCTRCNoticeInfo *noticeInfo in noticeListResponseResult.data)
            {
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:0
                                                              text:noticeInfo.notifyContent
                                                        detailText:[noticeInfo.notifyTime stringWithFormat:NSDateFormat_Minute]
                                                            object:noticeInfo];
                
                // !! 一定都要加入all
                rowModel.row = [allNotice count];
                [[(PPSectionModel *)[allNotice firstObject] rowModels] addObject:rowModel];
                
                // 如果已有資料，記錄新增的sectionIndex
                if(self.currentNotices!=nil)
                {
                    [addedIndexPathes addObject:[NSIndexPath indexPathForRow:rowModel.row inSection:0]];
                }
            }
            //////////////////////////////////////////////////
            // test: add CRM export result
//            WCTRCNoticeInfo *noticeInfo = [[WCTRCNoticeInfo alloc] init];
//            noticeInfo.guid = [NSString GUID];
//            noticeInfo.notifyType = WCTRC_NoticeType_ContactExported;
//            noticeInfo.notifyCategory = WCTRC_NoticeCategory_System;
//            noticeInfo.senderName = @"test";
//            noticeInfo.notifyTime = [NSDate date];
//            noticeInfo.notifyContent = @"{\"numSucceeded\": 0,\"numFailed\": 3,\"failedList\": [{\"guid\": \"0ed867e2-a42e-41a4-a3ab-f36410a89aef\",\"data\": \"Fail to create new lead. The Company field is required.\"}]}";
//            
//            PPRowModel *rowModel = [PPRowModel rowModelWithRow:0
//                                                          text:noticeInfo.notifyContent
//                                                    detailText:[noticeInfo.notifyTime stringWithFormat:NSDateFormat_Minute]
//                                                        object:noticeInfo];
//            
//            // !! 一定都要加入all
//            rowModel.row = [allNotice count];
//            [[(PPSectionModel *)[allNotice firstObject] rowModels] addObject:rowModel];
//            
//            // 如果已有資料，記錄新增的sectionIndex
//            if(self.currentNotices!=nil)
//            {
//                [addedIndexPathes addObject:[NSIndexPath indexPathForRow:rowModel.row inSection:0]];
//            }
        }
        [error retain];

        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(error)
            {
                NSString *errorMessage = nil;
                NSError *customError = PPErrorMake(1, WCTNoticeFlowControllerString_FailedToConnectInternet, error);
                
                if ([self.delegate respondsToSelector:@selector(noticeListViewController:requestErrorMessageWithError:)])
                {
                    errorMessage = [self.delegate noticeListViewController:self requestErrorMessageWithError:customError];
                }

                if([errorMessage length]>0)
                {
                    [WCToastController showMessageToastFromSuperView:blockSelf.view
                                                         withMessage:errorMessage
                                                            position:PPToastPositionCenter];
                }
                
                if(refresh==NO)
                {
                    [blockSelf setBusy:@(NO)];
                }
                
                // 等0.3秒後，退出頁面
                dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                    
                    [self goBackAnimated:YES];
                });
            }
            else
            {
                // 更新
                [blockSelf setSectionData:allNotice addedIndexPathes:addedIndexPathes reload:YES];
                blockSelf.currentNotices = allNotice;
                
                [blockSelf updateTitleBySettings];

                //////////////////////////////////////////////////
                if(refresh==NO)
                {
                    [blockSelf setBusy:@(NO)];
                }
                else
                {
                    [blockSelf.refreshController hideInfoView];
                }
            }
            
            [error release];
        });
    });
    
}

//==============================================================================
//
//==============================================================================
- (void)setSectionData:(NSArray*)sectionData addedIndexPathes:(NSArray *)addedIndexPathes reload:(BOOL)reload
{
    [self.sectionController replaceSectionModels:sectionData forSearching:NO];
    
    if(reload)
    {
        if([addedIndexPathes count]>0)
        {
            [self.noticeList insertRowsAtIndexPaths:addedIndexPathes withRowAnimation:UITableViewRowAnimationAutomatic];
        }
        else
        {
            [self.noticeList reloadData];
            [self.noticeList scrollRectToVisible:CGRectMake(0, 0, 10, 10) animated:YES];
        }
    }
}


//==============================================================================
//
//==============================================================================
- (void)updateTitleBySettings
{
    NSString *noticeCategory = [PPSettingsController stringValueWithKey:WCTNoticeFlowControllerSettingsKey_NoticeCategory];
    NSString *noticeReadStatus = [PPSettingsController stringValueWithKey:WCTNoticeFlowControllerSettingsKey_NoticeReadStatus];
 
    NSMutableString *title = [NSMutableString stringWithFormat:@"%@", WCTNoticeFlowControllerString_Notice];
    
    NSString *filter = [self filterNameWithNoticeCategory:noticeCategory readStatus:noticeReadStatus];
    
    if([filter length]>0)
    {
        [title appendFormat:@" (%@)", filter];
    }
    
    [self.ppNavigationBarView.titleLabel setText:title];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.noticeList==nil||
       self.noNoticeLabel==nil)
    {
        return ;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"noticeList":self.noticeList,
                            @"noNoticeLabel":self.noNoticeLabel};

    NSDictionary *metrics = @{@"cellHeight":@([WCTNoticeListCell defaultCellHeight])};
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[noticeList]|"
                                                                                  options:NSLayoutFormatDirectionLeftToRight
                                                                                  metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[noticeList]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[noNoticeLabel]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[noNoticeLabel(cellHeight)]"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare filter


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)supportedNoticeFilterItems
{
    if(_supportedNoticeFilterItems!=nil)
    {
        return _supportedNoticeFilterItems;
    }
    else
    {
        _supportedNoticeFilterItems = [[NSMutableArray array] retain];
        
        [_supportedNoticeFilterItems addObject:[WCTNoticeFilterItemModel noticeFilterItemWithName:WCTNoticeFlowControllerString_NoticeType_All
                                                                                   noticeCategory:WCTRC_NoticeCategory_All
                                                                                       readStatus:WCTRC_NoticeReadStatus_All]];
        [_supportedNoticeFilterItems addObject:[WCTNoticeFilterItemModel noticeFilterItemWithName:WCTNoticeFlowControllerString_NoticeType_Contacts
                                                                                   noticeCategory:WCTRC_NoticeCategory_Contact
                                                                                       readStatus:WCTRC_NoticeReadStatus_All]];
        [_supportedNoticeFilterItems addObject:[WCTNoticeFilterItemModel noticeFilterItemWithName:WCTNoticeFlowControllerString_NoticeType_System
                                                                                   noticeCategory:WCTRC_NoticeCategory_System
                                                                                       readStatus:WCTRC_NoticeReadStatus_All]];
        [_supportedNoticeFilterItems addObject:[WCTNoticeFilterItemModel noticeFilterItemWithName:WCTNoticeFlowControllerString_NoticeType_Unread
                                                                                   noticeCategory:WCTRC_CategoryType_All
                                                                                       readStatus:WCTRC_NoticeReadStatus_Unviewed]];
    }
    
    
    return _supportedNoticeFilterItems;
}


//==============================================================================
//
//==============================================================================
- (NSString *)filterNameWithNoticeCategory:(NSString *)noticeCategory readStatus:(NSString *)readStatus
{
    for (WCTNoticeFilterItemModel *noticeFilterItem in self.supportedNoticeFilterItems)
    {
        if ([noticeCategory isEqualToString:noticeFilterItem.noticeCategory] &&
            [readStatus isEqualToString:noticeFilterItem.readStatus])
        {
            return noticeFilterItem.itemName;
        }
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)noticeFilterSectionModels
{
    NSMutableArray *noticeFilterSectionModels = [NSMutableArray array];
    
    NSInteger row = 0;
    PPRowModel *rowModel = nil;
    
    NSString *noticeCategory = [PPSettingsController stringValueWithKey:WCTNoticeFlowControllerSettingsKey_NoticeCategory];
    NSString *noticeReadStatus = [PPSettingsController stringValueWithKey:WCTNoticeFlowControllerSettingsKey_NoticeReadStatus];

    PPSectionModel *noticeFilterSection = [PPSectionModel sectionModelWithSection:0 title:@"" rowModels:nil];
    [noticeFilterSectionModels addObject:noticeFilterSection];
    
    for (WCTNoticeFilterItemModel *noticeFilterItem in self.supportedNoticeFilterItems)
    {
        BOOL isSelected = NO;
        if ([noticeCategory isEqualToString:noticeFilterItem.noticeCategory] &&
            [noticeReadStatus isEqualToString:noticeFilterItem.readStatus])
        {
            isSelected = YES;
        }
        
        rowModel = [PPRowModel rowModelWithRow:row++
                                          text:noticeFilterItem.itemName
                                    detailText:nil
                                        object:isSelected?@(YES):nil];

        [noticeFilterSection.rowModels addObject:rowModel];
    }
    
    return noticeFilterSectionModels;
}


//==============================================================================
//
//==============================================================================
- (PPSelectItemViewController *)noticeFilterSelectViewController
{
    PPSelectItemViewController *noticeFilterSelectViewController = [[PPSelectItemViewController alloc] init];
    noticeFilterSelectViewController.title = WCTNoticeFlowControllerString_Notice;
    noticeFilterSelectViewController.defaultBarViewStyle = PPBarViewStyle_CenteredAbsolute;
    noticeFilterSelectViewController.delegate = self;
    [noticeFilterSelectViewController.ppSectionController.sectionModelsForDefault addObjectsFromArray:[self noticeFilterSectionModels]];
    
    return noticeFilterSelectViewController;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - button action


//==============================================================================
//
//==============================================================================
- (void)onClickNoticeFilter
{
    PPSelectItemViewController *noticeFilterSelectViewController = [self noticeFilterSelectViewController];
    
    [self.navigationController pushViewController:noticeFilterSelectViewController animated:YES];
    
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        switch (ppButton.tag)
        {
            case WCTNoticeListViewControllerButtonTag_Back:
            {
                [blockSelf goBackAnimated:YES];
                if([self.delegate respondsToSelector:@selector(didFinishNoticeListViewController:)])
                {
                    [self.delegate didFinishNoticeListViewController:self];
                }
                break;
            }
                
            case WCTNoticeListViewControllerButtonTag_Filter:
            {
                [blockSelf onClickNoticeFilter];
                break;
            }
            case WCTNoticeListViewControllerButtonTag_FilterBack:
            {
                [blockSelf goBackAnimated:YES];
                break;
            }
                
            default:
                break;
        }
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPRefreshControllerDelegate method

//================================================================================
//
//================================================================================
- (void)refreshControllerInfoViewDidAppear:(PPRefreshController *)refreshController
{
    if(self.currentNoticePageIndex<=self.maxPageIndex)
    {
        self.currentNoticePageIndex++;
        [self loadDataByRefresh:YES];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPSelectItemViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (void)ppSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController selectRowModel:(PPRowModel *)rowModel sectionModel:(PPSectionModel *)sectionModel
{
    for (WCTNoticeFilterItemModel *noticeFilterItem in self.supportedNoticeFilterItems)
    {
        if ([rowModel.text isEqualToString:noticeFilterItem.itemName])
        {
            NSString *noticeCategory = [PPSettingsController stringValueWithKey:WCTNoticeFlowControllerSettingsKey_NoticeCategory];
            NSString *noticeReadStatus = [PPSettingsController stringValueWithKey:WCTNoticeFlowControllerSettingsKey_NoticeReadStatus];

            if ([noticeCategory isEqualToString:noticeFilterItem.noticeCategory]==NO ||
                [noticeReadStatus isEqualToString:noticeFilterItem.readStatus]==NO)
            {
                [PPSettingsController setStringValue:noticeFilterItem.noticeCategory withKey:WCTNoticeFlowControllerSettingsKey_NoticeCategory];
                [PPSettingsController setStringValue:noticeFilterItem.readStatus withKey:WCTNoticeFlowControllerSettingsKey_NoticeReadStatus];
                
                self.needReloadOnAppear = YES;

            }
            
            //////////////////////////////////////////////////
            __block typeof(self) blockSelf = self;
            
            dispatch_async(dispatch_get_main_queue(), ^{
                [blockSelf goBackAnimated:YES];
            });
            break;
        }
    }
}


//==============================================================================
//
//==============================================================================
- (PPBarViewItemModel *)closeItemModelForSelectItemViewController:(PPSelectItemViewController *)ppSelectItemViewController
{
    PPBarViewItemModel * itemModel = nil;
    PPButton *ppButton =  [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCTNoticeListViewControllerButtonTag_FilterBack
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];

    if (ppButton)
    {
        itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:ppButton];
        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
    }
    
    return itemModel;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = [self.sectionController numberOfRowsInSection:section forSearching:NO];
    
    // 顯示或隱藏no notice label
    [self.noNoticeLabel setHidden:(numberOfRows>0)];
    return numberOfRows;
}


//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    WCTNoticeListCell *cell = [tableView dequeueReusableCellWithIdentifier:WCTNoticeListViewControllerCellIdentifier];
    
    if (cell==nil)
    {
        cell = [[[WCTNoticeListCell alloc] initWithReuseIdentifier:WCTNoticeListViewControllerCellIdentifier] autorelease];
    }
    
    // common settings
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    
    PPRowModel *rowModel = [[self.sectionController rowModelAtIndexPath:indexPath forSearching:NO] copy];
    
    // set data
    [cell setNoticeData:rowModel.object];
    
    [self.cellHeightDict setObject:@([cell cellHeight]) forKey:[(WCTRCNoticeInfo*)rowModel.object guid]];
    
    [rowModel release];
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    if([self.delegate respondsToSelector:@selector(noticeListViewController:didSelectNoticeInfo:)])
    {
        PPRowModel *rowModel = [self.sectionController rowModelAtIndexPath:indexPath forSearching:NO];

        [self.delegate noticeListViewController:self didSelectNoticeInfo:[rowModel object]];
    }
}


//==============================================================================
//
//==============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSInteger cellHeight = [WCTNoticeListCell defaultCellHeight];
    
    PPRowModel *rowModel = [self.sectionController rowModelAtIndexPath:indexPath forSearching:NO];
  
    if(rowModel)
    {
        WCTRCNoticeInfo *noticeInfo = [rowModel object];
        NSNumber *heightNumber = [self.cellHeightDict objectForKey:noticeInfo.guid];
        if(heightNumber!=nil)
        {
            cellHeight = [heightNumber integerValue];
        }
    }
    
    return (CGFloat)cellHeight;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (NSArray *)currentNoticeInfo
{
    NSMutableArray *result = [NSMutableArray array];
    
    for (PPSectionModel *sectionModel in self.currentNotices)
    {
        for (PPRowModel *rowModel in sectionModel.rowModels)
        {
            [result addObject:rowModel.object];
        }
    }
    return [NSArray arrayWithArray:result];
}


@end
