//
//  WCTNoticeListViewController.h
//  Pods
//
//  Created by sanhue on 2016/9/6.
//
//

#import <UIKit/UIKit.h>
#import "PPViewController.h"
#import "WCTRCNoticeInfo.h"

@class WCTNoticeListViewController;

@protocol WCTNoticeListViewControllerDelegate <NSObject>

- (void)noticeListViewController:(WCTNoticeListViewController *)noticeListViewController didSelectNoticeInfo:(WCTRCNoticeInfo *)noticeInfo;

- (void)didFinishNoticeListViewController:(WCTNoticeListViewController *)noticeListViewController;

@optional
- (NSString *)noticeListViewController:(WCTNoticeListViewController *)noticeListViewController requestErrorMessageWithError:(NSError *)error;

@end
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTNoticeListViewController : PPViewController


// delegate
@property (nonatomic, assign) id<WCTNoticeListViewControllerDelegate> delegate;

/// 指定沒有通知時要顯示的字串
@property (nonatomic, retain) NSString *noNoticeString;

- (NSArray *)currentNoticeInfo;
@end
