//
//  WCTNoticeListCell.m
//  Pods
//
//  Created by sanhue on 2016/9/8.
//
//

#import "WCTNoticeListCell.h"
#import "WCTNoticeFlowController+ResourceDefine.h"

#import "NSDate+Format.h"

NSInteger const WCTNoticeListCellNotifierWidth = 100;
NSInteger const WCTNoticeListCellMargin = 5;
NSInteger const WCTNoticeListCellTitleFontSize = 16;
NSInteger const WCTNoticeListCellTimeFontSize = 14;

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTNoticeListCell ()

// data
@property (nonatomic, retain) WCTRCNoticeInfo *dataModel;
@property (nonatomic, retain) NSArray *layoutConstraints;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTNoticeListCell





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithReuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithReuseIdentifier:reuseIdentifier];
    if (self)
    {
        self.contentInsets = UIEdgeInsetsMake(8, 15, 8, 8);
        
        [self.textLabel setLineBreakMode:NSLineBreakByWordWrapping];
        self.textLabel.numberOfLines = 0;
        
        [self.detailTextLabel setLineBreakMode:NSLineBreakByWordWrapping];
        self.detailTextLabel.numberOfLines = 0;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    
    self.dataModel = nil;
    self.layoutConstraints = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (void)setNoticeData:(WCTRCNoticeInfo *)noticeData
{
    self.dataModel = noticeData;
    
    //////////////////////////////////////////////////
    
    if(self.textLabel)
    {
        if (self.dataModel.viewed==NO)
        {
            // !! 粗體的字型小一號，這樣大小比較剛好
            [self.textLabel setFont:[UIFont boldSystemFontOfSize:(WCTNoticeListCellTitleFontSize)]];
        }
        else
        {
            [self.textLabel setFont:[UIFont systemFontOfSize:WCTNoticeListCellTitleFontSize]];
        }
        
        [self.textLabel setText:[self.dataModel localizedNoticeTitle]];
    }
    
    if(self.detailTextLabel)
    {
        [self.detailTextLabel setFont:[UIFont systemFontOfSize:WCTNoticeListCellTimeFontSize]];
        
        NSString *detailText  = [NSString stringWithFormat:@"%@\n%@",
                                 [self.dataModel localizedSenderName],
                                 [self.dataModel.notifyTime stringWithFormat:NSDateFormat_Second]];
        [self.detailTextLabel setText:detailText];
    }
    
    [super layoutSubviews];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (NSInteger)defaultCellHeight
{
    return 72;
}


@end
