//
//  WCTCRMFailedInfoViewController.m
//  Pods
//
//  Created by sanhue on 2016/12/21.
//
//

#import "WCTCRMFailedInfoViewController.h"
// define
#import "WCAppearanceDefine.h"
#import "WCTNoticeFlowController+ResourceDefine.h"
#import "WCTSettingsKey.h"
#import "WCTRCExportFailureReasonInfo_ErrorCodeDefine.h"

// category
#import "NSObject+PPBusyView.h"

//model
#import "WCCardSectionModel.h"
#import "WCCardModel.h"

//view
#import "PPNavigationBarView.h"
#import "PPButton.h"

//controller
#import "WCCompareTool.h"
#import "PPSectionController.h"
#import "WCTRestClientController.h"
#import "WCMakeVirtualCardController.h"
#import "WCTDataController.h"
#import "PPSettingsController.h"


typedef NS_ENUM(NSInteger, WCTCRMFailedInfoViewControllerButtonTag)
{
    WCTCRMFailedInfoViewControllerButtonTag_Back = 0,
};
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTCRMFailedInfoViewController () <PPButtonDelegate>

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;

@property (nonatomic, retain) NSMutableDictionary *cardImageCache;
@end



////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTCRMFailedInfoViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithMode:(PPSIC_Mode)mode;
{
    self = [super initWithMode:mode];
    if (self)
    {
        self.showSectionIndexView = NO;
        self.showSectionTitle = YES;
        
        self.cellType = WCCardHolderCellType_OnlyDisplayData;
        
        self.cardImageCache = [NSMutableDictionary dictionary];
        
#ifdef DEBUG
        self.enableLongPress = YES;
#endif
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.userName = nil;
    self.cardImageCache = nil;
    
    self.noticeInfo = nil;
    
    [self removeMainUI];
    
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];
    
    [self loadData];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{

    
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCTCRMFailedInfoViewControllerButtonTag_Back
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    
    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        [self.ppNavigationBarView.titleLabel setText:WCTNoticeFlowControllerString_CRMFailedReason];
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }
    

}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    //////////////////////////////////////////////////
    
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppButtonBack = nil;
    
    self.ppNavigationBarView = nil;

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare data


//==============================================================================
//
//==============================================================================
- (void)loadData
{
    [self setBusy:@(YES)];
    
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        // !! load failed data
        NSMutableArray *sectionModels = [NSMutableArray array];
        
        WCTRCCRMExportResult *exportResult = [blockSelf.noticeInfo crmExportResult];
        
//        NSInteger sectionID = 0;
        WCCardSectionModel *sectionModel = nil;// [[[WCCardSectionModel alloc] init] autorelease];

        for (WCTRCCRMFailureReasonInfo *failureReasonInfo in exportResult.failedList)
        {
            if(sectionModel==nil)
            {
                sectionModel = [[[WCCardSectionModel alloc] init] autorelease];
                sectionModel.needResortCard = YES;
                sectionModel.cardArray = [NSMutableArray array];
            }
            
            
            WCCardModel *cardModel = [[WCCardModel alloc] init];
            cardModel.ID = failureReasonInfo.guid;
            cardModel.displayName = failureReasonInfo.fullName;
            cardModel.displayCompany = failureReasonInfo.company;
                        
            NSString *reason = nil;
            if ([failureReasonInfo.data isEqualToString:WCTRCExportFailureReasonDefine_MaxContactNumberInDBReached])
            {
                NSInteger maxContactCount = [PPSettingsController integerValueWithKey:WCTSettingsKey_MaxServerContactCount];
                reason = [NSString stringWithFormat:[failureReasonInfo localizedFailureReason], maxContactCount];
            }
            else if ([failureReasonInfo.data isEqualToString:WCTRCExportFailureReasonDefine_MaxContactNumberOwningReached])
            {
                NSString *userName = self.userName?:@"";
                NSInteger maxContactCount = [PPSettingsController integerValueWithKey:WCTSettingsKey_MaxPublicContactCount];
                reason = [NSString stringWithFormat:[failureReasonInfo localizedFailureReason], userName, maxContactCount];
            }
            else if ([failureReasonInfo.data isEqualToString:WCTRCExportFailureReasonDefine_MaxContactNumberInPrivateReached])
            {
                NSString *userName = self.userName?:@"";
                NSInteger maxContactCount = [PPSettingsController integerValueWithKey:WCTSettingsKey_MaxPrivateContactCount];
                reason = [NSString stringWithFormat:[failureReasonInfo localizedFailureReason], userName, maxContactCount];
            }
            else
            {
                reason = [failureReasonInfo localizedFailureReason];
            }
            cardModel.displayJobTitle = reason;
            
            [sectionModel.cardArray addObject:cardModel];
            [cardModel release];
        }
        
        if (sectionModel!=nil)
        {
            [sectionModels addObject:sectionModel];
        }

        [WCCompareTool cardSectionArray:sectionModels sortByField:WC_SBF_Name];
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            blockSelf.allCardSectionArray = sectionModels;

            [blockSelf.tableView reloadData];
            
            [blockSelf setBusy:@(NO)];
        });
    });

}


//==============================================================================
//
//==============================================================================
- (WCCardModel *)cardModelWithID:(NSString*)cardID
{
    @synchronized (self)
    {
        for (WCCardSectionModel *sectionModel in self.allCardSectionArray)
        {
            for (WCCardModel *cardModel in sectionModel.cardArray)
            {
                if ([cardModel.ID isEqualToString:cardID])
                {
                    return cardModel;
                }
            }
        }
        
        return nil;
    }
}


//==============================================================================
//
//==============================================================================
- (UIImage *)loadThumbnailImageWithCardID:(NSString *)cardID
{
    UIImage *image = nil;

    // !! 這邊是operation中call進來，所以可以這樣取
    NSOperation *operation = [[[[NSOperationQueue currentQueue] operations] firstObject] retain];
    
    do {
        
        NSError *error = nil;
        
        // !! 先看有沒有在cache中
        if (self.cardImageCache)
        {
            image = [self.cardImageCache objectForKey:cardID];
            if (image!=nil)
            {
                break;
            }
        }

        //////////////////////////////////////////////////
        // !! 如果頁面關閉，不用在取圖
        if (operation.isCancelled)
        {
            break;
        }
        
        
        //////////////////////////////////////////////////
        // !! 先從local取圖
        WCTDataController *dataController = [[WCTDataController alloc] initWithAccessMode:WCDC_AM_All];
        image = [dataController displayCardImageWithCardID:cardID];
        [dataController release];
        
        //////////////////////////////////////////////////

        // !!先取大頭貼，再取名片圖
        image = [[WCTRestClientController shareRestClientController] privateContactImageWithContactGuid:cardID
                                                                                              imageType:WCTRC_ImageType_Logo
                                                                                                  error:&error];
        //////////////////////////////////////////////////
        // !! 如果頁面關閉，不用在取圖
        if (operation.isCancelled)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        if (image!=nil)
        {
            break;
        }

        //////////////////////////////////////////////////
        // 取得前名片圖
        image = [[WCTRestClientController shareRestClientController] privateContactImageWithContactGuid:cardID
                                                                                              imageType:WCTRC_ImageType_Front
                                                                                                  error:&error];
        //////////////////////////////////////////////////
        // !! 如果頁面關閉，不用在取圖
        if (operation.isCancelled)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        if (image!=nil)
        {
            break;
        }

        //////////////////////////////////////////////////
        // 都沒有，產生虛擬名片圖
        WCCardModel *cardModel = [self cardModelWithID:cardID];
        
        
        WCMakeVirtualCardController *makeVirtualCardController = [[WCMakeVirtualCardController alloc] init];
        makeVirtualCardController.cardModel = cardModel;
        image = [makeVirtualCardController virtualCardImage];
        [makeVirtualCardController release];
        
        //////////////////////////////////////////////////
        // !! 如果頁面關閉，不用在取圖
        if (operation.isCancelled)
        {
            break;
        }

    } while (0);
    
    
    //////////////////////////////////////////////////
    if (operation.isCancelled==NO &&
        image!=nil)
    {
        [self.cardImageCache setObject:image forKey:cardID];
        [operation release];
        return image;
    }
    
    [operation release];
    
    return nil;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTCRMFailedInfoViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        default:
            break;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTableViewControllerProtocol
// MARK: 目前改為不顯示名片圖，如果要的話這邊要打開
//
////==============================================================================
////
////==============================================================================
//- (UIImage *)cachedThumbnailImageWithCardID:(NSString *)cardID
//{
//    return nil;
//    
//}
//
//
//
////==============================================================================
////
////==============================================================================
//- (UIImage *)thumbnailImageWithCardID:(NSString *)cardID
//{
//    return [self loadThumbnailImageWithCardID:cardID];
//}


#ifdef DEBUG
//==============================================================================
//
//==============================================================================
- (void)longPressWithCell:(WCCardHolderCell *)cell
{
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"DEBUG"
                                                                             message:cell.jobTitleLabel.text
                                                                      preferredStyle:UIAlertControllerStyleAlert];
    
    [alertController addAction:[UIAlertAction actionWithTitle:@"OK"
                                                        style:UIAlertActionStyleCancel
                                                      handler:nil]];
    [self presentViewController:alertController animated:YES completion:nil ];
    
}
#endif





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelefgate


//==============================================================================
//
//==============================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    //////////////////////////////////////////////////
    
    WCCardHolderCell *cell = (WCCardHolderCell *)[self.tableView cellForRowAtIndexPath:indexPath];
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:WCTNoticeFlowControllerString_CRMFailedReason
                                                                             message:cell.jobTitleLabel.text
                                                                      preferredStyle:UIAlertControllerStyleAlert];
    
    [alertController addAction:[UIAlertAction actionWithTitle:WCTNoticeFlowControllerString_Ok
                                                        style:UIAlertActionStyleCancel
                                                      handler:nil]];
    [self presentViewController:alertController animated:YES completion:nil ];
}


@end
