//
//  WCTNotiecContentViewController.m
//  Pods
//
//  Created by sanhue on 2016/9/9.
//
//

#import "WCTNoticeContentViewController.h"

#import "WCAppearanceDefine.h"
#import "WCTNoticeFlowController+ResourceDefine.h"

//category
#import "PPButton+Factory.h"
#import "NSObject+PPBusyView.h"
#import "NSDate+Format.h"

// view
#import "PPNavigationBarView.h"
#import "PPTableView.h"
#import "PPAutoResizedLabel.h"

//controller
#import "PPSectionController.h"
#import "PPTextViewTableViewCell.h"
#import "WCTRestClientController.h"
#import "PPNetworkReachabilityController.h"
#import "WCToastController.h"



NSString *const WCTNoticeContentViewControllerCellIdentifier = @"NoticeContentCell";

typedef NS_ENUM(NSInteger, WCTNoticeContentViewControllerButtonTag)
{
    WCTNoticeContentViewControllerButtonTag_Back = 0,
};


NSInteger const WCTNoticeContentViewControllerTitleFontSize = 16;
NSInteger const WCTNoticeContentViewControllerContentFontSize = 16;
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTNoticeContentViewController () <PPButtonDelegate, UITableViewDelegate, UITableViewDataSource>

@property (nonatomic, retain) PPSectionController *sectionController;

@property (nonatomic, retain) PPTableView *noticeList;
@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;

@property (nonatomic, retain) NSArray *layoutConstraints;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTNoticeContentViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.sectionController = [[[PPSectionController alloc] init] autorelease];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self removeMainUI];
    
    self.noticeInfo = nil;
    self.titleString = nil;
    self.sectionController = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];
    
    [self loadData];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCTNoticeContentViewControllerButtonTag_Back
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        [self.ppNavigationBarView.titleLabel setText:self.titleString?:@""];
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }
    
    self.noticeList = [[[PPTableView alloc] init] autorelease];
    if(self.noticeList)
    {
        [self.noticeList setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.noticeList.dataSource = self;
        self.noticeList.delegate = self;
        
        [self.noticeList setBackgroundColor:WCAppearanceDefine_SectionHeaderBGColor];
        self.noticeList.separatorStyle = UITableViewCellSeparatorStyleNone;
        self.noticeList.scrollEnabled = NO;
        
        // 設定 footerview
        self.noticeList.tableFooterView = [[[UIView alloc] init] autorelease];
        [self.noticeList.tableFooterView setBackgroundColor:[UIColor clearColor]];
        
        [self.view addSubview:self.noticeList];
    }
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    
    //////////////////////////////////////////////////
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppButtonBack = nil;
    
    self.ppNavigationBarView = nil;
    
    [self.noticeList removeFromSuperview];
    self.noticeList = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare data


//==============================================================================
//
//==============================================================================
- (void)loadData
{
    if (self.noticeInfo==nil)
    {
        return ;
    }
    
    [self setBusy:@(YES)];

    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        NSArray *sectionData = nil;
        NSError *error = nil;
        [[WCTRestClientController shareRestClientController] noticeContentWithGuid:self.noticeInfo.guid error:&error];

        if(error ==nil)
        {
            //////////////////////////////////////////////////
            
            PPSectionModel *sectionModel = [[PPSectionModel alloc] init];
            
            if(sectionModel)
            {
                sectionModel.title = [self.noticeInfo localizedNoticeTitle];
                sectionData = @[sectionModel];
                
                //////////////////////////////////////////////////
                
                NSMutableString *content = [NSMutableString string];
                [content appendString:[self.noticeInfo localizedNoticeContent]];
                
                [content appendString:@"\n\n"];
                
                // 加入時間
                [content appendString:[self.noticeInfo.notifyTime stringWithFormat:NSDateFormat_Second]];
                
                PPRowModel *rowModel = [PPRowModel rowModelWithRow:0
                                                              text:content
                                                        detailText:nil
                                                            object:nil];
                
                if(rowModel)
                {
                    [sectionModel.rowModels addObject:rowModel];
                }
            }
            
            [sectionModel release];
        }
        
        [error retain];

        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(error)
            {
                NSString *errorMessage = nil;
                NSError *customError = PPErrorMake(1, WCTNoticeFlowControllerString_FailedToConnectInternet, error);
                
                if ([self.delegate respondsToSelector:@selector(noticeContentViewController:requestErrorMessageWithError:)])
                {
                    errorMessage = [self.delegate noticeContentViewController:self requestErrorMessageWithError:customError];
                }
                
                if([errorMessage length]>0)
                {
                    [WCToastController showMessageToastFromSuperView:blockSelf.view
                                                         withMessage:errorMessage
                                                            position:PPToastPositionCenter];
                }
            }
            else
            {
                [blockSelf setSectionData:sectionData reload:YES];
            }
            
            [error release];
            [blockSelf setBusy:@(NO)];
        });
    });
}


//==============================================================================
//
//==============================================================================
- (void)setSectionData:(NSArray*)sectionData reload:(BOOL)reload
{
    [self.sectionController replaceSectionModels:sectionData forSearching:NO];
    
    if(reload)
    {
        [self.noticeList reloadData];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.noticeList==nil)
    {
        return ;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"noticeList":self.noticeList};
    
    NSDictionary *metrics = nil;
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[noticeList]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[noticeList]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag) {
        case WCTNoticeContentViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = [self.sectionController numberOfRowsInSection:section forSearching:NO];
    
    return numberOfRows;
}


//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PPTextViewTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:WCTNoticeContentViewControllerCellIdentifier];
    
    if (cell==nil)
    {
        cell = [[[PPTextViewTableViewCell alloc] initCustomStyleWithReuseIdentifier:WCTNoticeContentViewControllerCellIdentifier] autorelease];
    }
    
    [cell.ppTextView setEditable:NO];
    [cell.ppTextView setFont:[UIFont systemFontOfSize:WCTNoticeContentViewControllerContentFontSize]];
    
    //////////////////////////////////////////////////
    PPRowModel *rowModel = [[self.sectionController rowModelAtIndexPath:indexPath forSearching:NO] copy];
    
    // set data
    cell.ppTextView.text = rowModel.text;
    [rowModel release];
    return cell;
}


//==============================================================================
//
//==============================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return [self.sectionController titleForHeaderInSection:section forSearching:NO];
}


//==============================================================================
//
//==============================================================================
- (nullable UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PPSectionHeaderView *sectionHeaderView = [self.sectionController viewForHeaderInSection:section forSearching:NO];
    sectionHeaderView.gap = 15;
    [sectionHeaderView setBackgroundColor:WCAppearanceDefine_SectionHeaderBGColor];
    [sectionHeaderView.textLabel setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
    [sectionHeaderView.textLabel setFont:[UIFont systemFontOfSize:WCTNoticeContentViewControllerTitleFontSize]];
    [sectionHeaderView.textLabel setNumberOfLines:0];
    
    return sectionHeaderView;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return tableView.frame.size.height*0.7;
}


//==============================================================================
//
//==============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 44;
}



@end
