//
//  WCTLoginProtocolPortTextFieldButtonTableViewCell.m
//  Extension
//
//  Created by Howard on 2017/10/31.
//

#import "WCTLoginProtocolPortTextFieldButtonTableViewCell.h"

// Define
#import "WCTLoginViewController+ParameterDefine.h"
#import "WCTLoginViewController+ResourceDefine.h"

// Category
#import "UIView+Appearance.h"

static CGFloat const WCTLoginURLView_SmallGap = 10;
static CGFloat const WCTLoginProtocolLbelWidth = 60;
static CGFloat const WCTLoginURLLabelWidth = 60;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface WCTLoginProtocolPortTextFieldButtonTableViewCell

@interface WCTLoginProtocolPortTextFieldButtonTableViewCell ()
<
UITextFieldDelegate
>

@property (nonatomic,retain) UILabel *protocolLabel;
@property (nonatomic,retain) UILabel *portLabel;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation WCTLoginProtocolPortTextFieldButtonTableViewCell

@implementation WCTLoginProtocolPortTextFieldButtonTableViewCell


#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        _protocolLabel = [[UILabel alloc] init];
        
        if(_protocolLabel!=nil)
        {
            _protocolLabel.text = @"HTTPS";
            _protocolLabel.textColor = WCTLVC_TextFieldTextColor;
            _protocolLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerForgetPasswordButtonFontSize];
            [self.contentView addSubview:_protocolLabel];
        }
        
        //////////////////////////////////////////////////

        _protocolHttpsSwitch = [[UISwitch alloc] init];
        
        if(_protocolHttpsSwitch!=nil)
        {
            [_protocolHttpsSwitch addTarget:self
                                     action:@selector(switchControlValueChanged:)
                           forControlEvents:UIControlEventValueChanged];
            
            [self.contentView addSubview:_protocolHttpsSwitch];
        }
        
        //////////////////////////////////////////////////

        _portLabel = [[UILabel alloc] init];
        
        if(_portLabel!=nil)
        {
            _portLabel.text = WCTLV_MLS_Port;
            _portLabel.textAlignment = NSTextAlignmentRight;
            _portLabel.textColor = WCTLVC_TextFieldTextColor;
            _portLabel.font = [UIFont systemFontOfSize:WCTLoginViewControllerForgetPasswordButtonFontSize];
            [self.contentView addSubview:_portLabel];
        }
        
        //////////////////////////////////////////////////

        _portTextField = [[CustomRectTextField alloc] init];
     
        if(_portTextField!=nil)
        {
            _portTextField.delegate = self;
            _portTextField.autocorrectionType       = UITextAutocorrectionTypeNo;
            _portTextField.backgroundColor          = [UIColor clearColor];
            _portTextField.clearButtonMode          = UITextFieldViewModeWhileEditing;
            _portTextField.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
            _portTextField.textAlignment            = NSTextAlignmentCenter;
            _portTextField.keyboardType             = UIKeyboardTypeNumberPad;
            _portTextField.returnKeyType            = UIReturnKeyDone;
            
            _portTextField.tag = WCTLoginViewControllerTextFieldTag_Port;
            
            _portTextField.autocapitalizationType = UITextAutocapitalizationTypeNone;
            
            //////////////////////////////////////////////////
        
            _portTextField.textColor = WCTLVC_TextFieldTextColor;
       
            [_portTextField setBorderColor:WCTLVC_TextFieldBorderColor];
            [_portTextField setBorderWidth:1.0];
            
            //////////////////////////////////////////////////

            [self.contentView addSubview:_portTextField];
        }
        
        //////////////////////////////////////////////////
        
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(textFieldTextDidChangeNotification:)
                                                     name:UITextFieldTextDidChangeNotification
                                                   object:nil];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    
    //////////////////////////////////////////////////

    _delegate = nil;
    
    //////////////////////////////////////////////////

    [_protocolLabel removeFromSuperview];
    [_protocolLabel release];
    _protocolLabel = nil;
    
    [_protocolHttpsSwitch removeFromSuperview];
    [_protocolHttpsSwitch release];
    _protocolHttpsSwitch = nil;
    
    [_portLabel removeFromSuperview];
    [_portLabel release];
    _portLabel = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of subView

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    self.protocolLabel.frame = CGRectMake(self.textFieldButtoViewContentInset.left,
                                               self.textFieldButtoViewContentInset.top,
                                          WCTLoginURLLabelWidth,
                                               self.contentView.bounds.size.height-self.textFieldButtoViewContentInset.top-self.textFieldButtoViewContentInset.bottom);

    self.protocolHttpsSwitch.frame = CGRectMake(CGRectGetMaxX(self.protocolLabel.frame)+WCTLoginURLView_SmallGap,
                                                self.contentView.center.y-self.protocolHttpsSwitch.frame.size.height/2,
                                                self.protocolHttpsSwitch.frame.size.width,
                                                self.protocolHttpsSwitch.frame.size.height);
   
    self.portLabel.frame = CGRectMake(self.bounds.size.width/2,
                                      self.textFieldButtoViewContentInset.top,
                                      WCTLoginProtocolLbelWidth,
                                      self.contentView.bounds.size.height-self.textFieldButtoViewContentInset.top-self.textFieldButtoViewContentInset.bottom);
    
    self.portTextField.frame = CGRectMake(CGRectGetMaxX(self.portLabel.frame)+WCTLoginURLView_SmallGap,
                                          self.textFieldButtoViewContentInset.top,
                                          self.contentView.bounds.size.width-(CGRectGetMaxX(self.portLabel.frame)+WCTLoginURLView_SmallGap)-self.textFieldButtoViewContentInset.right,
                                          self.contentView.bounds.size.height-self.textFieldButtoViewContentInset.top-self.textFieldButtoViewContentInset.bottom);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Swith Method

//================================================================================
//
//================================================================================
- (void)switchControlValueChanged:(id)sender
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(loginURLTextFieldButtonTableViewCellSwitchValueDidChanged:)]==YES)
    {
        [self.delegate loginURLTextFieldButtonTableViewCellSwitchValueDidChanged:self];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Notification Method

//================================================================================
//
//================================================================================
- (void)textFieldTextDidChangeNotification:(NSNotification*)notification
{
    if(self.portTextField==[notification object])
    {
        if([self.delegate respondsToSelector:@selector(loginURLTextFieldButtonTableViewCellTextDidChanged:)])
        {
            [self.delegate loginURLTextFieldButtonTableViewCellTextDidChanged:self];
        }
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITextField Method

//================================================================================
//
//================================================================================
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    BOOL result = NO;
    do
    {
        // only input number
        if([[string stringByTrimmingCharactersInSet:[NSCharacterSet decimalDigitCharacterSet]] length]>0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSString *nextString = [textField.text stringByReplacingCharactersInRange:range withString:string];
        
        // overflow
        if([nextString integerValue]>65535)
        {
            break;
        }
        
        result = YES;
    }
    while (0);
    
    return result;
}
@end
