//
//  ForgetPasswordWebViewController.m
//
//
//  Created by Howard on 2016/10/12.
//
//

#import "ForgetPasswordWebViewController.h"

// Define
#import "WCTLoginViewController+ResourceDefine.h"
#import "WCTLoginController+ResourceDefine.h"

// Controller
#import "PPAlertController.h"

// Category
#import "NSObject+PPBusyView.h"


static NSString *ForgetPasswordWebViewController_ScriptName = @"Mobile";
static NSString *ForgetPasswordWebViewController_AccountManagerAction_ResetSuccess = @"resetCompleteAction";
static NSString *ForgetPasswordWebViewController_AccountManagerAction_ResetCancel = @"resetCancelAction";

static NSString *ForgetPasswordWebViewController_WebViewAction = @"action";
static NSString *ForgetPasswordWebViewController_WebViewURL = @"url";

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface ForgetPasswordWebViewController () <PPWebViewControllerDelegate>

@end

@implementation ForgetPasswordWebViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, copying ,and dellocating Object


//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.delegate = self;
    }
    
    return self;
}



//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.delegate = nil;
    
    [_acceptURL release];
    _acceptURL = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
//
//==============================================================================
- (void)webViewDidFailedWithError:(NSError*)error
{
    BOOL showError = YES;
    
    do
    {
        if([self.forgetPasswordDelegate respondsToSelector:@selector(forgetPasswordWebViewControllerShouldShowError:)]==YES)
        {
            showError = [self.forgetPasswordDelegate forgetPasswordWebViewControllerShouldShowError:error];
        }
        
        if(showError==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *message = nil;
        
        if([self.forgetPasswordDelegate respondsToSelector:@selector(forgetPasswordWebViewControlerRequestMessageForError:)]==YES)
        {
            message = [self.forgetPasswordDelegate forgetPasswordWebViewControlerRequestMessageForError:error];
        }
        
        if([message length]<=0)
        {
            message = [error.localizedDescription stringByAppendingString:[NSString stringWithFormat:@"(%@)",self.acceptURL]];
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                  title:@""
                                                message:message
                                 showFromViewController:self
                                               animated:YES
                                            alertAction:[UIAlertAction actionWithTitle:WCTLV_MLS_OK
                                                                                 style:UIAlertActionStyleDefault
                                                                               handler:^(UIAlertAction *action){
                                                                                   [blockself dismissAnimated:YES
                                                                                                   completion:nil];
                                                                               }], nil];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPWebViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSArray *)scriptMessagesWithPPWebViewController:(PPWebViewController *)ppWebViewController
{
    return @[ForgetPasswordWebViewController_ScriptName];
}


//==============================================================================
//
//==============================================================================
- (void)ppWebViewController:(PPWebViewController *)wctWebViewController didReceiveScriptMessage:(WKScriptMessage *)message
{
    if ([message.name isEqualToString:ForgetPasswordWebViewController_ScriptName])
    {
        if([message.body isKindOfClass:[NSDictionary class]])
        {
            NSString *action = message.body[ForgetPasswordWebViewController_WebViewAction];
            if ([action isEqualToString:ForgetPasswordWebViewController_AccountManagerAction_ResetSuccess]||
                [action isEqualToString:ForgetPasswordWebViewController_AccountManagerAction_ResetCancel])
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    [self goBackAnimated:YES];
                });
            }
        }
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPWebView Delegate Method

//================================================================================
//
//================================================================================
- (void)webView:(WKWebView *)webView decidePolicyForNavigationAction:(WKNavigationAction *)navigationAction decisionHandler:(void (^)(WKNavigationActionPolicy))decisionHandler;
{
    BOOL result = YES;
    __block typeof(self) blockself = self;
    NSURLComponents *acceptComponets = [NSURLComponents componentsWithString:self.acceptURL];
    
    if([[acceptComponets host] compare:[[navigationAction.request URL] host] options:NSCaseInsensitiveSearch]!=NSOrderedSame)
    {
        result = NO;
        
        //////////////////////////////////////////////////
        
        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                  title:@""
                                                message:WCTLC_MLS_ConnecWebSiteFomatError
                                 showFromViewController:self
                                               animated:YES
                                            alertAction:[UIAlertAction actionWithTitle:WCTLV_MLS_OK
                                                                                 style:UIAlertActionStyleDefault
                                                                               handler:^(UIAlertAction *action){
                                                                                   [blockself dismissAnimated:YES
                                                                                                   completion:nil];
                                                                               }], nil];
    }
    // 發現 host 一樣的情況，又是登入頁面，就直接返回
    else if([[acceptComponets fragment] compare:[[navigationAction.request URL] fragment] options:NSCaseInsensitiveSearch]!=NSOrderedSame)
        
    {
        result = NO;
        
        dispatch_async(dispatch_get_main_queue(), ^{
             [blockself dismissAnimated:YES completion:nil];
        });
       
    }
    
    if(result)
    {
        decisionHandler(WKNavigationActionPolicyAllow);
    }
    else
    {
        decisionHandler(WKNavigationActionPolicyCancel);
    }
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    [self webViewDidFailedWithError:error];
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    [self webViewDidFailedWithError:error];
}
@end
