//
//  PPAlertController+WCTHelper.m
//  WCTDataModel.default-Category-Define
//
//  Created by sanhue cheng on 2021/1/6.
//

#import "PPAlertController+WCTHelper.h"
#import "NSString+Additions.h"

// !! 要在project中加入字串
#define WCTHelperString_Close [@"MLS_Close" localized]
#define WCTHelperString_CreateAccount [@"MLS_CreateAccount" localized]
#define WCTHelperString_AccountAlertMessage [@"MLS_AccountAlertMessage" localized]

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPAlertController (WCTHelper)



//==============================================================================
//
//==============================================================================
+ (void)showAccountAlertFromViewController:(UIViewController *)viewController showCreate:(BOOL)showCreate accountManagerHandler:(void(^)(void))accountManagerHandler
{
    PPAlertController *alertController = [PPAlertController alertControllerWithTitle:@"" message:WCTHelperString_AccountAlertMessage preferredStyle:UIAlertControllerStyleAlert];
    [alertController addAction:[UIAlertAction actionWithTitle:WCTHelperString_Close style:UIAlertActionStyleCancel handler:nil]];
    if(showCreate)
    {
        [alertController addAction:[UIAlertAction actionWithTitle:WCTHelperString_CreateAccount style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            if(accountManagerHandler)
            {
                accountManagerHandler ();
            }
        }]];
    }
    [viewController presentViewController:alertController animated:YES completion:nil];
}
@end
