//
//  WCTSearchOptionModel+WCTRCSearchConditions.m
//  ADAL
//
//  Created by sanhue on 2018/5/4.
//

#import "WCTSearchOptionModel+WCTRCSearchConditions.h"
#import "WCSearchOptionModel+WCTRCSearchConditions.h"
#import "NSDate+Format.h"
#import "WCCustomFieldDefine.h"
#import "WCTRestClient+ParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTSearchOptionModel (WCTRCSearchConditions)





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods

//==============================================================================
//
//==============================================================================
- (WCTRCAdvancedSearchContactSearchInfo *)advanceSearchContactSearchInfo
{
    return [super advanceSearchContactSearchInfo];
}


//==============================================================================
//
//==============================================================================
- (WCTRCAdvancedSearchCustomFieldSearchInfo *)advanceSearchCustomFieldSearchInfo
{
    if(self.searchType!=WCSearchType_UserDefine)
    {
        return nil;
    }
    
    //////////////////////////////////////////////////
    WCTRCAdvancedSearchCustomFieldSearchInfo *searchInfo = [[[WCTRCAdvancedSearchCustomFieldSearchInfo alloc] init] autorelease];
    searchInfo.logicWithPreviousAllResults = [[self class] stringFromSearchOperator:self.searchOperator];
    searchInfo.customFieldGuid = self.customFieldID;
    
    switch (self.customFieldType)
    {
        case WCCustomFieldContentType_Text:
        case WCCustomFieldContentType_URL:
        case WCCustomFieldContentType_Email:
        {
            if ([self.customFieldValue length])
            {
                searchInfo.keyword = self.customFieldValue;
            }
            break;
        }
        case WCCustomFieldContentType_Date:
        case WCCustomFieldContentType_DateTime:
        {
            if (self.fromDate ||
                self.toDate)
            {
                searchInfo.timeInterval = [[[WCTRCAdvancedSearchCustomFieldTimeInterval alloc] init] autorelease];
                searchInfo.timeInterval.beginTime = [[self.fromDate stringWithFormat:WCTRestClient_ServerDateFormat_Day] stringByAppendingString:@" 00:00:00.000"];
                searchInfo.timeInterval.endTime = [[self.toDate stringWithFormat:WCTRestClient_ServerDateFormat_Day] stringByAppendingString:@" 23:59:59.999"];
            }
            break;
        }
        case WCCustomFieldContentType_Integer:
        case WCCustomFieldContentType_Float:
        {
            if ([self.customFieldValueFrom length]>0 ||
                [self.customFieldValueTo length]>0 )
            {
                searchInfo.numberInterval = [[[WCTRCAdvancedSearchCustomFieldNumberInterval alloc] init] autorelease];
                searchInfo.numberInterval.beginNumber = self.customFieldValueFrom;
                searchInfo.numberInterval.endNumber = self.customFieldValueTo;
            }
            break;
        }
        case WCCustomFieldContentType_Picklist:
        {
            if ([self.customFieldListItemIDs count]>0)
            {
                searchInfo.picklistContentGuids = self.customFieldListItemIDs;
            }
            break;
        }
        default:
            break;
    }
    
    return searchInfo;
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (NSString *)stringFromSearchOperator:(WCSearchOperator)searchOperator
{
    if (searchOperator==WCSearchOperator_OR)
    {
        return WCTRC_AdvancedSearchOperator_Or;
    }
    
    return WCTRC_AdvancedSearchOperator_And;
}


//==============================================================================
//
//==============================================================================
+ (NSString *)searchFieldFromSearchType:(WCTSearchType)searchType
{
    switch (searchType)
    {
        case  WCTSearchType_Name:
        {
            return WCTRC_ContactSearchField_Fullname;
        }
        case  WCTSearchType_Address:
        {
            return WCTRC_ContactSearchField_Address;
        }
        case  WCTSearchType_Phone:
        {
            return WCTRC_ContactSearchField_PhoneNumber;
        }
        case  WCTSearchType_Email:
        {
            return WCTRC_ContactSearchField_Email;
        }
        case  WCTSearchType_URL:
        {
            return WCTRC_ContactSearchField_URL;
        }
        case  WCTSearchType_InstantMessage:
        {
            return WCTRC_ContactSearchField_InstantMessage;
        }
        case  WCTSearchType_Note:
        {
            return WCTRC_ContactSearchField_Note;
        }
        case  WCTSearchType_UnifiedBusinessNo:
        {
            return WCTRC_ContactSearchField_UniformNumber;
        }
        case  WCTSearchType_SocialNetwork:
        {
            return WCTRC_ContactSearchField_SocialNetwork;
        }
        case WCTSearchType_Company:
        {
            return WCTRC_ContactSearchField_Company;
        }
        case WCTSearchType_JobTitle:
        {
            return WCTRC_ContactSearchField_Jobtitle;
        }
        case WCTSearchType_Department:
        {
            return WCTRC_ContactSearchField_Department;
        }
            //////////////////////////////////////////////////
            // time
        case WCTSearchType_CreateTime:
        {
            return WCTRC_TimeSearchField_CreateTime;
        }
        case WCTSearchType_ModifiedTime:
        {
            return WCTRC_TimeSearchField_ModifyTime;
        }
            //////////////////////////////////////////////////
            // account
        case WCTSearchType_Creator:
        {
            return WCTRC_AccountSearchField_Creator;
        }
        case WCTSearchType_Owner:
        {
            return WCTRC_AccountSearchField_Owner;
        }
        case WCTSearchType_Editor:
        {
            return WCTRC_AccountSearchField_Editor;
        }
        default:
            return nil;
    }
}



@end
