//
//  WCSearchOptionModel+WCTRCSearchConditions.m
//  ADAL
//
//  Created by sanhue on 2018/10/29.
//

#import "WCSearchOptionModel+WCTRCSearchConditions.h"
#import "NSDate+Format.h"
#import "WCCustomFieldDefine.h"
#import "WCTRestClient+ParameterDefine.h"

@implementation WCSearchOptionModel (WCTRCSearchConditions)





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods

//==============================================================================
//
//==============================================================================
- (WCTRCAdvancedSearchContactSearchInfo *)advanceSearchContactSearchInfo
{
    if(self.searchType>WCSearchType_CreateTime ||self.searchType==WCSearchType_UserDefine ||
       [self.text length]==0)
    {
        return nil;
    }
    
    //////////////////////////////////////////////////
    WCTRCAdvancedSearchContactSearchInfo *searchInfo = [[[WCTRCAdvancedSearchContactSearchInfo alloc] init] autorelease];
    searchInfo.field = [[self class] searchFieldFromSearchType:self.searchType];
    searchInfo.keyword = self.text;
    searchInfo.logicWithPreviousAllResults = [[self class] stringFromSearchOperator:self.searchOperator];
    
    return searchInfo;
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (NSString *)stringFromSearchOperator:(WCSearchOperator)searchOperator
{
    if (searchOperator==WCSearchOperator_OR)
    {
        return WCTRC_AdvancedSearchOperator_Or;
    }
    
    return WCTRC_AdvancedSearchOperator_And;
}


//==============================================================================
//
//==============================================================================
+ (NSString *)searchFieldFromSearchType:(WCSearchType)searchType
{
    switch (searchType)
    {
        case  WCSearchType_Name:
        {
            return WCTRC_ContactSearchField_Fullname;
        }
        case  WCSearchType_Address:
        {
            return WCTRC_ContactSearchField_Address;
        }
        case  WCSearchType_Phone:
        {
            return WCTRC_ContactSearchField_PhoneNumber;
        }
        case  WCSearchType_Email:
        {
            return WCTRC_ContactSearchField_Email;
        }
        case  WCSearchType_URL:
        {
            return WCTRC_ContactSearchField_URL;
        }
        case  WCSearchType_InstantMessage:
        {
            return WCTRC_ContactSearchField_InstantMessage;
        }
        case  WCSearchType_Note:
        {
            return WCTRC_ContactSearchField_Note;
        }
        case  WCSearchType_UnifiedBusinessNo:
        {
            return WCTRC_ContactSearchField_UniformNumber;
        }
        case  WCSearchType_SocialNetwork:
        {
            return WCTRC_ContactSearchField_SocialNetwork;
        }
        case WCSearchType_Company:
        {
            return WCTRC_ContactSearchField_Company;
        }
        case WCSearchType_JobTitle:
        {
            return WCTRC_ContactSearchField_Jobtitle;
        }
        case WCSearchType_Department:
        {
            return WCTRC_ContactSearchField_Department;
        }
            //////////////////////////////////////////////////
            // time
        case WCSearchType_CreateTime:
        {
            return WCTRC_TimeSearchField_CreateTime;
        }
        case WCSearchType_ModifiedTime:
        {
            return WCTRC_TimeSearchField_ModifyTime;
        }
        default:
            return nil;
    }
}

@end
