//
//  WCGroupModel+WCTRCCategoryInfoMultiLayer.m
//  

#import "WCGroupModel+WCTRCCategoryInfoMultiLayer.h"

// Define
#import "WCGroupDefine.h"
#import "WCTRestObject+ParameterDefine.h"
#import "WCGroupModel+Sort.h"

@implementation WCGroupModel (WCTRCCategoryInfoMultiLayer)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (WCTRCCategoryInfoMultiLayer *)WCTRCCategoryInfoMultiLayer
{
    WCTRCCategoryInfoMultiLayer *categoryInfo = [[WCTRCCategoryInfoMultiLayer alloc] init];
    
    if(categoryInfo!=nil)
    {
        switch (self.ID)
        {
            case WC_GID_All:
                categoryInfo.categoryType = WCTRC_CategoryType_All;
                break;

            case WC_GID_Favorite:
                categoryInfo.categoryType = WCTRC_CategoryType_Favorite;
                break;

            case WC_GID_Unfiled:
                categoryInfo.categoryType = WCTRC_CategoryType_Other;
                break;

            default:
                categoryInfo.categoryType = WCTRC_CategoryType_Normal;
                break;
        }
        
        categoryInfo.guid = self.guid;
        categoryInfo.hasChildren = ([self.subGroups count] > 0);
        categoryInfo.name = self.name;
        categoryInfo.parentCategoryGuid = self.superGroupGuid;
        categoryInfo.updateTime = self.modifiedTime;
        categoryInfo.secretaryAccountGuid = self.helper;
    }
    
    return [categoryInfo autorelease];
}


//================================================================================
//
//================================================================================
+ (WCGroupModel *)modelWithWCTRCCategoryInfoMultiLayer:(WCTRCCategoryInfoMultiLayer *)categoryInfo
{
    WCGroupModel *groupModel = nil;
    
    do
    {
        if(categoryInfo==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        groupModel = [[WCGroupModel alloc] init];
        
        if(groupModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
    
        if([categoryInfo.categoryType compare:WCTRC_CategoryType_All]==NSOrderedSame)
        {
            groupModel.ID = WC_GID_All;
            groupModel.editable = NO;
            
            if([[groupModel name] length]<=0)
            {
                groupModel.name = NSLocalizedString(@"MLS_All", nil);
            }
        }
        else if([categoryInfo.categoryType compare:WCTRC_CategoryType_Other]==NSOrderedSame)
        {
            groupModel.ID = WC_GID_Unfiled;
            groupModel.editable = NO;
            
            if([[groupModel name] length]<=0)
            {
                groupModel.name = NSLocalizedString(@"MLS_Unfiled", nil);
            }
        }
        else if([categoryInfo.categoryType compare:WCTRC_CategoryType_Favorite]==NSOrderedSame)
        {
            groupModel.ID = WC_GID_Favorite;
            groupModel.editable = NO;
            
            if([[groupModel name] length]<=0)
            {
                groupModel.name = NSLocalizedString(@"MLS_Favorite", nil);
            }
        }
        else
        {
            groupModel.ID = WC_GID_None;
            groupModel.editable = YES;
            groupModel.name = categoryInfo.name;
        }
        
        //////////////////////////////////////////////////

        groupModel.guid = categoryInfo.guid;
        groupModel.helper = categoryInfo.secretaryAccountGuid;
        groupModel.modifiedTime = categoryInfo.updateTime;
        groupModel.superGroupGuid = categoryInfo.parentCategoryGuid;
    }
    while (0);
   
    
    return [groupModel autorelease];
}


//================================================================================
//
//================================================================================
+ (WCGroupModel *)groupTreeWithCategoryList:(NSArray *)categoryList customGroupEditable:(BOOL)customGroupEditable
{
    // tree產生規則
    // 1. 濾除favorite
    // 2. 調整editable
    // 3. 排序
    
    NSMutableArray *groups = [NSMutableArray array];

    for(WCTRCCategoryInfoMultiLayer *category in categoryList)
    {
        WCGroupModel *groupModel = [self modelWithWCTRCCategoryInfoMultiLayer:category];
        
        switch (groupModel.ID)
        {
            case WC_GID_Favorite: // ignore
                break;

            case WC_GID_None: // custom group
                groupModel.editable = customGroupEditable;
                [groups addObject:groupModel];
                break;
                
            default:
                [groups addObject:groupModel];
                break;
        }
    }

    //////////////////////////////////////////////////

    return [self groupTreeWithGroups:groups];
}


@end
