//
//  WCGroupModel+WCTRCCategoryInfoMultiLayer.h
//  

#import "WCGroupModel+Tree.h"

// model
#import "WCTRCCategoryInfoMultiLayer.h"

@interface WCGroupModel (WCTRCCategoryInfoMultiLayer)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * 從WCGroupModel轉出WCTRCCategoryInfo資料
 *
 * @return WCTRCCategoryInfoMultiLayer object (autorelease)
 */
- (WCTRCCategoryInfoMultiLayer *)WCTRCCategoryInfoMultiLayer;

/**
 * 從WCTRCCategoryInfoMultiLayer轉出WCGroupModel
 *
 * @param categoryInfo 來源的WCTRCCategoryInfoMultiLayer object
 * @return WCGroupModel object (autorelease)
 */
+ (WCGroupModel *)modelWithWCTRCCategoryInfoMultiLayer:(WCTRCCategoryInfoMultiLayer *)categoryInfo;

/**
 從categoryList轉出自建的groupTree

 @param categoryList 來源的WCTRCCategoryInfoMultiLayer array
 @param customGroupEditable 自訂群組是否可以編輯
 @return Root group of tree (group 'All')
 */
+ (WCGroupModel *)groupTreeWithCategoryList:(NSArray *)categoryList customGroupEditable:(BOOL)customGroupEditable;

@end
