//
//  WCCustomFieldInfo+WCTRCCustomFieldInfo.m
//  Pods
//
//  Created by sanhue on 2016/10/31.
//
//

#import "WCCustomFieldInfo+WCTRCCustomFieldInfo.h"
#import "WCCustomFieldListItem.h"

@implementation WCCustomFieldInfo (WCTRCCustomFieldInfo)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (WCTRCCustomFieldInfo *)WCTRCCustomFieldInfo
{
    WCTRCCustomFieldInfo *customFieldInfo = [[WCTRCCustomFieldInfo alloc] init];
    
    if(customFieldInfo!=nil)
    {
        customFieldInfo.guid = self.guid;
        customFieldInfo.customFieldName = self.name;
        
        if (self.category==WCCustomFieldCategory_Task)
        {
            customFieldInfo.customFieldCategory = WCTRC_CustomField_Category_Task;
        }
        else if (self.category==WCCustomFieldCategory_Contact)
        {
            customFieldInfo.customFieldCategory = WCTRC_CustomField_Category_Contact;
        }
        else if (self.category==WCCustomFieldCategory_Activity)
        {
            customFieldInfo.customFieldCategory = WCTRC_CustomField_Category_Activity;
        }
        
        if(self.contentType==WCCustomFieldContentType_Text)
        {
            customFieldInfo.customFieldContactAttribute = WCTRC_CustomField_Attributes_Text;
        }
        if(self.contentType==WCCustomFieldContentType_URL)
        {
            customFieldInfo.customFieldContactAttribute = WCTRC_CustomField_Attributes_URL;
        }
        else if(self.contentType==WCCustomFieldContentType_Integer)
        {
            customFieldInfo.customFieldContactAttribute = WCTRC_CustomField_Attributes_Number;
        }
        else if(self.contentType==WCCustomFieldContentType_Float)
        {
            customFieldInfo.customFieldContactAttribute = WCTRC_CustomField_Attributes_Float;
        }
        else if(self.contentType==WCCustomFieldContentType_Email)
        {
            customFieldInfo.customFieldContactAttribute = WCTRC_CustomField_Attributes_Email;
        }
        else if(self.contentType==WCCustomFieldContentType_Picklist)
        {
            customFieldInfo.customFieldContactAttribute = WCTRC_CustomField_Attributes_Picklist;
        }
        else if(self.contentType==WCCustomFieldContentType_Date)
        {
            customFieldInfo.customFieldContactAttribute = WCTRC_CustomField_Attributes_Date;
        }
        else if(self.contentType==WCCustomFieldContentType_DateTime)
        {
            customFieldInfo.customFieldContactAttribute = WCTRC_CustomField_Attributes_DateTime;
        }
        
        NSMutableArray *picklistItems = [NSMutableArray array];

        for (WCCustomFieldListItem *picklistItem in self.picklistItems)
        {
            WCTRCCustomFieldContent *fieldContent = [[WCTRCCustomFieldContent alloc] init];
            fieldContent.guid = picklistItem.guid;
            fieldContent.content = picklistItem.itemText;
            
            [picklistItems addObject:fieldContent];
            [fieldContent release];
        }
        
        customFieldInfo.customFieldContents = picklistItems;
    }
    
    return [customFieldInfo autorelease];
}


//================================================================================
//
//================================================================================
+ (WCCustomFieldInfo *)customFieldInfoWithWCTRCCustomFieldInfo:(WCTRCCustomFieldInfo *)fieldInfo
{
    WCCustomFieldInfo *customFieldInfo = nil;
    
    do
    {
        if(fieldInfo==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        customFieldInfo = [[WCCustomFieldInfo alloc] init];
        
        if(customFieldInfo==nil)
        {
            break;
        }
        
        customFieldInfo.guid = fieldInfo.guid;
        customFieldInfo.name = fieldInfo.customFieldName;
        
        if([fieldInfo.customFieldCategory isEqualToString:WCTRC_CustomField_Category_Activity])
        {
            customFieldInfo.category = WCCustomFieldCategory_Activity;
        }
        else if([fieldInfo.customFieldCategory isEqualToString:WCTRC_CustomField_Category_Contact])
        {
            customFieldInfo.category = WCCustomFieldCategory_Contact;
        }
        else if([fieldInfo.customFieldCategory isEqualToString:WCTRC_CustomField_Category_Task])
        {
            customFieldInfo.category = WCCustomFieldCategory_Task;
        }
        
        if([fieldInfo.customFieldContactAttribute isEqualToString:WCTRC_CustomField_Attributes_Email])
        {
            customFieldInfo.contentType = WCCustomFieldContentType_Email;
        }
        else if([fieldInfo.customFieldContactAttribute isEqualToString:WCTRC_CustomField_Attributes_Text])
        {
            customFieldInfo.contentType = WCCustomFieldContentType_Text;
        }
        else if([fieldInfo.customFieldContactAttribute isEqualToString:WCTRC_CustomField_Attributes_URL])
        {
            customFieldInfo.contentType = WCCustomFieldContentType_URL;
        }
        else if([fieldInfo.customFieldContactAttribute isEqualToString:WCTRC_CustomField_Attributes_Number])
        {
            customFieldInfo.contentType = WCCustomFieldContentType_Integer;
        }
        else if([fieldInfo.customFieldContactAttribute isEqualToString:WCTRC_CustomField_Attributes_Float])
        {
            customFieldInfo.contentType = WCCustomFieldContentType_Float;
        }
        else if([fieldInfo.customFieldContactAttribute isEqualToString:WCTRC_CustomField_Attributes_Picklist])
        {
            customFieldInfo.contentType = WCCustomFieldContentType_Picklist;
        }
        else if([fieldInfo.customFieldContactAttribute isEqualToString:WCTRC_CustomField_Attributes_Date])
        {
            customFieldInfo.contentType = WCCustomFieldContentType_Date;
        }
        else if([fieldInfo.customFieldContactAttribute isEqualToString:WCTRC_CustomField_Attributes_DateTime])
        {
            customFieldInfo.contentType = WCCustomFieldContentType_DateTime;
        }

        NSMutableArray *picklistItems = [NSMutableArray array];
        for (WCTRCCustomFieldContent *fieldContent in fieldInfo.customFieldContents)
        {
            WCCustomFieldListItem *listItem = [[WCCustomFieldListItem alloc] init];
            listItem.guid = fieldContent.guid;
            listItem.itemText = fieldContent.content;
            
            [picklistItems addObject:listItem];
            
            [listItem release];
        }
        
        
        customFieldInfo.picklistItems = picklistItems;
    }
    while (0);
    
    
    return [customFieldInfo autorelease];
}

@end
