//
//  WCTCompanyCardModel+WCTRCContactSimpleInfo.m
//  
//
//  Created by Howard on 2016/4/15.
//
//

#import "WCCardModel+WCTRCContactSimpleInfo.h"

@implementation WCCardModel (WCTRCContactSimpleInfo)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (WCCardModel *)cardModelWithContactSimpleInfo:(WCTRCContactSimpleInfo *)contactSimpleInfo
{
    WCCardModel *cardModel = [[WCCardModel alloc] init];
    
    do
    {
        if(cardModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDateComponents *components = [[NSCalendar currentCalendar] components:NSCalendarUnitDay | NSCalendarUnitMonth | NSCalendarUnitYear
                                                                       fromDate:contactSimpleInfo.createdTime];
        
        if(components!=nil)
        {
            cardModel.sectionTitle = [NSString stringWithFormat:@"%td.%td.%td",[components year],[components month],[components day]];
        }
        
        //////////////////////////////////////////////////

        cardModel.ID = contactSimpleInfo.contactGuid;
        cardModel.displayCompany = contactSimpleInfo.company;
        cardModel.displayName = contactSimpleInfo.fullname;
        cardModel.createdTime = contactSimpleInfo.createdTime;
        cardModel.displayJobTitle = contactSimpleInfo.jobTitle;
        cardModel.owner = contactSimpleInfo.ownerAccountGuid;
        
        if(contactSimpleInfo.contactImageNum == 2)
        {
            cardModel.containImageType = WC_IT_FrontSide | WC_IT_BackSide;
        }
        else if(contactSimpleInfo.contactImageNum == 1)
        {
            cardModel.containImageType = WC_IT_FrontSide;
        }
    }
    while (0);

    return [cardModel autorelease];
}

@end
