//
//  WCCardModel+FixFieldLength.m
//  Pods
//
//  Created by sanhue on 2017/1/3.
//
//

#import "WCCardModel+FixFieldLength.h"
#import "WCTFieldLengthDefine.h"

@implementation WCCardModel (FixFieldLength)


//==============================================================================
//
//==============================================================================
- (NSInteger)maxLengthWithMainType:(WC_FieldType)fieldType subType2:(WC_FieldSubType2)subType2
{
    switch (fieldType)
    {
        case WC_FT_Name:
        {
            return WCT_FML_Name;
        }
        case WC_FT_Company:
        {
            return WCT_FML_Compnay;
        }
        case WC_FT_Address:
        {
            if (subType2==WC_FST2_Address_CountryCode)
            {
                return WCT_FML_Address_Code;
            }
            else if (subType2==WC_FST2_Address_Street)
            {
                return WCT_FML_Address_Street;
            }
            else
            {
                return WCT_FML_Address_Normal;
            }
        }
        case WC_FT_Phone:
        {
            return WCT_FML_Phone;
        }
        case WC_FT_Email:
        {
            return WCT_FML_Email;
        }
        case WC_FT_URL:
        {
            return WCT_FML_URL;
        }
        case WC_FT_InstantMessage:
        {
            return WCT_FML_IM;
        }
        case WC_FT_SocialNetwork:
        {
            return WCT_FML_SN;
        }
        case WC_FT_Note:
        {
            return WCT_FML_Note;
        }
        case WC_FT_Nickname:
        {
            return WCT_FML_Nickname;
        }
        case WC_FT_UnifiedBusinessNo:
        {
            return WCT_FML_UnifiedBusinessNo;
        }
        case WC_FT_UserDefine:
        default:
            return NSUIntegerMax;
    }
}


//==============================================================================
//
//==============================================================================
- (void)fixFieldLength
{
    // TODO: 修正內容長度
    NSArray *allFieldArray = [self.fieldArrayDict allValues];

    for(NSMutableArray *fieldArray in allFieldArray)
    {
        for(WCFieldModel *fieldModel in fieldArray)
        {
            if([fieldModel.value isKindOfClass:[NSMutableDictionary class]])
            {
                NSMutableDictionary *dictValue = (NSMutableDictionary *)fieldModel.value;
                NSArray *subFieldArray = [dictValue allValues];
                
                for(WCFieldModel *subFieldModel in subFieldArray)
                {

                    // search only的欄位不用切
                    if(subFieldModel.subType2==WC_FST2_SearchOnly)
                    {
                        continue;
                    }
                    
                    // 姓名，公司，地址
                    NSInteger maxLength = [self maxLengthWithMainType:subFieldModel.type subType2:subFieldModel.subType2];

                    if([subFieldModel.value isKindOfClass:[NSString class]])
                    {
                        if([subFieldModel.value length]>maxLength)
                        {
                            subFieldModel.value = [subFieldModel.value substringWithRange:NSMakeRange(0, maxLength)];
                        }
                    }
                }
            }
            else
            {
                NSInteger maxLength = [self maxLengthWithMainType:fieldModel.type subType2:fieldModel.subType2];

                // 一般欄位
                if([fieldModel.value isKindOfClass:[NSString class]])
                {
                    if([fieldModel.value length]>maxLength)
                    {
                        fieldModel.value = [fieldModel.value substringWithRange:NSMakeRange(0, maxLength)];
                    }
                }
            }
            
        }
    }
}

@end
