//
//  WCCardModel+CombineCustomFields.m
//  Pods
//
//  Created by sanhue on 2017/7/17.
//
//

#import "WCCardModel+CombineCustomFields.h"
#import "NSDate+Format.h"
#import "NSString+Additions.h"

#define WCT_FMC_UserDefine 16
//////////////////////////////////////////////////
@implementation WCCardModel (CombineCustomFields)


//==============================================================================
//
//==============================================================================
- (BOOL)isCustomFieldValueExist:(WCFieldModel *)fieldModel
{
    NSArray *customFieldArray = [self fieldArrayWithType:WC_FT_UserDefine];

    for (WCFieldModel *aFieldModel in customFieldArray)
    {
        if ([aFieldModel.customFieldInfoGuid compare:fieldModel.customFieldInfoGuid options:NSCaseInsensitiveSearch]==NSOrderedSame &&
            [aFieldModel.value isEqual:fieldModel.value])
        {
            return YES;
        }
    }
    
    return NO;
}


//==============================================================================
//
//==============================================================================
- (BOOL)canAddCustomFieldModel:(WCFieldModel *)customFieldModel
{
    if (customFieldModel.type!=WC_FT_UserDefine)
    {
        return NO;
    }
    
    //////////////////////////////////////////////////
    
    NSArray *customFieldArray = [self fieldArrayWithType:WC_FT_UserDefine];
    
    if ([customFieldArray count]+1>=WCT_FMC_UserDefine)
    {
        return NO;
    }
    
    //////////////////////////////////////////////////
    // 相等就不能再加入
    for (WCFieldModel *aFieldModel in customFieldArray)
    {
        if ([customFieldModel.customFieldInfoGuid compare:aFieldModel.customFieldInfoGuid options:NSCaseInsensitiveSearch]==NSOrderedSame)
        {
            return NO;
        }
    }
    
    return YES;
}


//==============================================================================
//
//==============================================================================
- (void)combineCustomFieldsWithCardModel:(WCCardModel *)cardModel
                   withRedandanceHandler:(NSString *(^)(WCFieldModel *redandanceField))redandanceHandler
{
    NSString *customFieldNoteString = @"";
    
    NSArray *userDefineArray = [cardModel fieldArrayWithType:WC_FT_UserDefine];
    
    for (WCFieldModel *currentFieldModel in userDefineArray)
    {
        // 自訂欄位一樣就不再合併
        if([self isCustomFieldValueExist:currentFieldModel])
        {
            continue;
        }
        
        if ([self canAddCustomFieldModel:currentFieldModel])
        {
            // 已存在，加到note
            [self addField:currentFieldModel];
        }
        else
        {
            // 不存在，加到field中
            if ([customFieldNoteString length]>0)
            {
                customFieldNoteString = [customFieldNoteString stringByAppendingString:@"\n"];
            }
            
            NSString *noteString = @"";
            if(redandanceHandler)
            {
                noteString = redandanceHandler(currentFieldModel);
            }
            
            customFieldNoteString = [customFieldNoteString stringByAppendingFormat:@"%@",noteString];
        }
    }
    
    //////////////////////////////////////////////////
    if ([customFieldNoteString length]>0)
    {
        NSArray *noteArray = [self fieldArrayWithType:WC_FT_Note];
        WCFieldModel *targetNoteFieldModel = [noteArray firstObject];
        if (targetNoteFieldModel==nil)
        {
            targetNoteFieldModel = [WCFieldModel newFieldModel];
            targetNoteFieldModel.type = WC_FT_Note;
            [self addField:targetNoteFieldModel];
            [targetNoteFieldModel release];
        }
        
        NSString *targetNote = targetNoteFieldModel.value;
        if ([targetNote length]>0)
        {
            targetNoteFieldModel.value  = [targetNote stringByAppendingFormat:@"\n%@", customFieldNoteString];
        }
        else
        {
            NSString *dateString = [[NSDate date] stringWithFormat:NSDateFormat_Day];
            NSString *mergedTitle = [NSString stringWithFormat:[@"MLS_MergeTitleFormat" localizedFromTable:@"WCFieldLabelString"], dateString];
            targetNoteFieldModel.value = [NSString stringWithFormat:@"%@\n%@",mergedTitle, customFieldNoteString];
        }
    }

}



@end
