//
//  WCTCompanyContactViewController.m
//
//
//  Created by Howard on 2016/4/11.
//
//

#import "WCTCompanyContactViewController.h"

// Define
#import "WCAppearanceDefine.h"
#import "WCSettingsKey.h"
#import "WCTCompanyContactViewController+ResourceDefine.h"
#import "WCTRestClientController+ParameterDefine.h"
#import "WCTSettingsKey.h"

// Controller
#import "PPAlertController.h"
#import "PPNavigationController.h"
#import "PPRefreshController.h"
#import "PPSettingsController.h"
#import "WCGroupAccessFlowController.h"
#import "WCTAccountDataController.h"
#import "WCTAccountSelectViewController.h"
#import "WCTCompanyContactFetchDataController.h"
#import "WCTCompanyContactGroupViewDelegateController.h"
#import "WCTCompanyContactMultiSelectViewController.h"
#import "WCTCompanyContactSearchViewController.h"
#import "WCToastController.h"
#import "WCTCompanyGroupAccessFlowDelegateController.h"
#import "WCTCompanyGroupSelectViewController.h"
#import "WCTAdvancedSearchViewController.h"

// View
#import "PPButton.h"
#import "PPFloatingMenuButton.h"
#import "PPNavigationBarView.h"

// Model
#import "WCTAccountRelationModel.h"
#import "WCTCompanyCardModel.h"

// Category
#import "NSError+Custom.h"
#import "NSObject+PPBusyView.h"
#import "UIViewController+ShareApplication.h"
#import "WCCardModel+WCTRCContactInfo.h"
#import "WCTableViewController+CompanyCardModel.h"
#import "WCTableViewController+CompanyContactFetchDataDelegate.h"
#import "WCTableViewController+ContactPageSearch.h"
#import "WCTableViewController+ShowError.h"
#import "WCTCompanyContactViewController+SettingsKey.h"
#import "WCGroupModel+Tree.h"
#import "WCTAdvancedSearchModel+WCTRCAdvancedSearchInfo.h"

@interface WCTCompanyContactViewController () <
PPButtonDelegate,
PPFloatingMenuButtonDelegate,
PPRefreshControllerDelegate,
WCTAccountSelectViewControllerDelegate,
WCAdvancedSearchViewControllerDelegate,
WCTAdvancedSearchViewControllerDelegate,
WCTCompanyGroupSelectViewControllerDelegate,
WCTCompanyContactMultiSelectViewControllerDelegate,
WCTCompanyContactSearchViewControllerDelegate,
WCMultiSelectViewControllerDelegate,
WCSearchViewControllerDelegate>

@property (nonatomic,retain) PPButton *backButton;
//@property (nonatomic,retain) PPButton *visibleAccountButton;
@property (nonatomic,retain) PPButton *multiSelectButton;
@property (nonatomic,retain) PPFloatingMenuButton *searchButton;
@property (nonatomic,retain) PPButton *downloadButton;
@property (nonatomic,retain) PPButton *shareToColleagueButton;
@property (nonatomic,retain) PPButton *changeOwnerButton;
@property (nonatomic,retain) PPButton *deleteButton;
@property (nonatomic,retain) NSArray *layoutConstraints;
@property (nonatomic,assign) NSUInteger selectedContactCount;
@property (nonatomic,retain) WCTCompanyContactGroupViewDelegateController *companyContactGroupViewDelegateController;
@property (nonatomic,retain) WCTCompanyContactMultiSelectViewController *multiSelectViewController;
@property (nonatomic,retain) WCTCompanyContactSearchViewController *searchViewController;
@property (nonatomic,retain) WCTCompanyGroupAccessFlowDelegateController *companyGroupAccessFlowDelegateController;
@property (nonatomic,retain) WCTAccountSelectViewController *accountSelectViewController;
@property (nonatomic,retain) PPRefreshController *refreshController;
@property (nonatomic,retain) PPNavigationBarView *navigationBarView;
@property (nonatomic,retain) NSString *curViewAccountGuid;
@property (nonatomic,retain) NSString *curViewAccountName;
@property (nonatomic,retain) NSString *curViewCategoryGuid;
@property (nonatomic,retain) NSString *curViewCategoryName;

/// 紀錄目前選取的帳號下次進入帳號群組選擇時預設會開啟到這個帳號
@property (nonatomic,retain) NSString *curSelectedAccountGuid;
@property (nonatomic,assign) WCTCompanyContactMultiSelectViewControllerInteriorAction interiorAction;
@property (nonatomic,assign) BOOL firstLogin;

/// 進階搜尋
@property (nonatomic, copy) WCTAdvancedSearchModel *currentSearchModel;

@end

@implementation WCTCompanyContactViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithMode:(PPSIC_Mode)mode
{
    if(self=[super initWithMode:mode])
    {
        self.enableLongPress = YES;
        
        //////////////////////////////////////////////////
        
        self.accountDictionary = [NSMutableDictionary dictionary];
        
        self.defaultFootViewHeight = WCTCCV_CameraButtonSize+WCTCCV_CameraButtonBottomMargin;
        
        //////////////////////////////////////////////////
        
        self.cellType = WCCardHolderCellType_CompanyContacts;
        
        //////////////////////////////////////////////////
        
        _companyContactGroupViewDelegateController = [[WCTCompanyContactGroupViewDelegateController alloc] init];
        
        //////////////////////////////////////////////////
        
        _accountRole = [WCTRC_Role_NormalUser retain];
        
        //////////////////////////////////////////////////
        
        // 建立refreshController
        self.refreshController = [PPRefreshController refreshControllerWithDelegate:self];
        
        if(self.refreshController!=nil)
        {
            self.refreshController.enabled = YES;
            self.refreshController.backgroundColor = WCTCompanyContactViewAppearance_BackgroundColor;
            // 設定indicator顏色
            [[PPActivityIndicatorView appearance] setLineColor:WCTCompanyContactViewAppearance_IndicatorColor];
            
            self.refreshController.infoPosition = PPRefreshControllerInfoPosition_Bottom;
        }
        
        //////////////////////////////////////////////////

        NSString *accountID = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
        
        if([accountID length]>0)
        {
            [PPSettingsController setDefaultStringValue:accountID withKey:WCTCompanyContactViewControllerSettingKey_ViewAccountGuid];
        }
        
        //////////////////////////////////////////////////

        _firstLogin = YES;
        
        //////////////////////////////////////////////////
        
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(receiveCompanyContactListHasChangedNotification:)
                                                     name:WCTCompanyContactListHasChangedNotificationName
                                                   object:nil];
        
        
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(receiveCompanyContactListHasChangedNotification:)
                                                     name:WCTCompanyContactHasDeletedNotificationName
                                                   object:nil];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    
    //////////////////////////////////////////////////
    
    self.delegate = nil;
    
    //////////////////////////////////////////////////

    [_multiSelectViewController release];
    _multiSelectViewController = nil;
    
    [_searchViewController release];
    _searchViewController = nil;
    
    _accountSelectViewController.delegate = nil;
    [_accountSelectViewController release];
    _accountSelectViewController = nil;
    
    [_curViewAccountGuid release];
    _curViewAccountGuid = nil;
    
    [_curViewAccountName release];
    _curViewAccountName = nil;
    
    [_curViewCategoryGuid release];
    _curViewCategoryGuid = nil;
    
    [_curViewCategoryName release];
    _curViewCategoryName = nil;
    
    [_curSelectedAccountGuid release];
    _curSelectedAccountGuid = nil;
    
    [_companyContactGroupViewDelegateController release];
    _companyContactGroupViewDelegateController = nil;
    
    self.accountDictionary = nil;
    self.companyContactAccessFlowDelegateController = nil;
    self.accountRole = nil;
    self.accountName = nil;
    
    //////////////////////////////////////////////////
    
    self.refreshController = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View's Event

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    self.curViewAccountGuid = [PPSettingsController stringValueWithKey:WCTCompanyContactViewControllerSettingKey_ViewAccountGuid];
    self.curViewCategoryGuid = [PPSettingsController stringValueWithKey:WCTCompanyContactViewControllerSettingKey_ViewCategryGuid];

    //////////////////////////////////////////////////
    
    [self removeBottomButton];
    [self prepareMainUI];
    
    //////////////////////////////////////////////////
    
    [WCTCompanyContactFetchDataController shareInstance].delegate = self;
    
    //////////////////////////////////////////////////
    
    if([self.curViewAccountName length]>0)
    {
        [self updateTitle];
    }
}


//================================================================================
//
//================================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
        
    //////////////////////////////////////////////////
    
    self.refreshController.targetScrollView = self.tableView;
    
    //////////////////////////////////////////////////
    
//    if(self.firstLogin==YES)
//    {
//        self.firstLogin = NO;
//
//        //////////////////////////////////////////////////
//
//        self.interiorAction = WCTCompanyContactMultiSelectViewControllerInteriorAction_VisibleAccount;
//
//        //////////////////////////////////////////////////
//        [self showGroupSelectControllerFromViewController:self];
////        [self showAccountSelectViewControllerFromSuperViewController:self style:WCTAccountSelectViewControllerStyle_ViewAccountSwitch];
//    }
//    // 重新讀取列表
//    else
        if(self.allCardSectionArray<=0)
    {
        [self setBusy:@(YES)];
        
        __block typeof(self) blockself = self;
        
        // 列表清除後，先取得分享設定，在取得列表
        [WCTAccountDataController updateSettingsFromServerWithCompleteHandler:^(BOOL hasNetwork) {
            [blockself clearAndFetchTableViewData];
        }];
        
    }
    else
    {
        self.refreshController.enabled = self.totalCardCount>self.cardIDArray.count ? YES: NO;
    }
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [self.refreshController hideInfoView];

    //////////////////////////////////////////////////

    [super viewWillDisappear:animated];
    
    //////////////////////////////////////////////////
    
    [WCTCompanyContactFetchDataController shareInstance].delegate = nil;
    
    [[WCTCompanyContactFetchDataController shareInstance] cancelFetchDataOperation];
    
    //////////////////////////////////////////////////
    
    [self removeMainUI];
    
    //////////////////////////////////////////////////
    
    self.waitShowingForContactInfo = NO;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)prepareMainUI
{
    do
    {
        if(self.navigationController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.backButton = [PPButton ppButtonWithSystemBackImitation];
        
        if(self.backButton==nil)
        {
            break;
        }
        
        [self.backButton setImageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        [self.backButton setDelegate:self];
        [self.backButton setTag:WCTCompanyViewControllerButtonTag_Back];
        [self.backButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        // !! 改為先進切換檢視，所以不需要這個按鈕了
//        self.visibleAccountButton = [PPButton ppButtonWithIconImageName:ImageNameCompanyContactViewControllerVisibleAccount
//                                                                    tag:WCTCompanyViewControllerButtonTag_VisibleAccount
//                                                               delegate:self
//                                                  normalBackgroundColor:nil
//                                             highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
//                                                        imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
//
//        if(self.visibleAccountButton==nil)
//        {
//            break;
//        }
//
//        [self.visibleAccountButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        self.multiSelectButton = [PPButton ppButtonWithIconImageName:ImageNameCompanyContactViewControllerMultiSelect
                                                                 tag:WCTCompanyViewControllerButtonTag_MultiSelect
                                                            delegate:self
                                               normalBackgroundColor:nil
                                          highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                     imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        
        //////////////////////////////////////////////////
        
        if(self.multiSelectButton==nil)
        {
            break;
        }
        
        [self.multiSelectButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        PPNavigationBarView *navigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        
        if(navigationBarView==nil)
        {
            break;
        }
        
        navigationBarView.style = PPBarViewStyle_CenteredRelative;
        [navigationBarView setViews:@[self.backButton] forBlockType:PPBarViewBlockType_Left];
        
        //唯讀帳號，不是檢視自已帳號下的聯絡人，不允許多選操作
        if([self.accountRole compare:WCTRC_Role_ReadOnlyUser options:NSCaseInsensitiveSearch]==NSOrderedSame)
        {
            if([self.curViewAccountGuid length]>0 &&
               [self.curViewAccountGuid compare:[PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID] options:NSCaseInsensitiveSearch]==NSOrderedSame)
            {
                [navigationBarView setViews:@[self.multiSelectButton] forBlockType:PPBarViewBlockType_Right];
            }
        }
        else
        {
            [navigationBarView setViews:@[self.multiSelectButton] forBlockType:PPBarViewBlockType_Right];
        }
        
        self.navigationBarView = navigationBarView;
        
        //////////////////////////////////////////////////
        
        UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:navigationBarView];
        
        [navigationBarView release];
        
        if(leftBarButtonItem==nil)
        {
            break;
        }
        
        self.navigationItem.leftBarButtonItem = leftBarButtonItem;
        [leftBarButtonItem release];
        
        //////////////////////////////////////////////////
        
        // Search Button
        self.searchButton = [[[PPFloatingMenuButton alloc] initWithDelegate:self
                                                                 identifier:WCTCompanyViewControllerButtonTag_Search] autorelease];
        
        if(self.searchButton!=nil)
        {
            [self.searchButton setTranslatesAutoresizingMaskIntoConstraints:NO];
            
            
            UIImage *image = [UIImage imageWithName:ImageNameCompanyContactViewControllerSearch forState:UIControlStateNormal];
            [self.searchButton setMainButtonBackgroundImage:image forState:UIControlStateNormal];
            
            //////////////////////////////////////////////////
            
            image = [UIImage imageWithName:ImageNameCompanyContactViewControllerSearch forState:UIControlStateHighlighted];
            [self.searchButton setMainButtonBackgroundImage:image forState:UIControlStateHighlighted];
            
            [self.view addSubview:self.searchButton];
        }
        
        //////////////////////////////////////////////////
        
        [self resetLayoutConstraints];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)removeMainUI
{
    self.backButton.delegate = nil;
    [self.backButton removeFromSuperview];
    self.backButton = nil;
    
//    //////////////////////////////////////////////////
//
//    self.visibleAccountButton.delegate = nil;
//    [self.visibleAccountButton removeFromSuperview];
//    self.visibleAccountButton = nil;
//
    //////////////////////////////////////////////////
    
    self.multiSelectButton.delegate = nil;
    [self.multiSelectButton removeFromSuperview];
    self.multiSelectButton = nil;
    
    //////////////////////////////////////////////////
    
    [self.searchButton removeFromSuperview];
    self.searchButton = nil;
    
    //////////////////////////////////////////////////
    
    [self removeLayoutConstraints];
    
    //////////////////////////////////////////////////
    
    [self.navigationBarView removeFromSuperview];
    self.navigationBarView = nil;
}


//================================================================================
//
//================================================================================
- (void)prepareBottomButton
{
    do
    {
        
        // 下方工具列
        self.downloadButton = [PPButton ppButtonWithIconImageName:ImageNameCompanyContactViewControllerButtonDownload
                                                              tag:WCTCompanyViewControllerButtonTag_Download
                                                         delegate:self
                                            normalBackgroundColor:nil
                                       highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                  imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        
        if(self.downloadButton==nil)
        {
            break;
        }
        
        [self.downloadButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        self.shareToColleagueButton = [PPButton ppButtonWithIconImageName:ImageNameCompanyContactViewControllerButtonShareToColleague
                                                                      tag:WCTCompanyViewControllerButtonTag_ShareToColleague
                                                                 delegate:self
                                                    normalBackgroundColor:nil
                                               highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                          imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        
        if(self.shareToColleagueButton==nil)
        {
            break;
        }
        
        [self.shareToColleagueButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        self.changeOwnerButton = [PPButton ppButtonWithIconImageName:ImageNameCompanyContactViewControllerButtonChangeOwner
                                                                 tag:WCTCompanyViewControllerButtonTag_ChangeOwner
                                                            delegate:self
                                               normalBackgroundColor:nil
                                          highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                     imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        
        if(self.changeOwnerButton==nil)
        {
            break;
        }
        
        [self.changeOwnerButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        self.deleteButton = [PPButton ppButtonWithIconImageName:ImageNameCompanyContactViewControllerButtonDelete
                                                            tag:WCTCompanyViewControllerButtonTag_Delete
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        
        if(self.deleteButton==nil)
        {
            break;
        }
        
        [self.deleteButton addControlEvents:UIControlEventTouchUpInside];
        
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (void)removeBottomButton
{
    self.downloadButton.delegate = nil;
    [self.downloadButton removeFromSuperview];
    self.downloadButton = nil;
    
    //////////////////////////////////////////////////
    
    self.shareToColleagueButton.delegate = nil;
    [self.shareToColleagueButton removeFromSuperview];
    self.shareToColleagueButton = nil;
    
    //////////////////////////////////////////////////
    
    self.changeOwnerButton.delegate = nil;
    [self.changeOwnerButton removeFromSuperview];
    self.changeOwnerButton = nil;
    
    //////////////////////////////////////////////////
    
    self.deleteButton.delegate = nil;
    [self.deleteButton removeFromSuperview];
    self.deleteButton = nil;
}


//==============================================================================
//
//==============================================================================
- (void)updateTitle
{
    NSString *title = nil;
    
    if([[PPSettingsController stringValueWithKey:WCTCompanyContactViewControllerSettingKey_ViewAccountGuid] length]<=0)
    {
        title = WCTCCV_MLS_AllCompanySharedContacts;
    }
    else if([self.curViewCategoryName length]>0)
    {
        title = [NSString stringWithFormat:@"%@(%@)",self.curViewAccountName, self.curViewCategoryName];
    }
    else
    {
        title = [self.curViewAccountName stringByAppendingString:[NSString stringWithFormat:@" %@",WCTCCV_MLS_SharedContacts]];
    }
    
    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        
        blockself.navigationBarView.titleLabel.text = title;
        
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private layout constraints methods

//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    do
    {
        if(self.searchButton==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self removeLayoutConstraints];
        
        //////////////////////////////////////////////////
        
        NSMutableArray *layoutConstraints = [NSMutableArray array];
        
        if(layoutConstraints==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // horizontal
        
        CGFloat bottomConstant = -WCTCCV_MenuButtonBottomMargin;
        CGFloat buttonSize = WCTCCV_MenuButtonSize;
        
        
        [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.searchButton
                                                                  attribute:NSLayoutAttributeBottom
                                                                  relatedBy:NSLayoutRelationEqual
                                                                     toItem:self.view
                                                                  attribute:NSLayoutAttributeBottom
                                                                 multiplier:1.0
                                                                   constant:bottomConstant]];
        
        // 按鈕的中心位置，以parent的寬度平分來設定
        
        [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.searchButton
                                                                  attribute:NSLayoutAttributeCenterX
                                                                  relatedBy:NSLayoutRelationEqual
                                                                     toItem:self.view
                                                                  attribute:NSLayoutAttributeCenterX
                                                                 multiplier:1.0
                                                                   constant:0]];
        
        [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.searchButton
                                                                  attribute:NSLayoutAttributeWidth
                                                                  relatedBy:NSLayoutRelationEqual
                                                                     toItem:nil
                                                                  attribute:NSLayoutAttributeWidth
                                                                 multiplier:1.0
                                                                   constant:buttonSize]];
        
        [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.searchButton
                                                                  attribute:NSLayoutAttributeHeight
                                                                  relatedBy:NSLayoutRelationEqual
                                                                     toItem:nil
                                                                  attribute:NSLayoutAttributeWidth
                                                                 multiplier:1.0
                                                                   constant:buttonSize]];
        
        
        
        //////////////////////////////////////////////////
        
        if([layoutConstraints count] >0)
        {
            self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
            [self.view addConstraints:self.layoutConstraints];
            [self.view layoutIfNeeded];
        }
    }
    while (0);
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private ContactList Method


//==============================================================================
//
//==============================================================================
- (WCTAccountRelationModel *)validAccountModelWithAccountGuid:(NSString *)accountGuid error:(NSError **)error
{
    // 如果紀錄的帳號不存在，預設取自己
    WCTAccountRelationModel *accountsInfo = nil;

    NSError *returnError = nil;
    NSArray *models = [WCTAccountSelectViewController fetchViewAccountListWithError:&returnError allCompanyContact:YES];
    
    if(returnError!=nil)
    {
        if(error!=NULL)
        {
            *error = returnError;
        }
        
        return accountsInfo;
    }
    
    if([models count]==0)
    {
        if(error!=NULL)
        {
            *error = PPErrorMake(9999, @"不會有這個情況，應該至少會有自已，需要檢查", nil);
        }
        
        // !!不會有這個情況，應該至少會有自已
        return accountsInfo;
    }
    
    //////////////////////////////////////////////////
    
    for (WCTAccountRelationModel *accountRelationModel in models)
    {
        if (accountGuid!=nil)
        {
            if([accountRelationModel.guid isEqualToString:accountGuid])
            {
                accountsInfo = accountRelationModel;
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        // 紀錄自已的guid, 如果都沒有與之前紀錄的
        if([accountsInfo.guid compare:[PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID] options:NSCaseInsensitiveSearch]==NSOrderedSame)
        {
            accountsInfo = accountRelationModel;
        }
    }

    return accountsInfo;
}


//==============================================================================
// 找不到時會回傳nil,
//==============================================================================
- (NSString *)validCategoryGuidWithAccountGuid:(NSString *)accountGuid categoryGuid:(NSString *)categoryGuid error:(NSError **)error
{
    self.curViewCategoryName = nil;
    
    //////////////////////////////////////////////////
    // 檢查群組guid是否合法
    // 可以是空的代表全取
    if ([categoryGuid length]==0)
    {
        return categoryGuid;
    }
    
    NSError *returnError = nil;
    NSMutableArray *categorys = [[WCTCompanyContactFetchDataController shareInstance] groupArrayWithAccountGuid:accountGuid error:&returnError];
    
    if (returnError)
    {
        if (error!=NULL)
        {
            *error = returnError;
        }
        return nil;
    }
    
    for (WCGroupModel *groupModel in categorys)
    {
        if ([groupModel.guid isEqualToString:categoryGuid])
        {
            self.curViewCategoryName = groupModel.name;
            return groupModel?[groupModel guid]:@"";
        }
    }
    
    
    return @"";
}



//================================================================================
// MARK: 清除畫面，重新取得列表資訊
//================================================================================
- (void)clearAndFetchTableViewData
{
    self.allCardSectionArray = nil;
    
    //////////////////////////////////////////////////
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        // TODO: 這邊判斷的目的是什麼不清楚?? 可能會造成title更新不正常
//        if([self.curViewAccountName length]<=0)
        {
            NSError *returnError = nil;
            
            //////////////////////////////////////////////////
            
            //取得合法的帳號資料
            NSString *historyViewAccountGuid = [PPSettingsController stringValueWithKey:WCTCompanyContactViewControllerSettingKey_ViewAccountGuid];
            NSString *historyViewCategoryGuid = [PPSettingsController stringValueWithKey:WCTCompanyContactViewControllerSettingKey_ViewCategryGuid];

            WCTAccountRelationModel *accountsInfo = [self validAccountModelWithAccountGuid:historyViewAccountGuid error:&returnError];
            
            if (returnError!=nil)
            {
                __block typeof(self) blockself = self;
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    [blockself setBusy:@(NO)];
                    
                    //////////////////////////////////////////////////
                    
                    [WCToastController showMessageToastFromSuperView:blockself.view
                                                         withMessage:[blockself requestCompanyCustomNonEmptyMessageFromError:returnError]
                                                            position:PPToastPositionCenter];
                    
                });
                
                return;
            }
            
            //////////////////////////////////////////////////
            // 如果與之前的guid不同，清除類別guid
            if ([historyViewAccountGuid isEqualToString:accountsInfo.guid]==NO)
            {
                [PPSettingsController removeValueWithKey:WCTCompanyContactViewControllerSettingKey_ViewCategryGuid];
                historyViewCategoryGuid = nil;
            }
            
            //////////////////////////////////////////////////
            // 取得合法群組guid
            self.curViewCategoryGuid = [self validCategoryGuidWithAccountGuid:accountsInfo.guid categoryGuid:historyViewCategoryGuid error:&returnError];
                        
            //////////////////////////////////////////////////
            // 記錄目前的帳號
            self.curViewAccountGuid = accountsInfo.guid;
            self.curViewAccountName = accountsInfo.name;

            
            //////////////////////////////////////////////////
            // 設定title
            [self updateTitle];
            
            //////////////////////////////////////////////////
            
            self.curViewCategoryGuid = historyViewCategoryGuid;
            
            //////////////////////////////////////////////////
            
            //開始取得帳號下連絡人資訊
            [[WCTCompanyContactFetchDataController shareInstance] fetchCardSectionModelWithContactAccountGuid:self.curViewAccountGuid
                                                                                                 categoryGuid:self.curViewCategoryGuid
                                                                                                    pageIndex:[self.cardIDArray count]/WCTClientControllerNumberPerPage];

         
        }
//        else
//        {
//            //開始取得帳號下連絡人資訊
//            [[WCTCompanyContactFetchDataController shareInstance] fetchCardSectionModelWithContactAccountGuid:self.curViewAccountGuid
//                                                                                                 categoryGuid:self.curViewCategoryGuid
//                                                                                                    pageIndex:[self.cardIDArray count]/WCTClientControllerNumberPerPage];
//        }
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Show GroupSelector Method


//==============================================================================
//
//==============================================================================
- (void)showGroupSelectControllerFromViewController:(WCTableViewController *)viewController
{
    WCTCompanyGroupSelectViewController *companyGroupSelectViewController = [[WCTCompanyGroupSelectViewController alloc] init];
    companyGroupSelectViewController.titleString = WCTCCV_MLS_SwitchViewOfContacts;
    companyGroupSelectViewController.delegate = self;
    [companyGroupSelectViewController showFromViewController:viewController forcePresent:YES];
    [companyGroupSelectViewController release];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Show MultiSelect Method

//================================================================================
//
//================================================================================
- (void)showMultiSelectControllerFromViewController:(WCTableViewController *)viewController
                                    selectedCardIDs:(NSArray <NSString *> *)selectedCardIDs
{
    do
    {
        if(viewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if([viewController contactCardCount]<=0)
        {
            UIView *presentedView = viewController.view;
            
            if([viewController respondsToSelector:@selector(tableView)]==YES)
            {
                presentedView = [viewController performSelector:@selector(tableView)];
            }
            
            //////////////////////////////////////////////////
            
            [WCToastController showMessageToastFromSuperView:presentedView
                                                 withMessage:WCTCCV_MLS_NoContact
                                                    position:PPToastPositionCenter];
        }
        else
        {
            WCTCompanyContactMultiSelectViewController *multiSelectViewController = [[WCTCompanyContactMultiSelectViewController alloc] initWithMode:PPSIC_M_None];
            
            if(multiSelectViewController!=nil)
            {
                multiSelectViewController.delegate = self;
                multiSelectViewController.contactMultiSelectViewControllerDelegate = self;
                multiSelectViewController.totalCardCount = self.totalCardCount;
                multiSelectViewController.allCardSectionArray = viewController.allCardSectionArray;
                multiSelectViewController.curViewAccountGuid = self.curViewAccountGuid;
                multiSelectViewController.curViewCategoryGuid = self.curViewCategoryGuid;

                //////////////////////////////////////////////////
                
                multiSelectViewController.cellType = WCCardHolderCellType_CompanyContacts;
                
                //////////////////////////////////////////////////
                
                PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:multiSelectViewController];
                
                if(navigationController!=nil)
                {
                    [viewController presentViewController:navigationController
                                                 animated:YES
                                               completion:nil];
                }
                
                [navigationController release];
            }
            
            //////////////////////////////////////////////////
            
            // 處理被選取的ID
            for (NSString *cardID in selectedCardIDs)
            {
                [multiSelectViewController selectCellWithCardID:cardID];
            }
            
            //////////////////////////////////////////////////
            
            self.multiSelectViewController = multiSelectViewController;
            
            [multiSelectViewController release];
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Show AccountSelectViewCotnroller Method

//================================================================================
//
//================================================================================
- (void)showAccountSelectViewControllerFromSuperViewController:(WCTableViewController *)superViewController
                                                         style:(WCTAccountSelectViewControllerStyle)style
{
    do
    {
        if(superViewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTAccountSelectViewController *accountSelectViewController = [[WCTAccountSelectViewController alloc] init];
        
        if(accountSelectViewController==nil)
        {
            break;
        }
        
        accountSelectViewController.delegate = self;
        accountSelectViewController.style = style;
        
        //////////////////////////////////////////////////
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:accountSelectViewController];
        
        self.accountSelectViewController = accountSelectViewController;
        
        //////////////////////////////////////////////////
        
        [accountSelectViewController release];
        
        if(navigationController==nil)
        {
            break;
        }
        
        [superViewController presentViewController:navigationController
                                          animated:YES
                                        completion:nil];
        
        [navigationController release];
    }
    while (0);
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private PPLoadControl Method

//================================================================================
//
//================================================================================
- (void)manualLoadContactsWithSender:(id)sender
{
    //取列表資料
    [[WCTCompanyContactFetchDataController shareInstance] fetchCardSectionModelWithContactAccountGuid:self.curViewAccountGuid
                                                                                         categoryGuid:self.curViewCategoryGuid
                                                                                            pageIndex:[self.cardIDArray count]/WCTClientControllerNumberPerPage];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Request Error Message Method

//================================================================================
//
//================================================================================
- (NSString *)requestCompanyCustomMessageFromError:(NSError *)error
{
    NSString *errorMessage = nil;
    
    do
    {
        if(error==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        if([self.delegate respondsToSelector:@selector(companyContactViewController:requestMessageFromError:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        errorMessage = [self.delegate companyContactViewController:self requestMessageFromError:error];
    }
    while (0);

    //////////////////////////////////////////////////

    return errorMessage;
}


//================================================================================
//
//================================================================================
- (NSString *)requestCompanyCustomNonEmptyMessageFromError:(NSError *)error
{
    NSString *message = [self requestCompanyCustomMessageFromError:error];
    
    if([message length]<=0)
    {
        message = [error alertMessage];
    }
    
    return message;
}
                                                            




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Method

//================================================================================
//
//================================================================================
- (void)receiveCompanyContactListHasChangedNotification:(NSNotification *)notification
{
    self.allCardSectionArray = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    WCCardHolderCell *cardHolderCell = (WCCardHolderCell *)[super tableView:tableView cellForRowAtIndexPath:indexPath];
    
    if(cardHolderCell!=nil)
    {
        if([self.accountRole compare:WCTRC_Role_ReadOnlyUser]==NSOrderedSame &&
           [self.curViewAccountGuid compare:[PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID]
                                    options:NSCaseInsensitiveSearch]!=NSOrderedSame)
        {
            cardHolderCell.additionButton.hidden = YES;
        }
        else
        {
            cardHolderCell.additionButton.hidden = NO;
            
            //////////////////////////////////////////////////
            
            if([self contactDownloadStatusWithCardID:cardHolderCell.cardID]==WCTCompanyCardModelDownloadStatus_Done)
            {
                [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonDownloaded];
            }
            else if([self contactDownloadStatusWithCardID:cardHolderCell.cardID]==WCTCompanyCardModelDownloadStatus_Downloading)
            {
                [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonNeedDownload];
            }
            else
            {
                [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonNeedDownload];
            }
        }
        
        //////////////////////////////////////////////////
        
        cardHolderCell.cardID = [self companyCardModelWithIndexPath:indexPath].ID;
    }
    
    return cardHolderCell;
}


//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if(self.waitShowingForContactInfo==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTCompanyCardModel *cardModel = [self companyCardModelWithIndexPath:indexPath];
        
        if(cardModel==nil ||
           [[cardModel ID] length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.waitShowingForContactInfo = YES;
        
        //////////////////////////////////////////////////
        
        [self setBusy:@(YES)];
        
        [[WCTCompanyContactFetchDataController shareInstance] detailContactWithContactGuid:[cardModel ID]];
        
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (PPRefreshController *)companyRefreseController;
{
    return self.refreshController;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override WCTableViewController Method

//================================================================================
//
//================================================================================
- (NSString *)companyContactCustomMessageFromError:(NSError *)error
{
    return [self requestCompanyCustomMessageFromError:error];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Public methods


//==============================================================================
//
//==============================================================================
- (BOOL)hasContactInfoBeChanged
{
    return (self.multiSelectViewController.contactInfoHasChanged==YES ||self.contactInfoHasChanged==YES);
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButton Delegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    NSString *loginAccountGuid = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
    
    //////////////////////////////////////////////////
    
    switch (ppButton.tag)
    {
        case WCTCompanyViewControllerButtonTag_Back:
        {
            // MARK:點擊退出
            [self goBackAnimated:YES];
            // 當自動同步關閉，且名片變更; 退開畫面時，詢問是否進行手動同步
            //            if((self.multiSelectViewController.contactInfoHasChanged==YES ||
            //                self.contactInfoHasChanged==YES))
            //            {
            //                if([PPSettingsController integerValueWithKey:WCSC_IV_kSyncNetWorkSource]==WCSyncNetWorkSource_None)
            //                {
            //                    __block typeof(self) blockself = self;
            //
            //                    PPAlertController *alertController = [PPAlertController alertControllerWithAlertControllerStyle:UIAlertControllerStyleAlert
            //                                                                                                              title:@""
            //                                                                                                            message:WCTCCV_MLS_ContactChangedAndQueryIfManualSync
            //                                                                                                        alertAction:
            //
            //                                                          [UIAlertAction actionWithTitle:WCTCCV_MLS_Cancel
            //                                                                                   style:UIAlertActionStyleCancel
            //                                                                                 handler:^(UIAlertAction * _Nonnull action) {
            //                                                                                     [blockself requestSnedDismissDelegateWithManualSync:NO];
            //                                                                                 }]
            //
            //                                                          //////////////////////////////////////////////////
            //
            //                                                          ,[UIAlertAction actionWithTitle:WCTCCV_MLS_OK
            //                                                                                    style:UIAlertActionStyleDefault
            //                                                                                  handler:^(UIAlertAction * _Nonnull action) {
            //                                                                                      [blockself requestSnedDismissDelegateWithManualSync:YES];
            //                                                                                  }
            //                                                            ]
            //                                                          ,nil
            //                                                          ];
            //
            //                    //////////////////////////////////////////////////
            //
            //                    if(alertController!=nil)
            //                    {
            //                        [self presentViewController:alertController animated:YES completion:nil];
            //                    }
            //                }
            //                else
            //                {
            //                    [self requestSnedDismissDelegateWithManualSync:YES];
            //                }
            //            }
            //            else
            //            {
            //                //連絡人資料沒變更，直接退出
            //                [self requestSnedDismissDelegateWithManualSync:NO];
            //            }
            
            break;
        }
        case WCTCompanyViewControllerButtonTag_VisibleAccount:
        {
            // MARK: 點擊可檢視帳號
            self.interiorAction = WCTCompanyContactMultiSelectViewControllerInteriorAction_VisibleAccount;
            
            //////////////////////////////////////////////////
            [self showGroupSelectControllerFromViewController:self];
            
            break;
        }
        case WCTCompanyViewControllerButtonTag_MultiSelect:
        {
            // MARK: 點擊多選
            if([[self companyRefreseController] canRefresh]==NO)
            {
                [self setBusy:@(NO)];
            }
            else
            {
                [[self companyRefreseController] hideInfoView];
            }
            
            
            //////////////////////////////////////////////////
            
            [self showMultiSelectControllerFromViewController:self selectedCardIDs:nil];
            
            break;
        }
        case WCTCompanyViewControllerButtonTag_Delete:
        {
            // MARK: 多選下，點擊刪除
            
            if([self selectedContactCount]<=0)
            {
                [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view
                                                     withMessage:WCTCCV_MLS_NoSelection
                                                        position:PPToastPositionCenter];
            }
            
            
            //////////////////////////////////////////////////
            
            if([self.accountRole compare:WCTRC_Role_Admin]!=NSOrderedSame &&
               loginAccountGuid!=nil &&
               [self.curViewAccountGuid compare:loginAccountGuid]!=NSOrderedSame)
            {
                [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view
                                                     withMessage:WCTCCV_MLS_DontDeleteOtherShareContacts
                                                        position:PPToastPositionCenter];
            }
            else
            {
                __block typeof(self) blockself = self;
                
                PPAlertController *alertController = [PPAlertController alertControllerWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                                                                          title:@""
                                                                                                        message:WCTCCV_MLS_ConfirmDeleteContacts
                                                                                                    alertAction:
                                                      
                                                      [UIAlertAction actionWithTitle:WCTCCV_MLS_Cancel
                                                                               style:UIAlertActionStyleCancel
                                                                             handler:nil],
                                                      
                                                      //////////////////////////////////////////////////
                                                      
                                                      [UIAlertAction actionWithTitle:WCTCCV_MLS_Delete
                                                                               style:UIAlertActionStyleDefault
                                                                             handler:^(UIAlertAction * _Nonnull action) {
                                                                                 do
                                                                                 {
                                                                                     NSArray *selectContactIDs = [blockself.multiSelectViewController.multiSelectCardIDSet allObjects];
                                                                                     
                                                                                     if(selectContactIDs.count<=0)
                                                                                     {
                                                                                         break;
                                                                                     }
                                                                                     
                                                                                     //////////////////////////////////////////////////
                                                                                     
                                                                                     [blockself.multiSelectViewController setBusy:@(YES)];
                                                                                     
                                                                                     //////////////////////////////////////////////////
                                                                                     
                                                                                     [[WCTCompanyContactFetchDataController shareInstance] deleteContactWithContactGuids:selectContactIDs
                                                                                                                                                         progressHandler:^(CGFloat progress) {
                                                                                                                                                             [PPBusyView postMessage:[NSString stringWithFormat:@"%.2f%s",progress*100.0,"%"]];
                                                                                                                                                         }
                                                                                                                                                                complete:^(NSArray<WCTRCGuidWithData *> *errorDataList, NSError *error) {
                                                                                                                                                                    [blockself.multiSelectViewController deletedCompanyContactGuids:selectContactIDs
                                                                                                                                                                                                               contactFailureResult:errorDataList
                                                                                                                                                                                                                          withError:error];
                                                                                                                                                                    
                                                                                                                                                                }];
                                                                                 }
                                                                                 while (0);
                                                                                 
                                                                             }
                                                       ],
                                                      nil
                                                      ];
                
                if(alertController!=nil)
                {
                    [self.multiSelectViewController presentViewController:alertController animated:YES completion:nil];
                }
            }
            break;
        }
        case WCTCompanyViewControllerButtonTag_Download:
        {
            // MARK: 多選下，點擊下載
            if([self selectedContactCount]<=0)
            {
                [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view
                                                     withMessage:WCTCCV_MLS_NoSelection
                                                        position:PPToastPositionCenter];
            }
            else
            {
                [self.multiSelectViewController setBusy:@(YES)];
                
                //////////////////////////////////////////////////
                
                __block NSError *returnError = nil;
                __block typeof(self) blockself = self;
                
                dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                    
                    do
                    {
                        NSArray *selectContactIDs = [self.multiSelectViewController.multiSelectCardIDSet allObjects];
                        
                        if(selectContactIDs.count<=0)
                        {
                            break;
                        }
                        
                        //////////////////////////////////////////////////
                        
                        NSMutableArray *unDownloadContactIDs = [NSMutableArray array];
                        
                        if(unDownloadContactIDs==nil)
                        {
                            break;
                        }
                        
                        //////////////////////////////////////////////////
                        
                        for(NSString *contactID in selectContactIDs)
                        {
                            WCTCompanyCardModel *cardModel = [self.multiSelectViewController companyCardModelWithCardID:contactID];
                            
                            if(cardModel==nil)
                            {
                                continue;
                            }
                            
                            if(cardModel.downloadStatus==WCTCompanyCardModelDownloadStatus_UnDone)
                            {
                                [unDownloadContactIDs addObject:contactID];
                            }
                        }
                        
                        //////////////////////////////////////////////////
                        
                        if(unDownloadContactIDs.count>0)
                        {
                            self.companyContactGroupViewDelegateController.categoryList = [[WCTCompanyContactFetchDataController shareInstance] categoryListWithError:&returnError];
                            
                            [returnError retain];
                            
                            dispatch_async(dispatch_get_main_queue(), ^{
                                
                                [blockself.multiSelectViewController setBusy:@(NO)];
                                
                                //////////////////////////////////////////////////
                                
                                if([self.companyContactGroupViewDelegateController.categoryList count]>0)
                                {
                                    blockself.companyContactGroupViewDelegateController.userName = blockself.accountName;
                                    [blockself.companyContactGroupViewDelegateController showGroupViewControllerWithUserInfo:selectContactIDs
                                                                                                          fromViewController:blockself.multiSelectViewController];
                                }
                                else
                                {
                                    [WCTableViewController showAlertError:returnError fromViewController:blockself.multiSelectViewController failConnectCompletion:nil];
                                }
                                
                                //////////////////////////////////////////////////
                                
                                [returnError release];
                            });
                        }
                        else
                        {
                            // 沒資料下載時，停0.5秒，讓畫面不會閃一下
                            [NSThread sleepForTimeInterval:0.5];
                            
                            dispatch_async(dispatch_get_main_queue(), ^{
                                
                                [blockself.multiSelectViewController setBusy:@(NO)];
                                
                                //////////////////////////////////////////////////
                                
                                //點擊的連絡人全都不需要下載
                                [WCToastController showMessageToastFromSuperView:blockself.multiSelectViewController.view
                                                                     withMessage:WCTCCV_MLS_ContactAlreadyDownloaded
                                                                        position:PPToastPositionCenter];
                            });
                            
                        }
                        
                    }
                    while (0);
                    
                    // global queue end
                });
            }
            break;
        }
        case WCTCompanyViewControllerButtonTag_ShareToColleague:
        {
            // MARK: 點擊分享至同事
            
            if([self selectedContactCount]<=0)
            {
                [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view
                                                     withMessage:WCTCCV_MLS_NoSelection
                                                        position:PPToastPositionCenter];
            }
            else
            {
                // !! 1.8.5
                __block typeof(self) blockSelf = self;
                            
                __block BOOL hasOtherAccount = YES;
                dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                    if([blockSelf.delegate respondsToSelector:@selector(checkAndAlertWithCompanyContactViewController:needCheckShareToCompany:)])
                    {
                        hasOtherAccount = [blockSelf.delegate checkAndAlertWithCompanyContactViewController:blockSelf needCheckShareToCompany:YES];
                    }
                    
                    //////////////////////////////////////////////////
                    dispatch_async(dispatch_get_main_queue(), ^{
                        
                        if(hasOtherAccount)
                        {
                            self.interiorAction = WCTCompanyContactMultiSelectViewControllerInteriorAction_ShareToColleague;
                            
                            //////////////////////////////////////////////////
                            
                            [self showAccountSelectViewControllerFromSuperViewController:self.multiSelectViewController
                                                                                   style:WCTAccountSelectViewControllerStyle_ShareToColleague];
                        }
                    });
                });
            }
            break;
        }
        case WCTCompanyViewControllerButtonTag_ChangeOwner:
        {
            // MARK: 點擊改變擁有者
            if([self selectedContactCount]<=0)
            {
                [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view
                                                     withMessage:WCTCCV_MLS_NoSelection
                                                        position:PPToastPositionCenter];
            }
            else
            {
                // !! 1.8.5
                __block typeof(self) blockSelf = self;
                
                __block BOOL hasOtherAccount = YES;
                dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                    if([blockSelf.delegate respondsToSelector:@selector(checkAndAlertWithCompanyContactViewController:needCheckShareToCompany:)])
                    {
                        hasOtherAccount = [blockSelf.delegate checkAndAlertWithCompanyContactViewController:blockSelf needCheckShareToCompany:NO];
                    }
                    
                    //////////////////////////////////////////////////
                    dispatch_async(dispatch_get_main_queue(), ^{
                        
                        if(hasOtherAccount)
                        {
                            blockSelf.interiorAction = WCTCompanyContactMultiSelectViewControllerInteriorAction_ChangeOwner;
                            
                            //////////////////////////////////////////////////
                            
                            [blockSelf showAccountSelectViewControllerFromSuperViewController:blockSelf.multiSelectViewController
                                                                                   style:WCTAccountSelectViewControllerStyle_ChangeOwner];
                        }
                    });
                });
            }
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPFloatingMenuButton Delegate Method

//================================================================================
//
//================================================================================
- (void)floatingMenuButton:(id)button didTapButtonWithIdentifier:(NSInteger)identifier
{
    do
    {
        if([button isKindOfClass:[PPFloatingMenuButton class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        switch (identifier)
        {
            case WCTCompanyViewControllerButtonTag_Search:
            {
                // MARK:點擊搜尋按鈕
                
                WCTCompanyContactSearchViewController *searchViewController = [[WCTCompanyContactSearchViewController alloc] initWithMode:PPSIC_M_None];
                
                if(searchViewController!=nil)
                {
                searchViewController.companyContactSearchViewControllerDelegate = self;
                    
                    searchViewController.delegate = self;
                    searchViewController.userName = self.accountName;
                    searchViewController.cellType = WCCardHolderCellType_CompanyContacts;
                    searchViewController.accountRole = self.accountRole;
                    searchViewController.showAdvanceSearch = YES;
                    //////////////////////////////////////////////////
                    
                    PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:searchViewController];
                    
                    if(navigationController!=nil)
                    {
                        [self presentViewController:navigationController
                                           animated:YES
                                         completion:nil];
                    }
                    
                    [navigationController release];
                }
                
                self.searchViewController = searchViewController;
                
                [searchViewController release];
                
                break;
            }
            default:
            {
                break;
            }
        }
    }
    while (0);
    
}


//================================================================================
//
//================================================================================
- (void)floatingMenuButton:(id)button didTapItemWithIdentifier:(NSInteger)UIBackgroundTaskIdentifier
{
    
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPRefreshControllerDelegate method

//================================================================================
//
//================================================================================
- (void)refreshControllerInfoViewWillAppear:(PPRefreshController *)refreshController
{
    [self.searchButton setAlpha:0];
    
    //////////////////////////////////////////////////
    
    [self manualLoadContactsWithSender:refreshController];
}


//================================================================================
//
//================================================================================
- (void)refreshControllerInfoViewDidDisappear:(PPRefreshController *)refreshController
{
    [PPFloatingMenuButton beginAnimations:NULL context:nil];
    [PPFloatingMenuButton setAnimationDuration:0.5];
    [self.searchButton setAlpha:1];
    [PPFloatingMenuButton commitAnimations];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCCardHolderCellDelegate Method

//================================================================================
// MARK: 和伺服器要求此筆資料註記下載
//================================================================================
- (void)didClickAdditionButtonWithCell:(WCCardHolderCell *)cell
{
    // MARK: 單筆下載
    if([self contactDownloadStatusWithCardID:cell.cardID]==WCTCompanyCardModelDownloadStatus_UnDone)
    {
        [self setBusy:@(YES)];
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        __block NSError *returnError = nil;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            self.companyContactGroupViewDelegateController.categoryList = [[WCTCompanyContactFetchDataController shareInstance] categoryListWithError:&returnError];
            
            [returnError retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                [blockself setBusy:@(NO)];
                
                //////////////////////////////////////////////////
                
                if([self.companyContactGroupViewDelegateController.categoryList count]>0)
                {
                    blockself.companyContactGroupViewDelegateController.userName = blockself.accountName;
                    [blockself.companyContactGroupViewDelegateController showGroupViewControllerWithUserInfo:@[cell.cardID] fromViewController:blockself];
                }
                else
                {
                    [WCTableViewController showToastError:returnError fromViewController:blockself];
                }
                
                //////////////////////////////////////////////////
                
                [returnError release];
            });
        });
    }
    else if([self contactDownloadStatusWithCardID:cell.cardID]==WCTCompanyCardModelDownloadStatus_Downloading)
    {
        //正在下載中
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:WCTCCV_MLS_ContactIsDownloading
                                                position:PPToastPositionCenter];
    }
    else
    {
        //已下載
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:WCTCCV_MLS_ContactAlreadyDownloaded
                                                position:PPToastPositionCenter];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCAccountSelectViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (NSArray *)viewAccountListForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController
{
    NSError *returnError = nil;
    
    NSArray *fetchViewAccountList = [WCTAccountSelectViewController fetchViewAccountListWithError:&returnError
                                                                                allCompanyContact:YES];
    
    // 發生錯誤可能要處理
    
    if(returnError!=nil)
    {
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [WCToastController showMessageToastFromSuperView:accountSelectViewController.view
                                                 withMessage:[blockself requestCompanyCustomNonEmptyMessageFromError:returnError]
                                                    position:PPToastPositionCenter];
        });
    }
    
    
    return fetchViewAccountList;
    
}


//================================================================================
//
//================================================================================
- (NSArray *)allAccountListForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController
{
    NSError *returnError = nil;
    
    NSArray *otherAccountList = [WCTAccountDataController allAccountListWithError:&returnError];
    
    // 發生錯誤可能要處理
    
    if(returnError!=nil)
    {
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [WCToastController showMessageToastFromSuperView:accountSelectViewController.view
                                                 withMessage:[blockself requestCompanyCustomNonEmptyMessageFromError:returnError]
                                                    position:PPToastPositionCenter];
        });
    }
    return otherAccountList;
}


//================================================================================
//
//================================================================================
- (NSArray *)selectedAccountGuidListForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController
{
    if (accountSelectViewController.style==WCTAccountSelectViewControllerStyle_ShareToColleague)
    {
        return nil;
    }
    else
    {
        if([self.curViewAccountGuid length]>0)
        {
            return @[self.curViewAccountGuid];
        }
        else
        {
            return nil;
        }
    }
}


//================================================================================
//
//================================================================================
//- (NSString *)ownerAccountGuidForAccountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController
//{
//    return nil;
//}


//================================================================================
//
//================================================================================
- (void)accountSelectViewController:(WCTAccountSelectViewController *)accountSelectViewController didSelectAccountArray:(NSArray *)selectAccountArray
{
    switch (self.interiorAction)
    {
        case WCTCompanyContactMultiSelectViewControllerInteriorAction_ChangeOwner:
        case WCTCompanyContactMultiSelectViewControllerInteriorAction_ShareToColleague:
        {
            __block typeof(self) blockself = self;
            
            [accountSelectViewController dismissAnimated:YES completion:^{
                
                do
                {
                    if(selectAccountArray.count<=0)
                    {
                        if(self.interiorAction==WCTCompanyContactMultiSelectViewControllerInteriorAction_ShareToColleague)
                        {
                            [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view
                                                                 withMessage:WCTCCV_MLS_NoAccountToShare
                                                                    position:PPToastPositionCenter];
                        }
                        else
                        {
                            [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view
                                                                 withMessage:WCTCCV_MLS_NoChangeOwnerAccount
                                                                    position:PPToastPositionCenter];
                        }
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    NSArray *selectContactIDs = [self.multiSelectViewController.multiSelectCardIDSet allObjects];
                    
                    if(selectContactIDs.count<=0)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    NSMutableArray *accountGuids = [NSMutableArray array];
                    
                    if(accountGuids==nil)
                    {
                        break;
                    }
                    
                    //////////////////////////////////////////////////
                    
                    for(WCTAccountRelationModel *model in selectAccountArray)
                    {
                        [accountGuids addObject:model.guid];
                    }
                    
                    //////////////////////////////////////////////////
                    
                    [blockself.multiSelectViewController setBusy:@(YES)];
                    
                    //////////////////////////////////////////////////
                    
                    if(self.interiorAction==WCTCompanyContactMultiSelectViewControllerInteriorAction_ChangeOwner)
                    {
                        // MARK: 選完同事帳號，設定擁有者
                        [[WCTCompanyContactFetchDataController shareInstance] setContactOwnerWithContactGuids:selectContactIDs
                                                                                                    ownerGuid:[accountGuids firstObject]
                                                                                              progressHandler:^(CGFloat progress) {
                                                                                                  [PPBusyView postMessage:[NSString stringWithFormat:@"%.2f%s",progress*100.0,"%"]];
                                                                                              }
                                                                                                     complete:^(NSArray <WCTRCGuidWithData *> *errorDataList, NSError *error){
                                                                                                         
                                                                                                         [blockself.multiSelectViewController setBusy:@(NO)];
                                                                                                         
                                                                                                         // MARK:改變聯絡人擁有者失敗
                                                                                                         if(errorDataList.count>0)
                                                                                                         {
                                                                                                             WCTRCGuidWithData *dataInfo = [errorDataList firstObject];
                                                                                                             
                                                                                                             NSError *failDeleteContactError = PPErrorMake([[dataInfo data] integerValue], @"Change Contact Owner Failed", nil);
                                                                                                             
                                                                                                             NSString *failReasonMessage = [blockself requestCompanyCustomMessageFromError:failDeleteContactError];
                                                                                                             
                                                                                                             if([failReasonMessage length]>0)
                                                                                                             {
                                                                                                                 [WCToastController showMessageToastFromSuperView:[UIViewController topMostViewController].view
                                                                                                                                                      withMessage:failReasonMessage
                                                                                                                                                         position:PPToastPositionCenter];
                                                                                                             }
                                                                                                             else
                                                                                                             {
                                                                                                                 [WCToastController showMessageToastFromSuperView:[UIViewController topMostViewController].view
                                                                                                                                                      withMessage:[blockself requestCompanyCustomNonEmptyMessageFromError:failDeleteContactError]
                                                                                                                                                         position:PPToastPositionCenter];
                                                                                                             }
                                                                                                             
                                                                                                         }
                                                                                                         
                                                                                                         //////////////////////////////////////////////////
                                                                                                         
                                                                                                         else if(error!=nil)
                                                                                                         {
                                                                                                             [WCTableViewController showToastError:error fromViewController:[UIViewController topMostViewController]];
                                                                                                         }
                                                                                                         else
                                                                                                         {
                                                                                                             blockself.contactInfoHasChanged = YES;
                                                                                                             
                                                                                                             //////////////////////////////////////////////////
                                                                                                             
                                                                                                             //清掉已知資料，更新名片清單顯示
                                                                                                             blockself.allCardSectionArray = nil;
                                                                                                             
                                                                                                             //////////////////////////////////////////////////
                                                                                                             
                                                                                                             [blockself.multiSelectViewController goBackAnimated:YES];
                                                                                                         }
                                                                                                         
                                                                                                     }];
                    }
                    else
                    {
                        // MARK: 選完同事帳號，開始進行聯絡人分享
                        [[WCTCompanyContactFetchDataController shareInstance] shareContactsWithContactGuids:selectContactIDs
                                                                                             toAccountGuids:accountGuids
                         
                                                                                              shareBehavior:WCTRC_Behavior_Add
                                                                                            progressHandler:^(CGFloat progress)
                         {
                             [PPBusyView postMessage:[NSString stringWithFormat:@"%.2f%s",progress*100.0,"%"]];
                         }
                                                                                                   complete:^(NSError *error)
                         {
                             [blockself.multiSelectViewController shareCompanyContactsToAccountGuidsWithError:error];
                         }];
                    }
                    
                    
                    
                }
                while (0);
                
                //////////////////////////////////////////////////
                
                self.interiorAction = WCTCompanyContactMultiSelectViewControllerInteriorAction_None;
                
            }];
            
            break;
        }
        case WCTCompanyContactMultiSelectViewControllerInteriorAction_VisibleAccount:
        {
            self.interiorAction = WCTCompanyContactMultiSelectViewControllerInteriorAction_None;
            
            //////////////////////////////////////////////////
            
            // MARK: 選完同事帳號，開始進行聯絡人清單刷新
            
            WCTAccountRelationModel *model = [selectAccountArray firstObject];
            
            if(model!=nil)
            {
                self.allCardSectionArray = nil;
                
                //////////////////////////////////////////////////
                
                self.curViewAccountName = model.name;
                self.curViewAccountGuid = model.guid;
                
                //////////////////////////////////////////////////
                
                [PPSettingsController setStringValue:self.curViewAccountGuid withKey:WCTCompanyContactViewControllerSettingKey_ViewAccountGuid];
            }
            
            //////////////////////////////////////////////////
            
            [accountSelectViewController dismissAnimated:YES completion:nil];
            
            break;
        }
        default:
        {
            
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTCompanyGroupSelectViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)accountListWithError:(NSError **)error
{
    return [[WCTCompanyContactFetchDataController shareInstance] accountTreeListWithError:error];
}


//==============================================================================
//
//==============================================================================
- (NSString *)preferredExpandToItemWithcompanyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
{
    return self.curSelectedAccountGuid;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)groupArrayWithAccountGuid:(NSString *)accountGuid error:(NSError **)error
{
    NSMutableArray *groupArray =  [[WCTCompanyContactFetchDataController shareInstance] groupArrayWithAccountGuid:accountGuid error:error];
    return groupArray;
}


//==============================================================================
//
//==============================================================================
- (NSDictionary <NSString*, NSNumber *> *)sharedContactNumberWithCategoryGuids:(NSArray <NSString *>*)categoryGuids ownerGuid:(NSString *)ownerGuid error:(NSError **)error
{
    return [[WCTCompanyContactFetchDataController shareInstance] sharedContactNumberWithCategoryGuids:categoryGuids ownerGuid:ownerGuid error:error];
}


//==============================================================================
//
//==============================================================================
- (void)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
                didSelectWithAccountGuid:(NSString *)accountGuid
                             accountName:(NSString *)accountName
                            categoryGuid:(NSString *)categoryGuid
                        categoryFullName:(NSString *)categoryFullName
{
    // MARK: 選取完要檢視的帳號與群組
    // 帳號:@""，群組:@""，表示要取全部分享給我的
    // 帳號:有值，群組:@""，表示要取某個帳號分享給我的名片
    // 帳號:有值，群組:有值，表示要取某個帳號下的群組中分享給我的名片
    // 帳號:有值，群組:@"MLS_Undownload"，表示要取某個帳號未下載名片中分享給我的名片
    
    // 帳號:@""，群組:有值，應該不存在這個狀態，要清掉群組
    
    self.allCardSectionArray = nil;
    
    //////////////////////////////////////////////////
    
    self.curViewAccountName = accountName;
    self.curViewAccountGuid = accountGuid;
    self.curSelectedAccountGuid = accountGuid;
    self.curViewCategoryGuid = categoryGuid;
    //////////////////////////////////////////////////
    
    [PPSettingsController setStringValue:self.curViewAccountGuid withKey:WCTCompanyContactViewControllerSettingKey_ViewAccountGuid];
    [PPSettingsController setStringValue:self.curViewCategoryGuid withKey:WCTCompanyContactViewControllerSettingKey_ViewCategryGuid];
    
    // Next:clearAndFetchTableViewData
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCMultiSelectViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (UIImage *)wcMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController cachedThumbnailImageWithCardID:(NSString *)cardID
{
    return nil;
}


//================================================================================
//
//================================================================================
- (UIImage *)wcMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController thumbnailImageWithCardID:(NSString *)cardID
{
    return nil;
}


//================================================================================
//
//================================================================================
- (void)wcMultiSelectViewControllerShowGuideIfNeeded:(WCMultiSelectViewController *)wcMultiSelectViewController;
{
    
}


//================================================================================
//
//================================================================================
- (void)wcMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController
     selectedContactChangeWithCount:(NSUInteger)selectedContactCount
{
    self.selectedContactCount = selectedContactCount;
    
    [wcMultiSelectViewController setNavigationBarTitleString:[NSString stringWithFormat:WCTCCV_MLS_MultiSelectCount ,selectedContactCount]];
}


//================================================================================
//
//================================================================================
- (NSArray *)bottomToolBarButtonArrayInWCMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController
{
    NSArray *views = nil;
    
    [self prepareBottomButton];
    
    //////////////////////////////////////////////////
    
    if(self.downloadButton!=nil &&
       self.shareToColleagueButton!=nil &&
       self.changeOwnerButton!=nil&&
       self.deleteButton!=nil)
    {
        if([self.accountRole compare:WCTRC_Role_Admin]!=NSOrderedSame)
        {
            views = @[self.downloadButton,self.shareToColleagueButton,self.deleteButton];
        }
        else
        {
            views = @[self.downloadButton,self.shareToColleagueButton,self.changeOwnerButton,self.deleteButton];
        }
    }
    
    return views;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTCompanyContactMultiSelectViewController Method

//================================================================================
//
//================================================================================
- (void)multiSelectViewControllerWillShowUpPullView
{
    self.downloadButton.enabled = NO;
    self.shareToColleagueButton.enabled = NO;
    self.deleteButton.enabled = NO;
    self.changeOwnerButton.enabled = NO;
}


//================================================================================
//
//================================================================================
- (void)multiSelectViewControllerWillShowHidePullView
{
    self.downloadButton.enabled = YES;
    self.shareToColleagueButton.enabled = YES;
    self.deleteButton.enabled = YES;
    self.changeOwnerButton.enabled = YES;
}


//================================================================================
//
//================================================================================
- (NSString *)companyContactMultiSelectViewController:(WCTCompanyContactMultiSelectViewController *)companyContactMultiSelectViewController requestMessageFromError:(NSError *)error
{
    return [self requestCompanyCustomMessageFromError:error];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTCompanyContactSearchViewControllerDelegate Method

//================================================================================
//
//================================================================================
- (NSString *)companyContactSearchViewController:(WCTCompanyContactSearchViewController *)companyContactSearchViewController requestMessageFromError:(NSError *)error
{
    return [self requestCompanyCustomMessageFromError:error];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCTableViewControllerProtocol Method

//================================================================================
//
//================================================================================
- (void)longPressWithCell:(WCCardHolderCell *)cell
{
    do
    {
        //唯讀帳號，不是檢視自已帳號下的聯絡人，不允許多選操作
        if([self.accountRole compare:WCTRC_Role_ReadOnlyUser options:NSCaseInsensitiveSearch]==NSOrderedSame &&
           [self.curViewAccountGuid compare:[PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID] options:NSCaseInsensitiveSearch]!=NSOrderedSame)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        // MARK: 長按，檢查帳號權限，然後進多選頁面
        if([[cell cardID] length]>0)
        {
            [self showMultiSelectControllerFromViewController:self selectedCardIDs:@[cell.cardID]];
        }
        else
        {
            [self showMultiSelectControllerFromViewController:self selectedCardIDs:nil];
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCSearchViewController Delegate Method


//================================================================================
//
//================================================================================
- (UIImage *)searchViewController:(WCSearchViewController *)searchViewController cachedThumbnailImageWithCardID:(NSString *)cardID
{
    return nil;
}


//================================================================================
//
//================================================================================
- (UIImage *)searchViewController:(WCSearchViewController *)searchViewController thumbnailImageWithCardID:(NSString *)cardID
{
    return nil;
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)copyCardsWithSearchText:(NSString *)searchText
{
    return nil;
}

//================================================================================
//
//================================================================================
- (void)didClickMultiSelectWithSearchViewController:(WCSearchViewController *)searchViewController
{
    // MARK: 搜尋下點選多選按鈕
    [self showMultiSelectControllerFromViewController:searchViewController selectedCardIDs:nil];
}


//================================================================================
//
//================================================================================
- (void)searchViewController:(WCSearchViewController *)searchViewController didSelectCardID:(NSString *)cardID
{
    // MARK: 搜尋下，點擊聯絡人
    do
    {
        if([cardID length]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(searchViewController.waitShowingForContactInfo==YES)
        {
            break;
        }
        
        searchViewController.waitShowingForContactInfo = YES;
        
        //////////////////////////////////////////////////
        
        [searchViewController setBusy:@(YES)];
        
        [[WCTCompanyContactFetchDataController shareInstance] detailContactWithContactGuid:cardID];
        
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (NSString *)groupNameForSearchViewController:(WCSearchViewController *)searchViewController
{
    return nil;
}


//================================================================================
//
//================================================================================
- (void)searchViewController:(WCSearchViewController *)searchViewController didEndSearchWithKeyword:(NSString *)keyword
{
    do
    {
        // !! 搜尋文字時，把進階搜尋的資料清除
        self.currentSearchModel = nil;
        self.searchViewController.currentAdvancedSearchModel = nil;
        
        keyword = [keyword stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
        
        //空白字串，即清空所有資料
        if([keyword length]<=0)
        {
            searchViewController.allCardSectionArray = nil;
            
            [searchViewController.tableView reloadData];
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        [searchViewController setBusy:@(YES)];
        
        //////////////////////////////////////////////////
        
        self.searchViewController.searchText = keyword;
        
        //////////////////////////////////////////////////
        
        [self.refreshController hideInfoView];
        
        //////////////////////////////////////////////////
        
        //每次搜尋都要清掉原本資料
        self.searchViewController.allCardSectionArray = nil;
        
        //////////////////////////////////////////////////
        
        [[WCTCompanyContactFetchDataController shareInstance] contactListSearchWithKeywordSortedWithKeyword:keyword
                                                                                                       page:0
                                                                                                   pageSize:WCTClientControllerNumberPerPage
                                                                                 contactsimpleinfoSortField:WCTRC_ContactSortField_CreatedTime
                                                                                              sortDirection:WCTRC_ContactSortDirection_Descending];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (BOOL)reloadTableViewDataWhenViewWillAppear
{
    return NO;
}


#pragma mark - WCT only


//==============================================================================
//
//==============================================================================
- (void)didClickAdvanceSearchWithSearchViewController:(WCSearchViewController *)searchViewController
{
    // MARK: 顯示進顯搜尋
    WCTAdvancedSearchViewController *advancedSearchViewController = [[WCTAdvancedSearchViewController alloc] init];
    if (advancedSearchViewController)
    {
        advancedSearchViewController.delegate = self;
        advancedSearchViewController.delegateForWCT = self;
        advancedSearchViewController.isContainCategory = NO;
        
        if (self.currentSearchModel!=nil)
        {
            [advancedSearchViewController loadAdvancedSearchModel:self.currentSearchModel];
        }
        
        [searchViewController.navigationController pushViewController:advancedSearchViewController animated:YES];
        [advancedSearchViewController release];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAdvancedSearchViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSMutableArray<WCCustomFieldInfo *> *)requestCustomFieldInfoArrayInAdvancedSearchViewController:(WCTAdvancedSearchViewController *)advancedSearchViewController
{
    NSError *error = nil;
    NSArray *customfieldArray = [[WCTCompanyContactFetchDataController shareInstance] contactCustomFieldsWithError:&error];
    return [NSMutableArray arrayWithArray:customfieldArray];
}


//==============================================================================
// 要求外部提供目前的帳號清單
//==============================================================================
- (NSMutableArray<WCTAccountRelationModel *> *)requestAccountListInAdvancedSearchViewController:(WCTAdvancedSearchViewController *)advancedSearchViewController
{
    NSError *returnError = nil;
    NSArray *accountList = [WCTAccountDataController allAccountListWithError:&returnError];
    
    if(returnError!=nil)
    {
        // 取得帳號列表， returnError 處理
    }
    
    NSMutableArray *resultArray = [NSMutableArray arrayWithArray:accountList];
    
    [resultArray sortUsingComparator:^NSComparisonResult(WCTAccountRelationModel *obj1, WCTAccountRelationModel *obj2) {
        
        return [obj1.name compare:obj2.name options:NSCaseInsensitiveSearch|NSDiacriticInsensitiveSearch|NSNumericSearch|NSForcedOrderingSearch];
    }];
    return resultArray;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAdvancedSearchViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSMutableArray<WCGroupModel *> *)requestGroupListInAdvancedSearchViewController:(WCAdvancedSearchViewController *)advancedSearchViewController
{
    // !! 共享聯絡人不用搜尋類別
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSString *)advancedSearchViewController:(WCAdvancedSearchViewController *)advancedSearchViewController groupPathSelectedWithGroupIDArray:(NSArray *)groupIDArray;
{
    // !! 共享聯絡人不用搜尋類別
    return nil;
}


//==============================================================================
//點選搜尋按鈕
//==============================================================================
- (void)advancedSearchViewController:(WCAdvancedSearchViewController *)advancedSearchViewController endWithAdvancedSearchModel:(WCAdvancedSearchModel* )advancedSearchModel;
{
    // 清空一般搜尋
    self.searchViewController.searchText = nil;
    self.searchViewController.allCardSectionArray = nil;
    
    // 紀錄目前設定的結果
    self.currentSearchModel = (WCTAdvancedSearchModel *)advancedSearchModel;
    
    // MARK: 使用目前設定去搜尋
    // 共享聯絡人是透過WCTCompanyContactFetchDataController中的API再delegate出來，所以這邊直接call
    if (self.currentSearchModel!=nil)
    {
        self.searchViewController.currentAdvancedSearchModel = self.currentSearchModel;
        // 進階搜尋
        WCTAdvancedSearchModel *searchModel = self.currentSearchModel;
        WCTRCAdvancedSearchInfo *searchInfo = [searchModel advancedSearchInfo];
        [[WCTCompanyContactFetchDataController shareInstance] fetchCardSectionModelWithAdvancedSearchInfo:searchInfo
                                                                                                pageIndex:[self.searchViewController.cardIDArray count]/WCTClientControllerNumberPerPage];
        
    }
    [advancedSearchViewController goBackAnimated:YES];
    
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate

//
////==============================================================================
////
////==============================================================================
//- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
//{
//    [self.searchViewController goBackAnimated:YES];
//}
//

@end
