//
//  WCTGroupAccessFlowDelegateController.m
//  WorldCardTeam
//
//  Created by sanhue on 2018/3/23.
//  Copyright © 2018年 penpower. All rights reserved.
//

#import "WCTCompanyGroupAccessFlowDelegateController.h"

// define
#import "WCTSettingsKey.h"
#import "WCTCompanyContactViewController+ResourceDefine.h"

//category
#import "WCGroupModel+Tree.h"
#import "WCGroupModel+Sort.h"
#import "WCGroupModel+WCTRCCategoryInfoMultiLayer.h"

//model
#import "WCTAccountRelationModel.h"

// controller
#import "PPSettingsController.h"
#import "WCTAccountDataController.h"
#import "WCTRestClientController.h"
#import "WCTDataController.h"
#import "PPSystemInfoController.h"
#import "WCTRestClientController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTCompanyGroupAccessFlowDelegateController()
@property (nonatomic, retain) WCTDataController *dataController;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTCompanyGroupAccessFlowDelegateController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.dataController = [[[WCTDataController alloc] initWithAccessMode:WCDC_AM_All] autorelease];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.dataController = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)sourceGroupArray
{
    // 一開始先顯示account
    // 取得可檢視帳號列表
    NSError *returnError = nil;
    NSMutableArray *viewAccounts = [NSMutableArray array];
    WCTRCSharedAccountsResponseResult *viewResult = [[WCTRestClientController shareRestClientController] shareAccountsWithError:&returnError];
    if (viewResult!=nil && returnError==nil)
    {
        NSUInteger allCompanyContactCount = 0;
        
        for (NSInteger index=0; index<viewResult.data.count; index++)
        {
            @autoreleasepool
            {
                WCTRCContactSharedAccountsInfo *accountInfo = [viewResult.data objectAtIndex:index];
                
                // 用groupModel來放account
                WCGroupModel *accountModel = [[WCGroupModel alloc] init];
                accountModel.name = accountInfo.accountName;
                accountModel.cardCount = accountInfo.sharedContactCount;
                accountModel.guid = accountInfo.accountGuid;
                accountModel.editable = NO;
                
                allCompanyContactCount+=accountInfo.sharedContactCount;
                [viewAccounts addObject:accountModel];
                [accountModel release];
            }
        }
        
        
        [viewAccounts sortUsingComparator:^NSComparisonResult(WCGroupModel *obj1, WCGroupModel *obj2) {
            
            return [obj1.name compare:obj2.name options:NSCaseInsensitiveSearch|NSDiacriticInsensitiveSearch|NSNumericSearch|NSForcedOrderingSearch];
        }];
        
        WCGroupModel *rootModel = [[[WCGroupModel alloc] init] autorelease];
        rootModel.name = WCTCCV_MLS_AllCompanySharedContacts;
        rootModel.cardCount = allCompanyContactCount;
        rootModel.guid = WCTCCV_MLS_AllCompanySharedContacts;
        rootModel.editable = NO;
        [rootModel.subGroups addObjectsFromArray:viewAccounts];
        
        return [NSMutableArray arrayWithObject:rootModel];
        
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)pinnedGroupArray
{
    NSMutableArray *allGroupModels = [self.dataController pinnedGroupsAndGetCardCount:YES];
    return allGroupModels;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCGroupAccessFlowControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)sourceGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController error:(NSError **)error
{
    return [self sourceGroupArray];
}


//==============================================================================
//
//==============================================================================
- (BOOL)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController requestIsExistGroupNamed:(NSString*)groupNamed
{
    // WCT改online所以永遠算不存在
    return NO;
}


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController requestGroupModelByNewGroupName:(NSString *)groupName superGroupGuid:(NSString *)superGroupGuid
{
    NSError *error = nil;
    WCTRCMLCategoryCreationRequest *createRequest = [[WCTRCMLCategoryCreationRequest alloc] init];
    createRequest.name = groupName;
    createRequest.parentCategoryGuid = superGroupGuid;
    createRequest.ownerAccountGuid = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
    WCTRCMLCategoryCreationResponseResult *result = [[WCTRestClientController shareRestClientController] createMultiLayerCategoryWithCreationRequest:createRequest error:&error];
    [createRequest release];
    
    if (error==nil)
    {
        [WCTAccountDataController updateCategoriesFromServerWithCompleteHandler:nil];
        
        // 因為架構關系，這邊要回傳一個空的groupModel，代表新增成功
        
        WCGroupModel *groupModel = [self.dataController groupWithGuid:result.data];
        return groupModel;
    }
    else
    {
        return nil;
    }
}


//==============================================================================
//
//==============================================================================
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController updateGroupModel:(WCGroupModel *)groupModel
{
    NSError *error = nil;
    [[WCTRestClientController shareRestClientController] updateMultiLayerCategoryWithGuid:groupModel.guid categoryName:groupModel.name error:&error];
    [WCTAccountDataController updateCategoriesFromServerWithCompleteHandler:nil];
    
    return error;
}


//==============================================================================
//
//==============================================================================
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController deleteGroupModel:(WCGroupModel *)groupModel
{
    NSError *error = nil;
    [[WCTRestClientController shareRestClientController] deleteMultiLayerCategoryWithCategoryGuid:groupModel.guid error:&error];
    [WCTAccountDataController updateCategoriesFromServerWithCompleteHandler:nil];
    
    return error;
}


//==============================================================================
//
//==============================================================================
- (void)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController didEditFinishWithGroupArray:(NSArray *)groupModelArray
{
    // 修改group順序
    NSMutableArray *groupIDArray = [NSMutableArray array];
    for (WCGroupModel *groupModel in groupModelArray)
    {
        // 要看原本的groupID是否還存在
        NSString *groupName = [self.dataController groupNameWithID:[NSString stringWithInteger:groupModel.ID]];
        if ([groupName length]>0)
        {
            [groupIDArray addObject:@(groupModel.ID)];
        }
    }
    
    if ([groupIDArray count]>0)
    {
        [self.dataController updateOrderWithGroupIDArray:groupIDArray];
    }
}



//==============================================================================
//
//==============================================================================
- (NSMutableArray *)pinnedSourceGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController error:(NSError **)error
{
    return [self pinnedGroupArray];
}



//==============================================================================
//
//==============================================================================
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController requestGroupModels:(NSArray <WCGroupModel *>*)groupModels pinned:(BOOL)pinned;
{
//    NSLog(@"%s, %@", __PRETTY_FUNCTION__, groupModels);
    // Pinned selectedGroups
    NSMutableArray *toggleList = [NSMutableArray array];
    for (WCGroupModel *groupModel in groupModels)
    {
        [toggleList addObject:groupModel.guid];
    }
    
    if ([toggleList count]==0)
    {
        // 這邊正常至少會有一個item
        return nil;
    }
    
    NSError *error = nil;
    WCTRCCategoryToggleUsualVo *toggleRequest = [[WCTRCCategoryToggleUsualVo alloc] init];
    toggleRequest.setAsToggled = pinned;
    toggleRequest.list = toggleList;
    [[WCTRestClientController shareRestClientController] setToggledMultiLayerWithCategoryToggleUsualVo:toggleRequest error:&error];
    [toggleRequest release];
    [WCTAccountDataController updateCategoriesFromServerWithCompleteHandler:nil];
    
    return error;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - move group


//==============================================================================
//
//==============================================================================
- (NSArray *)validParentsForMoveGroupModel:(WCGroupModel *)groupModel withGroupAccessFlowController:(WCGroupAccessFlowController*)groupAccessFlowController error:(NSError **)error
{
    NSError *returnError = nil;
    NSString  *currentAccountID = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
    WCTRCMLCategoryInfoListResponseResult *result = [[WCTRestClientController shareRestClientController] movableMultiLayerCategoryListWithAccountGuid:currentAccountID
                                                                                                                                    movedCategoryGuid:groupModel.guid
                                                                                                                                                error:&returnError];
    if (returnError)
    {
        if (error!=NULL)
        {
            *error = returnError;
        }
        return nil;
    }
    
    WCGroupModel *rootModel = [WCGroupModel groupTreeWithCategoryList:result.data customGroupEditable:NO];
    [WCGroupModel sortTreeWithRootGroups:@[rootModel]];
    if (rootModel)
    {
        return @[rootModel];
    }
    
    return nil;
    
}


@end
