//
//  WCTCompanyContactSearchViewController.m
//
//
//  Created by Howard on 2016/4/15.
//
//

#import "WCTCompanyContactSearchViewController.h"

// Define
#import "WCTableViewController+ShowError.h"
#import "WCTCompanyContactViewController+ResourceDefine.h"
#import "WCTRestClientController+ParameterDefine.h"
#import "WCTCompanyContactViewController+ParameterDefine.h"

// Model
#import "WCTCompanyCardModel.h"

// Controller
#import "PPRefreshController.h"
#import "WCToastController.h"
#import "WCTCompanyContactGroupViewDelegateController.h"
#import "WCTCompanyContactFetchDataController.h"

// Category
#import "WCTableViewController+CompanyCardModel.h"
#import "WCTableViewController+CompanyContactFetchDataDelegate.h"
#import "UIViewController+ShareApplication.h"
#import "NSObject+PPBusyView.h"
#import "WCTAdvancedSearchModel+WCTRCAdvancedSearchInfo.h"

@interface WCTCompanyContactSearchViewController() <PPRefreshControllerDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) WCTCompanyContactGroupViewDelegateController *companyContactGroupViewDelegateController;
@property (nonatomic,retain) PPRefreshController *refreshController;
@end


@implementation WCTCompanyContactSearchViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithMode:(PPSIC_Mode)mode
{
    if(self=[super initWithMode:mode])
    {
        _companyContactGroupViewDelegateController = [[WCTCompanyContactGroupViewDelegateController alloc] init];
        
        //////////////////////////////////////////////////

        self.accountDictionary = [NSMutableDictionary dictionary];
        
        //////////////////////////////////////////////////
        
        // 建立refreshController
        self.refreshController = [PPRefreshController refreshControllerWithDelegate:self];
        
        if(self.refreshController!=nil)
        {
            self.refreshController.enabled = YES;
            self.refreshController.backgroundColor = WCTCompanyContactViewAppearance_BackgroundColor;
            // 設定indicator顏色
            [[PPActivityIndicatorView appearance] setLineColor:WCTCompanyContactViewAppearance_IndicatorColor];
            
            self.refreshController.infoPosition = PPRefreshControllerInfoPosition_Bottom;
        }
   
        //////////////////////////////////////////////////
        
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(receiveCompanyContactListHasChangedNotification:)
                                                     name:WCTCompanyContactListHasChangedNotificationName
                                                   object:nil];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    
    //////////////////////////////////////////////////

    self.companyContactSearchViewControllerDelegate = nil;
    
    //////////////////////////////////////////////////

    [_companyContactGroupViewDelegateController release];
    _companyContactGroupViewDelegateController = nil;
    
    [_searchText release];
    _searchText = nil;
    
    [_accountRole release];
    _accountRole = nil;
    
    self.accountDictionary = nil;
    self.companyContactAccessFlowDelegateController = nil;
    
    //////////////////////////////////////////////////
    
    self.refreshController = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View's Event

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [WCTCompanyContactFetchDataController shareInstance].delegate = self;
    
    //////////////////////////////////////////////////

    if([self respondsToSelector:@selector(ppButtonMultiSelect)]==YES)
    {
        UIButton *multiSelectButton = [self performSelector:@selector(ppButtonMultiSelect)];
        
        multiSelectButton.hidden = [self.accountRole isEqualToString:WCTRC_Role_ReadOnlyUser];
    }
    
    //////////////////////////////////////////////////

    if([self respondsToSelector:@selector(searchBar)]==YES)
    {
        UISearchBar *searchBar = [self performSelector:@selector(searchBar)];
        
        searchBar.placeholder = WCTCCV_MLS_SearchContactsInAllCompany;
        searchBar.text = self.searchText;
    }
    
}


//================================================================================
//
//================================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////

    self.refreshController.targetScrollView = self.tableView;
}


//================================================================================
//
//================================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [self.refreshController hideInfoView];
    
    //////////////////////////////////////////////////

    [super viewWillDisappear:animated];

    //////////////////////////////////////////////////
    
    [WCTCompanyContactFetchDataController shareInstance].delegate = nil;
    
    //////////////////////////////////////////////////
    
    self.waitShowingForContactInfo = NO;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)searchBar:(UISearchBar *)searchBar textDidChange:(NSString *)searchText
{
    // do nothing, 因為公司連絡人需連網不能一直即時搜尋
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    WCCardHolderCell *cardHolderCell = (WCCardHolderCell *)[super tableView:tableView cellForRowAtIndexPath:indexPath];
    
    if(cardHolderCell!=nil)
    {
        if([self.accountRole compare:WCTRC_Role_ReadOnlyUser]==NSOrderedSame)
        {
            cardHolderCell.additionButton.hidden = YES;
        }
        else
        {
            cardHolderCell.additionButton.hidden = NO;
            
            //////////////////////////////////////////////////

            if([self contactDownloadStatusWithCardID:cardHolderCell.cardID]==WCTCompanyCardModelDownloadStatus_Done)
            {
                [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonDownloaded];
            }
            else if([self contactDownloadStatusWithCardID:cardHolderCell.cardID]==WCTCompanyCardModelDownloadStatus_Downloading)
            {
                [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonNeedDownload];
            }
            else
            {
                [cardHolderCell.additionButton setImageWithName:ImageNameCompanyContactViewControllerButtonNeedDownload];
            }
        }
      
    }
    
    return cardHolderCell;
}


//================================================================================
//
//================================================================================
- (PPRefreshController *)companyRefreseController;
{
    return self.refreshController;
}


//==============================================================================
//
//==============================================================================
- (void)searchWithOptionModels:(NSArray *)optionModels
{
    self.currentAdvancedSearchModel = [optionModels firstObject];
    [super searchWithOptionModels:optionModels];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override WCTableViewController Method

//================================================================================
//
//================================================================================
- (NSString *)companyContactCustomMessageFromError:(NSError *)error
{
    NSString *message = nil;
    
    if([self.companyContactSearchViewControllerDelegate respondsToSelector:@selector(companyContactSearchViewController:requestMessageFromError:)]==YES)
    {
        message = [self.companyContactSearchViewControllerDelegate companyContactSearchViewController:self requestMessageFromError:error];
    }
    
    return message;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Notification Method

//================================================================================
//
//================================================================================
- (void)receiveCompanyContactListHasChangedNotification:(NSNotification *)notificaiton
{
    NSDictionary *dictionary = notificaiton.userInfo;
    
    if(dictionary.count>0)
    {
        self.allCardSectionArray = [dictionary objectForKey:[[dictionary allKeys] firstObject]];
    }
    
    //////////////////////////////////////////////////

    // 下載中狀態，改成已下載
    for (WCCardSectionModel *sectionModel in self.allCardSectionArray)
    {
        for (WCTCompanyCardModel *cardModel in sectionModel.cardArray)
        {
            if(cardModel.downloadStatus==WCTCompanyCardModelDownloadStatus_Downloading)
            {
                cardModel.downloadStatus = WCTCompanyCardModelDownloadStatus_Done;
            }
        }
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPRefreshControllerDelegate method

//================================================================================
//
//================================================================================
- (void)refreshControllerInfoViewWillAppear:(PPRefreshController *)refreshController
{
    if (self.currentAdvancedSearchModel)
    {
        // 進階搜尋
        WCTAdvancedSearchModel *searchModel = self.currentAdvancedSearchModel;
        WCTRCAdvancedSearchInfo *searchInfo = [searchModel advancedSearchInfo];
        [[WCTCompanyContactFetchDataController shareInstance] fetchCardSectionModelWithAdvancedSearchInfo:searchInfo
                                                                                                pageIndex:[self.cardIDArray count]/WCTClientControllerNumberPerPage];

    }
    else
    {
        [[WCTCompanyContactFetchDataController shareInstance] contactListSearchWithKeywordSortedWithKeyword:self.searchText
                                                                                                       page:self.cardIDArray.count/WCTClientControllerNumberPerPage
                                                                                                   pageSize:WCTClientControllerNumberPerPage
                                                                                 contactsimpleinfoSortField:WCTRC_ContactSortField_CreatedTime
                                                                                              sortDirection:WCTRC_ContactSortDirection_Descending];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCCardHolderCellDelegate Method

//================================================================================
// MARK: 和伺服器要求此筆資料註記下載
//================================================================================
- (void)didClickAdditionButtonWithCell:(WCCardHolderCell *)cell
{
    // MARK: 單筆下載
    if([self contactDownloadStatusWithCardID:cell.cardID]==WCTCompanyCardModelDownloadStatus_UnDone)
    {
        [self setBusy:@(YES)];
        
        //////////////////////////////////////////////////
        
        __block NSError *returnError = nil;
        
        __block typeof(self) blockself = self;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            NSMutableArray *categoryList = [[[WCTCompanyContactFetchDataController shareInstance] categoryListWithError:&returnError] retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                [blockself setBusy:@(NO)];
                
                //////////////////////////////////////////////////
                
                if([categoryList count]>0)
                {
                    blockself.companyContactGroupViewDelegateController.categoryList = categoryList;
                    blockself.companyContactGroupViewDelegateController.userName = blockself.userName;
                    [blockself.companyContactGroupViewDelegateController showGroupViewControllerWithUserInfo:@[cell.cardID] fromViewController:self];
                }
                else
                {
                    [WCTableViewController showToastError:returnError fromViewController:blockself];
                }
                
                [categoryList release];
            });
        });
    }
    else if([self contactDownloadStatusWithCardID:cell.cardID]==WCTCompanyCardModelDownloadStatus_Downloading)
    {
        //正在下載中
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:WCTCCV_MLS_ContactIsDownloading
                                                position:PPToastPositionCenter];
    }
    else
    {
        //已下載
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:WCTCCV_MLS_ContactAlreadyDownloaded
                                                position:PPToastPositionCenter];
    }
}


@end
