//
//  WCTCompanyContactGroupViewDelegateController.m
//  
//
//  Created by Howard on 2016/5/27.
//
//

#import "WCTCompanyContactGroupViewDelegateController.h"

// Define
#import "WCGroupDefine.h"
#import "WCTCompanyContactViewController+ResourceDefine.h"
#import "WCTCompanyContactViewController+ParameterDefine.h"
#import "WCTFieldLengthDefine.h"

// Controller
#import "PPAlertController.h"
#import "PPNavigationController.h"
#import "WCGroupAccessFlowController.h"
#import "WCTableViewController.h"
#import "WCTCompanyContactFetchDataController.h"
#import "WCToastController.h"
#import "WCTMatomoController.h"

// Category
#import "NSObject+PPBusyView.h"
#import "UIViewController+ShareApplication.h"
#import "WCTableViewController+CompanyCardModel.h"
#import "WCTableViewController+CompanyContactFetchDataDelegate.h"
#import "WCTableViewController+ShowError.h"

@interface WCTCompanyContactGroupViewDelegateController ()<WCGroupAccessFlowControllerDelegate>

@property (nonatomic,retain) WCTableViewController *superViewController;
@property (nonatomic,retain) NSArray *selectedGroupArray;
@end


@implementation WCTCompanyContactGroupViewDelegateController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_superViewController release];
    _superViewController = nil;
    
    [_categoryList release];
    _categoryList = nil;
    
    [_selectedGroupArray release];
    _selectedGroupArray = nil;
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)updateTableViewCellDownloadIconWithCardIds:(NSArray *)cardIDs
{
    do
    {
        @autoreleasepool
        {
            if([cardIDs count]<=0)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSMutableArray *indexPaths = [NSMutableArray array];
            
            if(indexPaths==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            for(NSString *cardID in cardIDs)
            {
                //標注正進行下載
                WCTCompanyCardModel *cardModel = [self.superViewController companyCardModelWithCardID:cardID];
                
                if(cardModel!=nil)
                {
                    cardModel.downloadStatus = WCTCompanyCardModelDownloadStatus_Downloading;
                }
            }

            [self.superViewController.tableView reloadData];
        }
    }
    while (0);
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCGroupAccessFlowControllerDelegate Method

//================================================================================
// MARK: 所有的群組清單
//================================================================================
- (NSMutableArray *)sourceGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController error:(NSError **)error
{
    return self.categoryList;
}


//================================================================================
// MARK:已選擇的群組清單
//================================================================================
- (NSArray *)selectedGroupArrayForGroupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController error:(NSError **)error
{
    return nil;
}


//================================================================================
// MARK:點下完成時，通知選擇了哪些群組(WCGroupModel的Array, 未分類直接回傳nil)
//================================================================================
- (void)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController groupsDidSelected:(NSArray *)groupArray
{
    self.selectedGroupArray = groupArray;
}


//==============================================================================
//
//==============================================================================
- (NSError *)groupAccessFlowController:(WCGroupAccessFlowController *)groupAccessFlowController didFinishViewController:(UIViewController *)viewController
{
    do
    {
        if([self.selectedGroupArray count]<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        id userInfo = [groupAccessFlowController userInfo];
        
        if([userInfo isKindOfClass:[NSArray class]]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSArray *cardIDs = [userInfo retain];
        
        __block typeof(self) blockself = self;
        
        [(PPViewController *)viewController dismissAnimated:YES completion:^{
        
            NSString *topMostViewControllerString = NSStringFromClass([[UIViewController topMostViewController] class]);
            
            // 選擇連絡人清單視圖下
            if([topMostViewControllerString compare:@"WCTCompanyContactMultiSelectViewController"]==NSOrderedSame)
            {
                [[UIViewController topMostViewController] setBusy:@(YES)];
            }
            
            //////////////////////////////////////////////////
            
            if([userInfo isKindOfClass:[NSArray class]]==YES)
            {
                [self updateTableViewCellDownloadIconWithCardIds:cardIDs];
            }
            
            //////////////////////////////////////////////////
            
            NSMutableArray *groupIDs = nil;
            
            for(WCGroupModel *groupModel in self.selectedGroupArray)
            {
                if(groupModel.ID==WC_GID_Unfiled)
                {
                    continue;
                }
                
                //////////////////////////////////////////////////
                
                if(groupIDs==nil)
                {
                    groupIDs = [NSMutableArray array];
                }
                
                //////////////////////////////////////////////////
                
                [groupIDs addObject:groupModel.guid];
            }
            
            //////////////////////////////////////////////////
            
            [[WCTCompanyContactFetchDataController shareInstance] contactCategoryOperationWithContactGuids:cardIDs
                                                                                              catgoryGuids:groupIDs
                                                                                           progressHandler:^(CGFloat progress) {
                                                                                               [PPBusyView postMessage:[NSString stringWithFormat:@"%.2f%s",progress*100.0,"%"]];
                                                                                           } complete:^(NSArray <WCTRCGuidWithData *> *errorDataList, NSError *error){
                                                                                               
                                                                                               // 選擇連絡人清單視圖下
                                                                                               if([topMostViewControllerString compare:@"WCTCompanyContactMultiSelectViewController"]==NSOrderedSame)
                                                                                               {
                                                                                                   [[UIViewController topMostViewController] setBusy:@(NO)];
                                                                                               }
                                                                                               
                                                                                               //////////////////////////////////////////////////
                                                                                               
                                                                                               if(error!=nil)
                                                                                               {
                                                                                                   //更新列表狀態
                                                                                                   for(NSString *cardID in cardIDs)
                                                                                                   {
                                                                                                       WCTCompanyCardModel *model = [blockself.superViewController companyCardModelWithCardID:cardID];
                                                                                                       
                                                                                                       if(model!=nil)
                                                                                                       {
                                                                                                           model.downloadStatus = WCTCompanyCardModelDownloadStatus_UnDone;
                                                                                                       }
                                                                                                   }
                                                                                                   
                                                                                                   
                                                                                                   //////////////////////////////////////////////////
                                                                                                   
                                                                                                   [WCTableViewController showToastError:error
                                                                                                                      fromViewController:[UIViewController topMostViewController]];
                                                                                                   
                                                                                               }
                                                                                               else if(errorDataList.count>0)
                                                                                               {
                                                                                                   // MARK: !! matomo log (從共享聯絡人下載，部分失敗)
                                                                                                   // 部份有錯也要記錄
                                                                                                   if (error==nil)
                                                                                                   {
                                                                                                       [WCTMatomoController sendLogWithDownloadSource:WCTMatomoController_DownloadSource_SharedList];
                                                                                                   }

                                                                                                   //更新列表狀態
                                                                                                   for(WCTRCGuidWithData *dataInfo in errorDataList)
                                                                                                   {
                                                                                                       WCTCompanyCardModel *model = [blockself.superViewController companyCardModelWithCardID:dataInfo.guid];
                                                                                                       
                                                                                                       if(model!=nil)
                                                                                                       {
                                                                                                           model.downloadStatus = WCTCompanyCardModelDownloadStatus_UnDone;
                                                                                                       }
                                                                                                   }
                                                                                                   
                                                                                                   //////////////////////////////////////////////////
                                                                                                   
                                                                                                   WCTRCGuidWithData *dataInfo = [errorDataList firstObject];
                                                                                                   
                                                                                                   NSError *failDownloadContactError = PPErrorMake([[dataInfo data] integerValue], @"Download Contact Failed", nil);
                                                                                                   
                                                                                                   
                                                                                                   NSString *failReasonMessage = nil;
                                                                                                   
                                                                                                   if([blockself.superViewController respondsToSelector:@selector(companyContactCustomMessageFromError:)]==YES)
                                                                                                   {
                                                                                                       failReasonMessage = [blockself.superViewController performSelector:@selector(companyContactCustomMessageFromError:) withObject:failDownloadContactError];
                                                                                                   }
                                                                                                   
                                                                                                   //////////////////////////////////////////////////
                                                                                                   
                                                                                                   if([failReasonMessage length]>0)
                                                                                                   {
                                                                                                       [WCToastController showMessageToastFromSuperView:[UIViewController topMostViewController].view
                                                                                                                                            withMessage:failReasonMessage
                                                                                                                                               position:PPToastPositionCenter];
                                                                                                   }
                                                                                                   else
                                                                                                   {
                                                                                                       [WCToastController showMessageToastFromSuperView:[UIViewController topMostViewController].view
                                                                                                                                            withMessage:[NSString stringWithFormat:WCTCCV_MLS_CouldntDonwloadSomeContacts,errorDataList.count]
                                                                                                                                               position:PPToastPositionCenter];
                                                                                                   }
                                                                                               }
                                                                                               else
                                                                                               {
                                                                                                   // MARK: !! matomo log (從共享聯絡人下載)
                                                                                                   if (error==nil)
                                                                                                   {
                                                                                                       [WCTMatomoController sendLogWithDownloadSource:WCTMatomoController_DownloadSource_SharedList];
                                                                                                   }

                                                                                                   blockself.superViewController.contactInfoHasChanged = YES;
                                                                                                   
                                                                                                   //////////////////////////////////////////////////
                                                                                                   
                                                                                                   // 非公司聯絡人清單頁面，退開(單選點擊下載情況)
                                                                                                   if([topMostViewControllerString compare:@"WCTCompanyContactMultiSelectViewController"]!=NSOrderedSame)
                                                                                                   {
                                                                                                       //更新列表
                                                                                                       WCTCompanyCardModel *model = [blockself.superViewController companyCardModelWithCardID:[cardIDs firstObject]];
                                                                                                       
                                                                                                       if(model!=nil)
                                                                                                       {
                                                                                                           model.downloadStatus = WCTCompanyCardModelDownloadStatus_Done;
                                                                                                       }
                                                                                                       
                                                                                                       //////////////////////////////////////////////////
                                                                                                       
                                                                                                       [blockself.superViewController.tableView reloadData];
                                                                                                       
                                                                                                       //////////////////////////////////////////////////
                                                                                                       
                                                                                                       [WCToastController showMessageToastFromSuperView:[UIViewController topMostViewController].view
                                                                                                                                            withMessage:WCTCCV_MLS_DownloadSuccessMessage
                                                                                                                                               position:PPToastPositionCenter];
                                                                                                       
                                                                                                   }
                                                                                                   else
                                                                                                   {
                                                                                                       //下載連絡人後，要刷新連絡人列表
                                                                                                       
                                                                                                       [[NSNotificationCenter defaultCenter] postNotificationName:WCTCompanyContactListHasChangedNotificationName
                                                                                                                                                           object:nil
                                                                                                                                                         userInfo:@{@"allCardSectionArray":blockself.superViewController.allCardSectionArray}];
                                                                                                       
                                                                                                       //////////////////////////////////////////////////
                                                                                                       
                                                                                                       [WCToastController showMessageToastFromSuperView:[UIViewController topMostViewController].view
                                                                                                                                            withMessage:WCTCCV_MLS_DownloadSuccessMessage
                                                                                                                                               position:PPToastPositionCenter];
                                                                                                       //////////////////////////////////////////////////
                                                                                                       
                                                                                                       dispatch_time_t time = dispatch_time(DISPATCH_TIME_NOW, 2.1*NSEC_PER_SEC);
                                                                                                       
                                                                                                       dispatch_after(time, dispatch_get_main_queue(), ^{
                                                                                                           [blockself.superViewController dismissAnimated:YES
                                                                                                                                               completion:nil];
                                                                                                       });
                                                                                                   }
                                                                                               }
                                                                                               
                                                                                               //////////////////////////////////////////////////
                                                                                               
                                                                                               [cardIDs release];
                                                                                               
                                                                                               self.selectedGroupArray = nil;
                                                                                           }];
        }];
    }
    while (0);
    return nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showGroupViewControllerWithUserInfo:(id)userInfo fromViewController:(WCTableViewController *)viewController
{
    do
    {
        if(viewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        self.superViewController = viewController;
        
        //////////////////////////////////////////////////
        [WCGroupAccessFlowController sharedInstance].delegate = self;
        [WCGroupAccessFlowController sharedInstance].userInfo = userInfo;
        [[WCGroupAccessFlowController sharedInstance] showMultiSelectGroupViewControllerFromViewController:viewController titleString:WCTCCV_MLS_ChangeGroup forcePresent:YES];
//        WCGroupViewController *groupViewController = [[WCGroupViewController alloc] init];
//
//        if(groupViewController==nil)
//        {
//            break;
//        }
//
//        //////////////////////////////////////////////////
//
//        [groupViewController setDelegate:self];
//        groupViewController.titleString = WCTCCV_MLS_ChangeGroup;
//        groupViewController.style = WCGroupSelectorViewControllerStyle_ChangeGroupWithoutAdd;
//        groupViewController.maxGroupLength = WCT_FML_Group;
//
//        // 存下目前操作的聯絡人
//        groupViewController.userInfo = userInfo;
//
//        //////////////////////////////////////////////////
//
//        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:groupViewController];
//
//        [groupViewController release];
//
//        if(navigationController==nil)
//        {
//            break;
//        }
//
//        [viewController presentViewController:navigationController animated:YES completion:nil];
//
//        [navigationController release];
//
    }
    while (0);
    
}

@end
