//
//  SearchMultiSelectViewController.m
//  Extension
//
//  Created by AndrewLai on 2018/4/20.
//

//Define
#import "ContactApperanceDefine.h"
#import "WCAdvancedSearchViewController+ParameterDefine.h"
#import "WCAdvancedSearchViewController+ResourceDefine.h"
#import "WCTAdvancedSearchViewController+ParameterDefine.h"
#import "WCTAdvancedSearchViewController+ResourceDefine.h"
#import "WCAppearanceDefine.h"

//View
#import "PPButton+Factory.h"
#import "PPTableView.h"
#import "PPNavigationBarView.h"
#import "SearchCheckBoxAccountTableViewCell.h"

//Controller
#import "SearchMultiSelectViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString *const CheckBoxTextFieldIdentifier = @"CheckBoxTextFieldIdentifier";

typedef NS_ENUM(NSUInteger, SearchMultiSelectViewController_ButtonTag)
{
    SearchMultiSelectViewController_ButtonTag_Back = 0,
    SearchMultiSelectViewController_ButtonTag_Finish
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface SearchMultiSelectViewController () <UITableViewDataSource, UITableViewDelegate, PPButtonDelegate>

@property (nonatomic, retain) NSMutableArray *selectItemList;

@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPTableView *selectTableView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation SearchMultiSelectViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if (self = [super init])
    {
        self.selectItemList = [NSMutableArray array];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_selectItemList removeAllObjects];
    [_selectItemList release];
    _selectItemList = nil;
    
    self.navigationItem.leftBarButtonItem = nil;
    [_ppNavigationBarView release];
    _ppNavigationBarView = nil;
    
    [_selectTableView removeFromSuperview];
    [_selectTableView release];
    _selectTableView = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(requestListInSearchMultiSelectViewController:)]==YES)
    {
        self.selectItemList = [self.delegate requestListInSearchMultiSelectViewController:self];
    }
    
    //////////////////////////////////////////////////
    self.ppNavigationBarView = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
    if (self.ppNavigationBarView!=nil)
    {
        self.ppNavigationBarView.style      = PPBarViewStyle_CenteredAbsolute;
        self.ppNavigationBarView.tintColor  = self.navigationController.navigationBar.tintColor;
        self.ppNavigationBarView.titleLabel.text = WCTASVC_MLS_NavigationUserDefineAdd;
        
        UIBarButtonItem *leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        if (leftBarButtonItem!=nil)
        {
            self.navigationItem.leftBarButtonItem = leftBarButtonItem;
        }
        
        //////////////////////////////////////////////////
        PPButton *backButton = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                               tag:SearchMultiSelectViewController_ButtonTag_Back
                                                          delegate:self
                                             normalBackgroundColor:nil
                                        highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                   imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        {
            [backButton addControlEvents:UIControlEventTouchUpInside];
            [self.ppNavigationBarView setViews:@[backButton]
                                  forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        PPButton *finishButton = [PPButton ppButtonWithIconImageName:WCAdvancedSearchViewControllerButtonName_Done
                                                                  tag:SearchMultiSelectViewController_ButtonTag_Finish
                                                             delegate:self
                                                normalBackgroundColor:nil
                                           highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                      imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
        if(finishButton!=nil)
        {
            [finishButton addControlEvents:UIControlEventTouchUpInside];
            
            [self.ppNavigationBarView setViews:@[finishButton]
                                  forBlockType:PPBarViewBlockType_Right];
        }
    }
    
    //////////////////////////////////////////////////
    _selectTableView = [[PPTableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
    if(self.selectTableView!=nil)
    {
        self.selectTableView.separatorInset = UIEdgeInsetsZero;
        self.selectTableView.dataSource = self;
        self.selectTableView.delegate   = self;
        self.selectTableView.separatorColor = WCAppearanceDefine_SeparatorColor;
        
        if([self.selectTableView respondsToSelector:@selector(setEstimatedRowHeight:)]==YES)
        {
            self.selectTableView.rowHeight = UITableViewAutomaticDimension;
            [self.selectTableView setEstimatedRowHeight:PPTableViewDefaultRowHeight];
        }
        
        [self.view addSubview:self.selectTableView];
        [self.selectTableView reloadData];
    }
}


//================================================================================
//
//================================================================================
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    //////////////////////////////////////////////////
    self.selectTableView.frame = self.view.bounds;
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.selectTableView removeFromSuperview];
    self.selectTableView.delegate = nil;
    self.selectTableView.dataSource = nil;
    self.selectTableView = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    //////////////////////////////////////////////////
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.selectItemList.count;
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;

    cell = [tableView dequeueReusableCellWithIdentifier:CheckBoxTextFieldIdentifier];
    if(cell==nil)
    {
        cell = [[[SearchCheckBoxAccountTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                          reuseIdentifier:CheckBoxTextFieldIdentifier] autorelease];
    }
    
    //////////////////////////////////////////////////
    SearchCheckBoxAccountTableViewCell *checkBoxCell = (SearchCheckBoxAccountTableViewCell *)cell;
    [checkBoxCell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];

    //////////////////////////////////////////////////
    SearchSelectModel *selectModel = [self.selectItemList objectAtIndex:indexPath.row];
    
    [checkBoxCell setCheckBoxViewStatus:selectModel.isSelected];
    [checkBoxCell.textLabel setText:selectModel.selectItemString];
    
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AdvanceSearchViewDelegate

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:NO];
    
    //////////////////////////////////////////////////
    SearchSelectModel *accountSelectModel = [self.selectItemList objectAtIndex:indexPath.row];
    accountSelectModel.isSelected = !accountSelectModel.isSelected;
    
    //////////////////////////////////////////////////
    [tableView reloadSections:[NSIndexSet indexSetWithIndex:indexPath.section] withRowAnimation:UITableViewRowAnimationNone];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    [self goBackAnimated:YES];
    
    //////////////////////////////////////////////////
    if (ppButton.tag==SearchMultiSelectViewController_ButtonTag_Finish)
    {
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(searchMultiSelectViewController:didFinishSelectModels:)]==YES)
        {
            NSMutableArray *accountList = [NSMutableArray array];
            for (SearchSelectModel *selectModel in self.selectItemList)
            {
                if (selectModel.isSelected==YES)
                {
                    [accountList addObject:selectModel];
                }
            }
            
            [self.delegate searchMultiSelectViewController:self didFinishSelectModels:accountList];
        }
    }
}

@end
