//
//  CategoryTableViewCell.m
//  WorldNote
//
//  Created by Andrew.Lai on 14/3/20.
//  Copyright (c) 2014年 Eddie. All rights reserved.
//

#import "ASVCTableViewCell.h"

@interface ASVCTableViewCell ()

@property (nonatomic, retain) NSString *cardCountString;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation CategoryTableViewCell

@implementation ASVCTableViewCell





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self)
    {
        self.edgeInsers = UIEdgeInsetsMake(0, 15, 0, 15);
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.cardCountString = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
	
    //////////////////////////////////////////////////
    
    CGRect textLabelFrame = self.textLabel.frame;
    
    switch(self.style)
    {
        case UITableViewCellStyleValue1:
        {
            if (self.detailTextLabel.hidden==YES)
            {
                textLabelFrame.origin.x = self.edgeInsers.left;
                textLabelFrame.size.width   = (textLabelFrame.size.width*2)-self.edgeInsers.left;
                
//                CGRect detailTextLabelFrame = self.detailTextLabel.frame;
//                detailTextLabelFrame.origin.x     = textLabelFrame.origin.x+textLabelFrame.size.width+PPTableViewCellDefaultHorizontalGap;
//                self.detailTextLabel.frame = detailTextLabelFrame;
            }
            else
            {
                // !!如果比最大值大，就限制在最大長度，比較小就用原本的字串寬度
                NSString * groupCount = [NSString stringWithFormat:@"(%d)",MaximumContentCount];
                if ([self.cardCountString length]<=[groupCount length])
                {
                    groupCount = self.cardCountString;
                }
                
                CGSize detailTextLabelSize = [groupCount sizeWithAttributes:@{NSFontAttributeName:self.detailTextLabel.font}];
                
                textLabelFrame.origin.x = self.edgeInsers.left;
                textLabelFrame.size.width   = (textLabelFrame.size.width*2)-self.edgeInsers.left-detailTextLabelSize.width-PPTableViewCellDefaultHorizontalGap;
                
                CGRect detailTextLabelFrame = self.detailTextLabel.frame;
                detailTextLabelFrame.origin.x     = textLabelFrame.origin.x+textLabelFrame.size.width+PPTableViewCellDefaultHorizontalGap;
                detailTextLabelFrame.size.width   = detailTextLabelSize.width;
                self.detailTextLabel.frame = detailTextLabelFrame;
            }
            
            break;
        }
        case UITableViewCellStyleValue2:
        case UITableViewCellStyleSubtitle:
        case UITableViewCellStyleDefault:
        default:
        {
            break;
        }
    }
    
    self.textLabel.frame = textLabelFrame;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
// 避免內外格式不統一的錯誤,讓使用者只需傳入數字
//================================================================================
- (void)setCardCount:(NSUInteger)cardCount
{
    self.cardCountString = [NSString stringWithFormat:@"(%lu)", (long)cardCount];
    
    self.detailTextLabel.text = self.cardCountString;
}

@end
