//
//  AIVCShareModeButtonsCell.m
//  Pods
//
//  Created by AndrewLai on 2016/4/14.
//
//

#import "AIVCShareModeButtonsCell.h"

// View
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSUInteger, AIVCShareModeButtonsCellButtonTag)
{
    AIVCShareModeButtonsCellButtonTag_Email = 1,
    AIVCShareModeButtonsCellButtonTag_SMS,
    AIVCShareModeButtonsCellButtonTag_QRCode
};

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - AIVCShareModeButtonsCell Extension

@interface AIVCShareModeButtonsCell () <PPButtonDelegate>
@property (nonatomic, retain) PPButton *ppButtonEmail;
@property (nonatomic, retain) PPButton *ppButtonSMS;
@property (nonatomic, retain) PPButton *ppButtonQRcode;
@end





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - AIVCShareModeButtonsCell Implementation

@implementation AIVCShareModeButtonsCell





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if ((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        _ppButtonEmail = [[PPButton ppButtonWithIconImageName:@"AccountInfoShareCellEmail"
                                                          tag:AIVCShareModeButtonsCellButtonTag_Email
                                                    delegate:self
                                       normalBackgroundColor:nil
                                  highlightedBackgroundColor:nil
                                             imageEdgeInsets:UIEdgeInsetsMake(10, 10, 10, 10)] retain];
        if (self.ppButtonEmail!=nil)
        {
            [self.ppButtonEmail addControlEvents:UIControlEventTouchUpInside];
            [self.contentView addSubview:self.ppButtonEmail];
        }
        
        //////////////////////////////////////////////////
        _ppButtonSMS = [[PPButton ppButtonWithIconImageName:@"AccountInfoShareCellSMS"
                                                          tag:AIVCShareModeButtonsCellButtonTag_SMS
                                                     delegate:self
                                        normalBackgroundColor:nil
                                   highlightedBackgroundColor:nil
                                              imageEdgeInsets:UIEdgeInsetsMake(10, 10, 10, 10)] retain];
        if (self.ppButtonSMS!=nil)
        {
            [self.ppButtonSMS addControlEvents:UIControlEventTouchUpInside];
            [self.contentView addSubview:self.ppButtonSMS];
        }
        
        //////////////////////////////////////////////////
        _ppButtonQRcode = [[PPButton ppButtonWithIconImageName:@"AccountInfoShareCellQRCode"
                                                        tag:AIVCShareModeButtonsCellButtonTag_QRCode
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:nil
                                            imageEdgeInsets:UIEdgeInsetsMake(10, 10, 10, 10)] retain];
        if (self.ppButtonQRcode!=nil)
        {
            [self.ppButtonQRcode addControlEvents:UIControlEventTouchUpInside];
            [self.contentView addSubview:self.ppButtonQRcode];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_ppButtonEmail removeFromSuperview];
    _ppButtonEmail.delegate = nil;
    _ppButtonEmail = nil;
    
    [_ppButtonSMS removeFromSuperview];
    _ppButtonSMS.delegate = nil;
    _ppButtonSMS = nil;
    
    [_ppButtonQRcode removeFromSuperview];
    _ppButtonQRcode.delegate = nil;
    _ppButtonQRcode = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect layoutRegin = self.contentView.bounds;
    
    self.textLabel.frame = CGRectZero;
    self.detailTextLabel.frame = CGRectZero;
    
    self.ppButtonEmail.frame  = CGRectMake(0, 0, layoutRegin.size.width/3, layoutRegin.size.height);
    self.ppButtonSMS.frame    = CGRectMake(layoutRegin.size.width/3, 0, layoutRegin.size.width/3, layoutRegin.size.height);
    self.ppButtonQRcode.frame = CGRectMake((layoutRegin.size.width/3)*2, 0, layoutRegin.size.width/3, layoutRegin.size.height);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case AIVCShareModeButtonsCellButtonTag_Email:
        {
            NSLog(@"Email");
            
            break;
        }
        case AIVCShareModeButtonsCellButtonTag_SMS:
        {
            NSLog(@"SMS");
            
            break;
        }
        case AIVCShareModeButtonsCellButtonTag_QRCode:
        {
            NSLog(@"QRCode");
            
            break;
        }
        default:
            break;
    }
}

@end
