//
//  AIVCSectionController.m
//  Pods
//
//  Created by AndrewLai on 2016/4/12.
//
//

#import "AIVCSectionController.h"

//Define
#import "WCTSettingsKey.h"
#import "WCTAccountInfoViewController+ResourceDefine.h"

// Category
#import "NSString+Additions.h"

// Model
#import "AIVCInfoSectionModel.h"
#import "WCTAccountRelationModel.h"

// Controller
#import "PPSettingsController.h"
#import "WCTRestClientController.h"
#import "WCTDataController.h"
#import "WCTAccountDataController.h"
#import "WCTAccountRelationModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AIVCSectionController Implementation

@implementation AIVCSectionController





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountInfoMainTypeOrders release];
    _accountInfoMainTypeOrders = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (void)fetchAccountInfoWithMainTypeOrders:(NSArray *)typeOrders toSectionModelsForSearching:(BOOL)searching
{
    do
    {
        if (typeOrders==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        self.accountInfoMainTypeOrders = typeOrders;
        
        //////////////////////////////////////////////////
        //!! 移除現在存在的資料
        [[self sectionModelsForSearching:searching] removeAllObjects];
        
        //////////////////////////////////////////////////
        __block NSArray *accountList = nil;
        [WCTAccountDataController updateAccountListFromServerWithCompleteHandler:^(NSArray *allAccountList, NSError *error) {
            WCTDataController *dataController = [[WCTDataController alloc] initWithAccessMode:WCDC_AM_All];
            if (dataController!=nil)
            {
                accountList = [dataController copyAllAccountList];
                
                [dataController release];
            }
        }];
        
        //////////////////////////////////////////////////
        for (NSNumber *typeNumber in typeOrders)
        {
            @autoreleasepool
            {
                AIVCInfoSectionModel *sectionModel = nil;
                
                switch ([typeNumber unsignedIntegerValue])
                {
                    case AccountInfoMainType_Account:
                    {
                        sectionModel = [self infoSectionModelForAccountTypeWithAccountList:accountList];
                        break;
                    }
                    case AccountInfoMainType_ShareMyCard:
                    {
                        if (Demo==NO)
                        {
                            sectionModel = [self infoSectionModelForShareMyCardType];
                        }
                        
                        break;
                    }
                    case AccountInfoMainType_ColleaguesRelationship:
                    {
                        sectionModel = [self infoSectionModelForColleaguesRelationshipTypeWithAccountList:accountList];
                        break;
                    }
                    case AccountInfoMainType_Ability:
                    {
                        sectionModel = [self infoSectionModelForAbility];
                        
                        break;
                    }
                    default:
                        break;
                }
                
                //////////////////////////////////////////////////
                if (sectionModel!=nil && sectionModel.rowModels.count>0)
                {
                    [[self sectionModelsForSearching:searching] addObject:sectionModel];
                }
            }
        }
        
        [accountList release];
    } while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SectionModel Methods

//================================================================================
//
//================================================================================
- (AIVCInfoSectionModel *)infoSectionModelForAccountTypeWithAccountList:(NSArray *)accountList
{
    AIVCInfoSectionModel *infoSectionModel = nil;
    
    if (accountList!=nil)
    {
        infoSectionModel = [[AIVCInfoSectionModel alloc] init];
        if (infoSectionModel!=nil)
        {
            infoSectionModel.accountInfoMainType = AccountInfoMainType_Account;
            
            //////////////////////////////////////////////////
            for (WCTAccountRelationModel *relationModel in accountList)
            {
                if (relationModel.relation==WCTAccountRelationModel_Relation_Account)
                {
                    PPRowModel *textRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                                      text:relationModel.name
                                                                detailText:relationModel.email
                                                                    object:@(AccountInfoSubType_Account_InfoText)];
                    if (textRowModel!=nil)
                    {
                        [infoSectionModel.rowModels addObject:textRowModel];
                    }
                    
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            if (Demo==NO)
            {
                PPRowModel *imageRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                                   text:nil
                                                             detailText:nil
                                                                 object:@(AccountInfoSubType_Account_CardImage)];
                if (imageRowModel!=nil)
                {
                    [infoSectionModel.rowModels addObject:imageRowModel];
                }
            }
        }
    }
    
    return [infoSectionModel autorelease];
}


//================================================================================
//
//================================================================================
- (AIVCInfoSectionModel *)infoSectionModelForShareMyCardType
{
    AIVCInfoSectionModel *infoSectionModel = [[AIVCInfoSectionModel alloc] init];
    if (infoSectionModel!=nil)
    {
        infoSectionModel.accountInfoMainType = AccountInfoMainType_ShareMyCard;
        infoSectionModel.title = WCTAccountInfoViewControllerString_ShareMyCardTitle;
        
        //////////////////////////////////////////////////
        PPRowModel *buttonRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                            text:nil
                                                      detailText:nil
                                                          object:@(AccountInfoSubType_ShareMyCard_ModeButtons)];
        if (buttonRowModel!=nil)
        {
            [infoSectionModel.rowModels addObject:buttonRowModel];
        }
    }
    
    return [infoSectionModel autorelease];
}


//================================================================================
//
//================================================================================
- (AIVCInfoSectionModel *)infoSectionModelForColleaguesRelationshipTypeWithAccountList:(NSArray *)accountList
{
    AIVCInfoSectionModel *infoSectionModel = [[AIVCInfoSectionModel alloc] init];
    if (infoSectionModel!=nil)
    {
        infoSectionModel.accountInfoMainType = AccountInfoMainType_ColleaguesRelationship;
        infoSectionModel.title = WCTAccountInfoViewControllerString_Relation;
        
        NSMutableArray *bossTextArray        = [NSMutableArray array];
        NSMutableArray *subordinateTextArray = [NSMutableArray array];
        
        //////////////////////////////////////////////////
        //找出Boss與Subordinate
        for (WCTAccountRelationModel *relationModel in accountList)
        {
            if (relationModel.relation==WCTAccountRelationModel_Relation_Boss)
            {
                //Boss
                [bossTextArray addObject:relationModel.name];
            }
            
            if (relationModel.relation==WCTAccountRelationModel_Relation_Subordinate)
            {
                //Subordinate
                [subordinateTextArray addObject:relationModel.name];
            }
        }
        
        //////////////////////////////////////////////////
        //製作Boss的RowModel
        if (bossTextArray.count>0)
        {
            NSString *bossText = @"";
            for (NSInteger index=0; index<bossTextArray.count; index++)
            {
                NSString *accountName = [bossTextArray objectAtIndex:index];
                bossText = [bossText stringByAppendingString:accountName];
                if (index!=bossTextArray.count-1)
                {
                    bossText = [bossText stringByAppendingString:@"; "];
                }
            }
            
            //////////////////////////////////////////////////
            PPRowModel *bossRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                              text:bossText
                                                        detailText:WCTAccountInfoViewControllerString_Boss
                                                            object:@(AccountInfoSubType_ColleaguesRelationship_Boss)];
            if (bossRowModel!=nil)
            {
                [infoSectionModel.rowModels addObject:bossRowModel];
            }
        }

        //////////////////////////////////////////////////
        //製作Subordinate的rowModel
        if (subordinateTextArray.count>0)
        {
            NSString *subordinateText = @"";
            for (NSInteger index=0; index<subordinateTextArray.count; index++)
            {
                NSString *accountName = [subordinateTextArray objectAtIndex:index];
                subordinateText = [subordinateText stringByAppendingString:accountName];
                if (index!=subordinateTextArray.count-1)
                {
                    subordinateText = [subordinateText stringByAppendingString:@"; "];
                }
            }
            
            //////////////////////////////////////////////////
            PPRowModel *subordinateRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                                     text:subordinateText
                                                               detailText:WCTAccountInfoViewControllerString_Subordinate
                                                                   object:@(AccountInfoSubType_ColleaguesRelationship_Subordinate)];
            if (subordinateRowModel!=nil)
            {
                [infoSectionModel.rowModels addObject:subordinateRowModel];
            }
        }
    }
    
    return [infoSectionModel autorelease];
}


//================================================================================
//
//================================================================================
- (AIVCInfoSectionModel *)infoSectionModelForAbility
{
    __block AIVCInfoSectionModel *infoSectionModel = nil;
    
    [WCTAccountDataController updateAccountInfoFromServerWithCompleteHandler:^(BOOL hasNetwork) {
    
        PPRowModel *authorityRowModel = nil;
        
        infoSectionModel = [[AIVCInfoSectionModel alloc] init];
        
        if (infoSectionModel!=nil)
        {
            infoSectionModel.accountInfoMainType = AccountInfoMainType_Ability;
            infoSectionModel.title = WCTAccountInfoViewControllerString_Ability;
            
            //////////////////////////////////////////////////
            BOOL exportAbility = [PPSettingsController integerValueWithKey:WCTSettingsKey_ExportAbility];
         
            if (exportAbility)
            {
                authorityRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                           text:WCTAccountInfoViewControllerString_ExportAbility
                                                     detailText:nil
                                                         object:@(AccountInfoSubType_ExportAbility)];
                if (authorityRowModel!=nil)
                {
                    [infoSectionModel.rowModels addObject:authorityRowModel];
                }
            }

            
            //////////////////////////////////////////////////
            BOOL secretaryAbility = [PPSettingsController integerValueWithKey:WCTSettingsKey_HelpScanningAbility];
            
            if (secretaryAbility)
            {
                authorityRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                           text:WCTAccountInfoViewControllerString_SecretaryAbility
                                                     detailText:nil
                                                         object:@(AccountInfoSubType_SecretaryAbility)];
                if (authorityRowModel!=nil)
                {
                    [infoSectionModel.rowModels addObject:authorityRowModel];
                }
            }
            
            //////////////////////////////////////////////////
            BOOL printAbility = [PPSettingsController integerValueWithKey:WCTSettingsKey_PrintAbility];
            
            if (printAbility)
            {
                authorityRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                           text:WCTAccountInfoViewControllerString_PrintAbility
                                                     detailText:nil
                                                         object:@(AccountInfoSubType_PrintAbility)];
                if (authorityRowModel!=nil)
                {
                    [infoSectionModel.rowModels addObject:authorityRowModel];
                }
            }
            
            //////////////////////////////////////////////////
            // 如果都沒有顯示"沒有開啟任何功能"
            
            if ([infoSectionModel.rowModels count]==0)
            {
                authorityRowModel = [PPRowModel rowModelWithRow:infoSectionModel.rowModels.count
                                                           text:WCTAccountInfoViewControllerString_NoAbility
                                                     detailText:nil
                                                         object:@(AccountInfoSubType_NoAbility)];
                if (authorityRowModel!=nil)
                {
                    [infoSectionModel.rowModels addObject:authorityRowModel];
                }
            }
        }
    }];
    
    return [infoSectionModel autorelease];
}

@end
