//
//  WCTAFCUpdateInfoViewController.m
//  Pods
//
//  Created by AndrewLai on 2016/5/5.
//
//

#import "WCTAFCUpdateInfoViewController.h"

//Category
#import "UIViewController+ShareApplication.h"

//Define
#import "NSString+Additions.h"
#import "WCAppearanceDefine.h"
#import "WCTAccountFlowController+ResourceDefine.h"

//Views
#import "PPButton+Factory.h"
#import "PPNavigationBarView.h"
#import "PPTableView.h"
#import "PPTextFieldTableViewCell.h"

//Controller
#import "WCTAFCUpdateInfoSectionController.h"
#import "WCToastController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
//#define WCTAppearanceDefine_IconButtonImageEdgeInset             UIEdgeInsetsMake(10, 10, 10, 10)
//#define WCTAppearanceDefine_IconButtonHighlightedBackgroundColor [UIColor colorWithHexString:@"#2c538f"]

#define WCTAFCUpdateInfoeViewController_MaxLength 32
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAFCUpdateInfoViewController Extension

@interface WCTAFCUpdateInfoViewController () <PPButtonDelegate, UITableViewDelegate, UITableViewDataSource, PPTextFieldTableViewCellDelegate>

@property (nonatomic, retain) WCTAFCUpdateInfoSectionController *updateInfoSectionController;
@property (nonatomic, retain) PPButton                          *ppButtonBack;
@property (nonatomic, retain) PPNavigationBarView               *ppNavigationBarView;
@property (nonatomic, retain) PPTableView                       *ppTableView;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTAFCUpdateInfoViewController Implementation

@implementation WCTAFCUpdateInfoViewController




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _updateInfoSectionController = [[WCTAFCUpdateInfoSectionController alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    
    
    [self.ppTableView removeFromSuperview];
    self.ppTableView.dataSource = nil;
    self.ppTableView.delegate = nil;
    self.ppTableView = nil;

    [_accountName release];
    _accountName = nil;
    
    [_updateInfoSectionController release];
    _updateInfoSectionController = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    [self.updateInfoSectionController prepareDataWithAccountName:self.accountName];
    
    //////////////////////////////////////////////////
    _ppTableView = [[PPTableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
    if (self.ppTableView!=nil)
    {
        self.ppTableView.dataSource = self;
        self.ppTableView.delegate   = self;
        
        [self.view addSubview:self.ppTableView];
    }
    
    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    if (self.ppNavigationBarView!=nil)
    {
        self.ppNavigationBarView.style = PPBarViewStyle_CenteredAbsolute;
        
        //////////////////////////////////////////////////
        _ppButtonBack = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                         tag:WCTAFCUpdateInfoViewControllerAction_Back
                                                    delegate:self
                                       normalBackgroundColor:nil
                                  highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                             imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset] retain];
        if (self.ppButtonBack!=nil)
        {
            [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
            
            PPBarViewItemModel *backItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            if (backItemModel!=nil)
            {
                backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                [self.ppNavigationBarView setItemModels:@[backItemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        // 先設定style後再設定title, 這樣大小才會正確
        [self.ppNavigationBarView.titleLabel setText:WCTAFC_MLS_AccountManager];

        //////////////////////////////////////////////////
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
    }
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    //////////////////////////////////////////////////
    
    [self.ppTableView endEditing:YES];
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack.delegate = nil;
    self.ppButtonBack = nil;
    

    [self.ppTableView removeFromSuperview];
    self.ppTableView.dataSource = nil;
    self.ppTableView.delegate = nil;
    self.ppTableView = nil;
    
    //////////////////////////////////////////////////
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    CGRect visibleFrame = [self layoutFrame];
    
    self.ppTableView.frame = CGRectMake(visibleFrame.origin.x,
                                        visibleFrame.origin.y,
                                        visibleFrame.size.width,
                                        visibleFrame.size.height);
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTAFCUpdateInfoViewControllerAction_Back:
        {
            [self.ppTableView endEditing:YES];

            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(updateInfoViewController:didSelectBackWithAccountName:)]==YES)
            {
                PPTextFieldTableViewCell *accountNameTextFieldCell = [self.ppTableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:WCTAFCUpdateInfoSectionAccountName_Row_AccountName
                                                                                                                                inSection:WCTAFCUpdateInfoSection_AccountName]];
                NSString *accountName = accountNameTextFieldCell.textField.text;
                if([[accountName stringByTrimmingUnvisibleChar] length]>0)
                {
                    [self.delegate updateInfoViewController:self didSelectBackWithAccountName:accountName];
                }
                else
                {
                    [WCToastController showMessageToastFromSuperView:self.view
                                                         withMessage:WCTAFC_MLS_AccountNameEmpty
                                                            position:PPToastPositionCenter];
                    return ;
                }
            }
            
            [self goBackAnimated:YES];
            
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource

//================================================================================
//
//================================================================================
- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return [self.updateInfoSectionController titleForHeaderInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return [self.updateInfoSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.updateInfoSectionController numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = nil;
    
    do
    {
        PPSectionModel *sectionModel = [[self.updateInfoSectionController sectionModelsForSearching:NO] objectAtIndex:indexPath.section];
        
        switch (sectionModel.section)
        {
            case WCTAFCUpdateInfoSection_AccountName:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([PPTextFieldTableViewCell class])];
                if (cell==nil)
                {
                    cell = [[[PPTextFieldTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([PPTextFieldTableViewCell class])] autorelease];
                }
                
                //////////////////////////////////////////////////
                if (sectionModel!=nil)
                {
                    PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:indexPath.row];
                    if (rowModel!=nil)
                    {
                        PPTextFieldTableViewCell *textFieldCell = (PPTextFieldTableViewCell *)cell;
                        textFieldCell.delegate  = self;
                        
                        //////////////////////////////////////////////////
                        textFieldCell.maxLength = WCTAFCUpdateInfoeViewController_MaxLength;
                        
                        //////////////////////////////////////////////////
                        if(rowModel.object!=nil && [rowModel.object isKindOfClass:[NSString class]]==YES)
                        {
                            textFieldCell.textField.text = rowModel.object;
                        }
                    }
                }
                
                break;
            }
            case WCTAFCUpdateInfoSection_PasswordChange:
            default:
            {
                cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([PPTableViewCell class])];
                if (cell==nil)
                {
                    cell = [[[PPTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([PPTableViewCell class])] autorelease];
                }
                
                //////////////////////////////////////////////////
                if (sectionModel!=nil)
                {
                    PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:indexPath.row];
                    
                    if(rowModel!=nil)
                    {
                        PPTableViewCell *tableViewCell = (PPTableViewCell *)cell;
                        
                        //////////////////////////////////////////////////
                        if(rowModel.object!=nil && [rowModel.object isKindOfClass:[NSString class]]==YES)
                        {
                            tableViewCell.textLabel.text = rowModel.object;
                        }
                    }
                }
                
                break;
            }
        }
    } while (0);
    
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    //////////////////////////////////////////////////
    PPRowModel *rowModel = [self.updateInfoSectionController rowModelAtIndexPath:indexPath forSearching:NO];
    if (indexPath.section==WCTAFCUpdateInfoSection_PasswordChange &&
        rowModel.row==WCTAFCUpdateInfoSectionPasswordChange_Row_PasswordChange)
    {
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(updateInfoViewControllerDidSelectChangePassword:)]==YES)
        {
            [self.delegate updateInfoViewControllerDidSelectChangePassword:self];
        }
    }
}

@end
