//
//  WCReorderViewController.m
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/13.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCReorderViewController.h"

// model
#import "WCCardModel.h"

// categories
#import "NSString+Additions.h"
#import "PPButton+Factory.h"

// views
#import "PPNavigationBarView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, WCReorderViewControllerButtonTag)
{
    WCReorderViewControllerButtonTag_Back = 0,
    WCReorderViewControllerButtonTag_Done,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCReorderViewController () <PPButtonDelegate>
@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPButton *ppButtonDone;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCReorderViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
+ (void)initialize
{
}


//==============================================================================
//
//==============================================================================
- (instancetype)initWithMode:(PPSIC_Mode)mode
{
    self = [super initWithMode:mode];
    if (self)
    {
        self.buttonImageEdgeInsets = UIEdgeInsetsZero;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.delegate = nil;
    self.doneButtonImageName = nil;
    self.buttonNormalBackgroundColor = nil;
    self.buttonHighlightedBackgroundColor = nil;
    
    [self removeMainUI];
    //////////////////////////////////////////////////
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    // !!  reorder一定要在編輯模式下
    self.enableReorderControl = YES;
    [self.tableView setEditing:YES];

    //////////////////////////////////////////////////
    [self prepareMainUI];
    
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCReorderViewControllerButtonTag_Back
                                                   delegate:self
                                      normalBackgroundColor:self.buttonNormalBackgroundColor
                                 highlightedBackgroundColor:self.buttonHighlightedBackgroundColor
                                            imageEdgeInsets:self.buttonImageEdgeInsets];
    
    self.ppButtonDone = [PPButton ppButtonWithIconImageName:self.doneButtonImageName
                                                        tag:WCReorderViewControllerButtonTag_Done
                                                   delegate:self
                                      normalBackgroundColor:self.buttonNormalBackgroundColor
                                 highlightedBackgroundColor:self.buttonHighlightedBackgroundColor
                                            imageEdgeInsets:self.buttonImageEdgeInsets];

    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * leftItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            leftItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[leftItemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        if (self.ppButtonDone)
        {
            [self.ppNavigationBarView  setViews:@[self.ppButtonDone] forBlockType:PPBarViewBlockType_Right];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }

}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppButtonBack = nil;
    self.ppButtonDone = nil;
    
    self.ppNavigationBarView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - button action


//==============================================================================
//
//==============================================================================
- (void)onClickDone
{
    if ([self.delegate respondsToSelector:@selector(reorderViewController:willFinishWithArray:)])
    {
        [self.delegate reorderViewController:self willFinishWithArray:self.allCardSectionArray];
    }
    //////////////////////////////////////////////////
    [self goBackAnimated:YES];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCReorderViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        case WCReorderViewControllerButtonTag_Done:
        {
            [self onClickDone];
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - UITableViewDelegate


//===============================================================================
//
//===============================================================================
- (BOOL)tableView:(UITableView *)tableView shouldIndentWhileEditingRowAtIndexPath:(NSIndexPath *)indexPath
{
    // !!為了不讓編輯的'+', '-'出現所以要再實作這兩個
    return NO;
}

//===============================================================================
//
//===============================================================================
- (UITableViewCellEditingStyle)tableView:(UITableView *)tableView editingStyleForRowAtIndexPath:(NSIndexPath *)indexPath
{
    // !!為了不讓編輯的'+', '-'出現所以要再實作這兩個
    return UITableViewCellEditingStyleNone;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - UITableViewDataSource


//===============================================================================
//
//===============================================================================
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)sourceIndexPath toIndexPath:(NSIndexPath *)destinationIndexPath
{
//    NSLog(@"%s- %@, %@", __PRETTY_FUNCTION__, sourceIndexPath, destinationIndexPath);

    // 如果沒有移動就不用動作
    if ([sourceIndexPath isEqual:destinationIndexPath])
    {
        return;
    }

    //////////////////////////////////////////////////
    NSUInteger          sourceSection = [sourceIndexPath section];
    NSUInteger          sourceRow = [sourceIndexPath row];
    
    NSUInteger          destSection = [destinationIndexPath section];
    NSUInteger          destRow = [destinationIndexPath row];

    // 目前只支援同section的移動
    if (sourceSection==destSection)
    {
        NSMutableArray      *cardSectionArray = self.allCardSectionArray;
        WCCardSectionModel  *cardSectionModel = [cardSectionArray objectAtIndex:sourceSection];
        WCCardModel *targetModel = [[cardSectionModel.cardArray objectAtIndex:sourceRow] retain];
        [cardSectionModel.cardArray removeObjectAtIndex:sourceRow];
        [cardSectionModel.cardArray insertObject:targetModel atIndex:destRow];
        [targetModel release];
    }
    else
    {
        
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTableViewControllerProtocol


//==============================================================================
//
//==============================================================================
- (UIImage *)cachedThumbnailImageWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(reorderViewController:cachedThumbnailImageWithCardID:)])
    {
        return [self.delegate reorderViewController:self cachedThumbnailImageWithCardID:cardID];
    }
    
    return nil;
}

//==============================================================================
//
//==============================================================================
- (UIImage *)thumbnailImageWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(reorderViewController:thumbnailImageWithCardID:)])
    {
        return [self.delegate reorderViewController:self thumbnailImageWithCardID:cardID];
    }
    
    return nil;
}

@end
