//
//  WCReorderViewController.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/13.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

/**
 * 用來排序的介面
 * 排序後的結果會在allCardSectionArray中，依序排列
 */
#import "WCTableViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@class WCReorderViewController;

@protocol WCReorderViewControllerDelegate <NSObject>

/**
 * 用來取得cache中的縮圖
 * @param reorderViewController viewcontroller的實體
 * @param cardID 要取得的名片圖的名片ID
 * @return UIImage 名片圖縮圖
 */
- (UIImage *)reorderViewController:(WCReorderViewController *)reorderViewController cachedThumbnailImageWithCardID:(NSString *)cardID;

/**
 * 用來取得cell中的縮圖
 * @param reorderViewController viewcontroller的實體
 * @param cardID 要取得的名片圖的名片ID
 * @return UIImage 名片圖縮圖
 */
- (UIImage *)reorderViewController:(WCReorderViewController *)reorderViewController thumbnailImageWithCardID:(NSString *)cardID;


/**
 * 回傳最後的順序, delegate執行後，view controller 就會結束
 * @param reorderViewController reorderViewController的實體
 * @param array 排序後的結果
 */
- (void)reorderViewController:(WCReorderViewController *)reorderViewController willFinishWithArray:(NSArray *)array;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCReorderViewController : WCTableViewController
@property (nonatomic, assign) id<WCReorderViewControllerDelegate> delegate;


/// done按鈕的icon西ohy, defualt nil
@property (nonatomic, retain) NSString *doneButtonImageName;

#pragma mark style

/// 按鈕的noraml background color, defualt nil
@property (nonatomic, retain) UIColor *buttonNormalBackgroundColor;

/// 按鈕的highlight background color, default nil
@property (nonatomic, retain) UIColor *buttonHighlightedBackgroundColor;

/// 按鈕image的edgeInsets, default UIEdgeInsetsZero
@property (nonatomic, assign) UIEdgeInsets buttonImageEdgeInsets;
@end
