//
//  WCRecognitionCardModel+WCCardModel.m
//
//  Created by Howard on 2015/7/24.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#import "WCRecognitionCardModel+WCCardModel.h"

#if defined (PRODUCTLINE_WCE)

// Model
#import "WCECardModel.h"
#import "WCEFieldModel.h"

#else

// Model
#import "WCCardModel.h"

#endif



@implementation WCRecognitionCardModel (WCCardModel)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (WC_FieldSubType1)fieldSubType1TransformWithFieldLabelType:(WCRecognitionFieldLabelType)fieldLabelType
{
    // MARK: Howard 應該要有個預設欄位
    WC_FieldSubType1 fieldSubType1 = 0;
    
    switch (fieldLabelType)
    {
        case WCRecognitionFieldLabelType_Address_Home:
        {
            fieldSubType1 = WC_FST1_Address_Home;
            break;
        }
        case WCRecognitionFieldLabelType_Address_Other:
        {
            fieldSubType1 = WC_FST1_Address_Other;
            break;
        }
        case WCRecognitionFieldLabelType_Address_Work:
        {
            fieldSubType1 = WC_FST1_Address_Work;
            break;
        }
        case WCRecognitionFieldLabelType_Birthday:
        {
            fieldSubType1 = WC_FST1_Date_Birthday;
            break;
        }
        case WCRecognitionFieldLabelType_Date_Anniversary:
        {
            fieldSubType1 = WC_FST1_Date_Anniversary;
            break;
        }
        case WCRecognitionFieldLabelType_Date_Other:
        {
            fieldSubType1 = WC_FST1_Date_Other;
            break;
        }
        case WCRecognitionFieldLabelType_Email_Home:
        {
            fieldSubType1 = WC_FST1_Email_Home;
            break;
        }
        case WCRecognitionFieldLabelType_Email_Other:
        {
            fieldSubType1 = WC_FST1_Email_Other;
            break;
        }
        case WCRecognitionFieldLabelType_Email_Work:
        {
            fieldSubType1 = WC_FST1_Email_Work;
            break;
        }
        case WCRecognitionFieldLabelType_IM_AIM:
        {
            fieldSubType1 = WC_FST1_IM_AIM;
            break;
        }
        case WCRecognitionFieldLabelType_IM_GoogleTalk:
        {
            fieldSubType1 = WC_FST1_IM_GoogleTalk;
            break;
        }
        case WCRecognitionFieldLabelType_IM_ICQ:
        {
            fieldSubType1 = WC_FST1_IM_ICQ;
            break;
        }
        case WCRecognitionFieldLabelType_IM_Jabber:
        {
            fieldSubType1 = WC_FST1_IM_Jabber;
            break;
        }
        case WCRecognitionFieldLabelType_IM_MSN:
        {
            fieldSubType1 = WC_FST1_IM_MSN;
            break;
        }
        case WCRecognitionFieldLabelType_IM_QQ:
        {
            fieldSubType1 = WC_FST1_IM_QQ;
            break;
        }
        case WCRecognitionFieldLabelType_IM_Skype:
        {
            fieldSubType1 = WC_FST1_IM_Skype;
            break;
        }
        case WCRecognitionFieldLabelType_IM_Yahoo:
        {
            fieldSubType1 = WC_FST1_IM_Yahoo;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_GoogleVoice:
        {
            fieldSubType1 = WC_FST1_Phone_GoogleVoice;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_Home:
        {
            fieldSubType1 = WC_FST1_Phone_Home;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_HomeFax:
        {
            fieldSubType1 = WC_FST1_Phone_HomeFax;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_iPhone:
        {
            fieldSubType1 = WC_FST1_Phone_iPhone;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_Main:
        {
            fieldSubType1 = WC_FST1_Phone_Main;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_Mobile:
        {
            fieldSubType1 = WC_FST1_Phone_Mobile;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_Other:
        {
            fieldSubType1 = WC_FST1_Phone_Other;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_Pager:
        {
            fieldSubType1 = WC_FST1_Phone_Pager;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_Work:
        {
            fieldSubType1 = WC_FST1_Phone_Work;
            break;
        }
        case WCRecognitionFieldLabelType_Phone_WorkFax:
        {
            fieldSubType1 = WC_FST1_Phone_WorkFax;
            break;
        }
        case WCRecognitionFieldLabelType_URL_Blog:
        {
            fieldSubType1 = WC_FST1_URL_Blog;
            break;
        }
        case WCRecognitionFieldLabelType_URL_Home:
        {
            fieldSubType1 = WC_FST1_URL_Home;
            break;
        }
        case WCRecognitionFieldLabelType_URL_HomePage:
        {
            fieldSubType1 = WC_FST1_URL_HomePage;
            break;
        }
        case WCRecognitionFieldLabelType_URL_Other:
        {
            fieldSubType1 = WC_FST1_URL_Other;
            break;
        }
        case WCRecognitionFieldLabelType_URL_Profile:
        {
            fieldSubType1 = WC_FST1_URL_Profile;
            break;
        }
        case WCRecognitionFieldLabelType_URL_Work:
        {
            fieldSubType1 = WC_FST1_URL_Work;
            break;
        }
        case WCRecognitionFieldLabelType_None:
        {
            fieldSubType1 = WC_FST1_None;
            break;
        }
        default:
        {
            break;
        }
    }
    
    return fieldSubType1;
}


//================================================================================
//
//================================================================================
- (WC_FieldSubType2)fieldSubType2TransformWithRecognitionSubType:(WCRecognitionFieldSubType)recogitionFieldSubType
{
    WC_FieldSubType2 fieldSubType2 = WC_FST2_None;
    
    switch (recogitionFieldSubType)
    {
        case WCRecognitionFieldSubType_Address_City:
        {
            fieldSubType2 = WC_FST2_Address_City;
            break;
        }
        case WCRecognitionFieldSubType_Address_Country:
        {
            fieldSubType2 = WC_FST2_Address_Country;
            break;
        }
        case WCRecognitionFieldSubType_Address_CountryCode:
        {
            fieldSubType2 = WC_FST2_Address_CountryCode;
            break;
        }
        case WCRecognitionFieldSubType_Address_Format:
        {
            fieldSubType2 = WC_FST2_Address_Format;
            break;
        }
        case WCRecognitionFieldSubType_Address_GPS:
        {
            fieldSubType2 = WC_FST2_Address_Location;
            break;
        }
        case WCRecognitionFieldSubType_Address_State:
        {
            fieldSubType2 = WC_FST2_Address_State;
            break;
        }
        case WCRecognitionFieldSubType_Address_Street:
        {
            fieldSubType2 = WC_FST2_Address_Street;
            break;
        }
        case WCRecognitionFieldSubType_Address_Zip:
        {
            fieldSubType2 = WC_FST2_Address_ZIP;
            break;
        }
        case WCRecognitionFieldSubType_Company_Department:
        {
            fieldSubType2 = WC_FST2_Company_Department;
            break;
        }
        case WCRecognitionFieldSubType_Company_JobTitle:
        {
            fieldSubType2 = WC_FST2_Company_JobTitle;
            break;
        }
        case WCRecognitionFieldSubType_Company_Name:
        {
            fieldSubType2 = WC_FST2_Company_Name;
            break;
        }
        case WCRecognitionFieldSubType_Company_Phonetic:
        {
            fieldSubType2 = WC_FST2_Company_Phonetic;
            break;
        }
        case WCRecognitionFieldSubType_Name_FirstName:
        {
            fieldSubType2 = WC_FST2_Name_First;
            break;
        }
        case WCRecognitionFieldSubType_Name_FirstNamePhonetic:
        {
            fieldSubType2 = WC_FST2_Name_FirstPhonetic;
            break;
        }
        case WCRecognitionFieldSubType_Name_LastName:
        {
            fieldSubType2 = WC_FST2_Name_Last;
            break;
        }
        case WCRecognitionFieldSubType_Name_LastNamePhonetic:
        {
            fieldSubType2 = WC_FST2_Name_LastPhonetic;
            break;
        }
        case WCRecognitionFieldSubType_Name_MiddleName:
        {
            fieldSubType2 = WC_FST2_Name_Middle;
            break;
        }
        case WCRecognitionFieldSubType_Name_Prefix:
        {
            fieldSubType2 = WC_FST2_Name_Prefix;
            break;
        }
        case WCRecognitionFieldSubType_Name_Suffix:
        {
            fieldSubType2 = WC_FST2_Name_Suffix;
            break;
        }
        case WCRecognitionFieldSubType_SearchOnly:
        {
            fieldSubType2 = WC_FST2_SearchOnly;
            break;
        }
        case WCRecognitionFieldSubType_None:
        {
            fieldSubType2 = WC_FST2_None;
            break;
        }
        case WCRecognitionFieldSubType_DontCare:
        default:
        {
            
            break;
        }
    }
    return fieldSubType2;
}


//================================================================================
//
//================================================================================
- (WC_FieldType)fieldTypeTransformWithFieldMainType:(WCRecognitionFieldMainType)fieldMainType
{
    WC_FieldType fieldType = WC_FT_None;
    
    switch (fieldMainType)
    {
        case WCRecognitionFieldMainType_Address:
        {
            fieldType = WC_FT_Address;
            break;
        }
        case WCRecognitionFieldMainType_Company:
        {
            fieldType = WC_FT_Company;
            break;
        }
        case WCRecognitionFieldMainType_Date:
        {
            fieldType = WC_FT_Date;
            break;
        }
        case WCRecognitionFieldMainType_Email:
        {
            fieldType = WC_FT_Email;
            break;
        }
        case WCRecognitionFieldMainType_InstantMessage:
        {
            fieldType = WC_FT_InstantMessage;
            break;
        }
        case WCRecognitionFieldMainType_Name:
        {
            fieldType = WC_FT_Name;
            break;
        }
        case WCRecognitionFieldMainType_Nickname:
        {
            fieldType = WC_FT_Nickname;
            break;
        }
        case WCRecognitionFieldMainType_None:
        {
            fieldType = WC_FT_None;
            break;
        }
        case WCRecognitionFieldMainType_Note:
        {
            fieldType = WC_FT_Note;
            break;
        }
        case WCRecognitionFieldMainType_Phone:
        {
            fieldType = WC_FT_Phone;
            break;
        }
        case WCRecognitionFieldMainType_UnifiedBusinessNumber:
        {
            fieldType = WC_FT_UnifiedBusinessNo;
            break;
        }
        case WCRecognitionFieldMainType_URL:
        {
            fieldType = WC_FT_URL;
            break;
        }
        default:
        {
            break;
        }
    }
    
    return fieldType;
}


//================================================================================
//
//================================================================================
- (WC_FieldSource)fieldSourceTransformWithFieldSource:(WCRecognitionFieldSource)fieldSource
{
    WC_FieldSource sourceType = WC_FS_UserCreate;
    
    switch (fieldSource)
    {
        case WCRecognitionFieldSource_BackRecog:
        {
            sourceType = WC_FS_BackRecog;
            break;
        }
        case WCRecognitionFieldSource_FrontRecog:
        {
            sourceType = WC_FS_FrontRecog;
            break;
        }
        case WCRecognitionFieldSource_UserCreate:
        {
            sourceType = WC_FS_UserCreate;
            break;
        }
        default:
        {
            
            break;
        }
    }
    
    return sourceType;
}


//================================================================================
//
//================================================================================
- (NSArray *)subType1FieldModelsTransformWithRecognitionFieldModel:(WCRecognitionFieldModel *)recognitionFieldModel
{
    NSMutableArray *fieldModels = nil;
    
    do
    {
        if(recognitionFieldModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        fieldModels = [NSMutableArray array];
        
        if(fieldModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WC_FieldModel *fieldModel = [[WC_FieldModel alloc] init];
        
        if(fieldModel==nil)
        {
            break;
        }
        
        fieldModel.ID       = WC_InvalidRecordID;
        fieldModel.type     = [self fieldTypeTransformWithFieldMainType:recognitionFieldModel.fieldMainType];
        fieldModel.subType1 = [self fieldSubType1TransformWithFieldLabelType:recognitionFieldModel.fieldLabelType];
        fieldModel.source   = [self fieldSourceTransformWithFieldSource:recognitionFieldModel.fieldSource];
        fieldModel.order    = recognitionFieldModel.fieldOrder;
        
        //////////////////////////////////////////////////
        
        for(id key in recognitionFieldModel.recognitionContextModelDictionary)
        {
            WCRecognitionContextModel *contextModel = [recognitionFieldModel.recognitionContextModelDictionary objectForKey:key];
            
            if(contextModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            fieldModel.subType2 = [self fieldSubType2TransformWithRecognitionSubType:contextModel.recognitionFieldSubType];
            fieldModel.isCJKStringValue = contextModel.isCJKStringValue;
            fieldModel.recogRect = contextModel.recognitionRect;
            fieldModel.value = contextModel.contextString;
            
        }
        
        [fieldModels addObject:fieldModel];
        
        [fieldModel release];
    }
    while (0);
    
    return fieldModels;
}


//================================================================================
//
//================================================================================
- (NSArray *)subType2FieldModelsTransformWithRecognitionFieldModel:(WCRecognitionFieldModel *)recognitionFieldModel
{
    NSMutableArray *fieldModels = nil;
    
    do
    {
        if(recognitionFieldModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        fieldModels = [NSMutableArray array];
        
        if(fieldModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WC_FieldModel *fieldModel = [[WC_FieldModel alloc] init];
        
        if(fieldModel==nil)
        {
            break;
        }
        
        fieldModel.ID       = WC_InvalidRecordID;
        fieldModel.type     = [self fieldTypeTransformWithFieldMainType:recognitionFieldModel.fieldMainType];
        fieldModel.subType1 = [self fieldSubType1TransformWithFieldLabelType:recognitionFieldModel.fieldLabelType];
        fieldModel.source   = [self fieldSourceTransformWithFieldSource:recognitionFieldModel.fieldSource];
        fieldModel.order    = recognitionFieldModel.fieldOrder;
        
        //////////////////////////////////////////////////
        
        for(id key in recognitionFieldModel.recognitionContextModelDictionary)
        {
            WCRecognitionContextModel *contextModel = [recognitionFieldModel.recognitionContextModelDictionary objectForKey:key];
            
            if(contextModel==nil)
            {
                break;
            }
            
            // !! 第二層的資訊在 setSubType2FieldWithValue:recogRect:subType2: 塞
//            //////////////////////////////////////////////////
//            
//            fieldModel.subType2 = [self fieldSubType2TransformWithRecognitionSubType:contextModel.recognitionFieldSubType];
//            fieldModel.isCJKStringValue = contextModel.isCJKStringValue;
//            fieldModel.recogRect = contextModel.recognitionRect;
            
            //////////////////////////////////////////////////

            [fieldModel setSubType2FieldWithValue:contextModel.contextString
                                        recogRect:contextModel.recognitionRect
                                         subType2:[self fieldSubType2TransformWithRecognitionSubType:contextModel.recognitionFieldSubType]];
            
        }
        
        [fieldModels addObject:fieldModel];
        
        [fieldModel release];
    }
    while (0);
    
    return fieldModels;
}


//================================================================================
//
//================================================================================
- (NSArray *)nameFieldModelsTransformWithRecognitionFieldModel:(WCRecognitionFieldModel *)recognitionFieldModel
                                                     cardModel:(WC_CardModel *)cardModel
{
    NSMutableArray *fieldModels = nil;
    
    do
    {
        if(recognitionFieldModel==nil ||
           cardModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        fieldModels = [NSMutableArray array];
        
        if(fieldModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WC_FieldModel *fieldModel = [[WC_FieldModel alloc] init];
        
        if(fieldModel==nil)
        {
            break;
        }
        
        fieldModel.ID       = WC_InvalidRecordID;
        fieldModel.type     = [self fieldTypeTransformWithFieldMainType:recognitionFieldModel.fieldMainType];
        fieldModel.subType1 = WC_FST1_None;
        fieldModel.subType2 = WC_FST2_None;
        
        fieldModel.source   = [self fieldSourceTransformWithFieldSource:recognitionFieldModel.fieldSource];
        fieldModel.order    = recognitionFieldModel.fieldOrder;

        //////////////////////////////////////////////////

        for(id key in recognitionFieldModel.recognitionContextModelDictionary)
        {
            WCRecognitionContextModel *contextModel = [recognitionFieldModel.recognitionContextModelDictionary objectForKey:key];
            
            if(contextModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            fieldModel.isCJKStringValue = contextModel.isCJKStringValue;
            
            //////////////////////////////////////////////////
            
            [fieldModel setSubType2FieldWithValue:contextModel.contextString
                                        recogRect:contextModel.recognitionRect
                                         subType2:[self fieldSubType2TransformWithRecognitionSubType:contextModel.recognitionFieldSubType]];
        }
        
        [fieldModels addObject:fieldModel];
        
        [fieldModel release];
    }
    while (0);
    
    return fieldModels;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instace Method

//================================================================================
//
//=================================================================================
- (WC_CardModel *)cardModelTransform
{
    WC_CardModel *cardModel =[[WC_CardModel alloc] init];
    
    if(cardModel!=nil)
    {
        @autoreleasepool
        {
            cardModel.frontRecogLang = self.frontRecognitionLanguage;
            cardModel.backRecogLang  = self.backRecognitionLanguage;
            cardModel.ID = self.cardID;
            cardModel.createdTime  = [NSDate date];
            cardModel.modifiedTime = [NSDate date];
            
            // fieldModelArrayDictionary @{key:@[WCRecognitionFieldModel,...],....}
            
            for(id key in self.fieldModelArrayDictionary)
            {
                NSArray *fieldModelArray = [self.fieldModelArrayDictionary objectForKey:key];
                
                for(WCRecognitionFieldModel *recognitionFieldModel in fieldModelArray)
                {
                    NSArray *fieldModels = nil;
                    
                    //////////////////////////////////////////////////

                    if(recognitionFieldModel.fieldMainType==WCRecognitionFieldMainType_Name)
                    {
                        fieldModels = [self nameFieldModelsTransformWithRecognitionFieldModel:recognitionFieldModel cardModel:cardModel];
                    }
                    else if (recognitionFieldModel.fieldMainType==WCRecognitionFieldMainType_Address)
                    {
                        fieldModels = [self subType2FieldModelsTransformWithRecognitionFieldModel:recognitionFieldModel];
                    }
                    else if(recognitionFieldModel.fieldMainType==WCRecognitionFieldMainType_Company)
                    {
                        fieldModels = [self subType2FieldModelsTransformWithRecognitionFieldModel:recognitionFieldModel];
                    }
                    else
                    {
                        fieldModels = [self subType1FieldModelsTransformWithRecognitionFieldModel:recognitionFieldModel];
                    }
                    
                    //////////////////////////////////////////////////

                    for(WC_FieldModel *fieldModel in fieldModels)
                    {
                        [cardModel addField:fieldModel];
                    }
                }
            }
        }
    }

    return [cardModel autorelease];
}

@end
