//
//  WCRecognitionPreferenceController.m
//
//
//  Created by Howard.Lin on 13/12/4.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "WCRecognitionPreferenceController.h"
#import "namecard_define.h"
#import "WCKernelRecogLangModel.h"
#import "WCKernelRecogTypeModel.h"
#import "WCRecognitionFieldDefine.h"
#import "NSString+Additions.h"
#import "PPSystemInfoController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCRecognitionPreferenceController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocatin Object

//===============================================================================
//
//===============================================================================
- (id)init
{
    self = [super init];
    
	if (self)
	{
		// load setting
		settings_ = [[NSUserDefaults alloc] init];
	}
	
	return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [settings_ release];
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
- (NSInteger)integerValueWithKey:(NSString *)key
{
	id  object = [settings_ objectForKey:key];
    NSInteger  intValue = WCRC_UnsetIntValue;
    
	
	// use default value
	if(object == nil)
	{
//        if([key isEqualToString:WCRC_IV_kRecognPhoneCountryCode])
//        {
//            intValue=0;
//        }
//		
        if(intValue != WCRC_UnsetIntValue)
        {
			[self setIntegerValue:intValue withKey:key];
        }
	}
    else
    {
        intValue = [object intValue];
    }
	
	return intValue;
}


//===============================================================================
//
//===============================================================================
- (void)setIntegerValue:(NSInteger)value withKey:(NSString *)key
{
    NSString *valueStr = [[NSString alloc] initWithFormat:@"%zd", value];
	[settings_ setObject:valueStr forKey:key];
    [settings_ synchronize];
    [valueStr release];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//===============================================================================
//
//===============================================================================
+ (NSMutableArray *)copyKernelClipRecogTypeArray
{
    // MARK: Howard 24種語系辨識核心，同Mobile設定，使用繁中。
    
	// kernel code mapping
    NSMutableArray *kernelRecogTypeArray = [[NSMutableArray alloc] init];
    
    
    //if(systemLanguage!=Country_Code_EN)
    //{
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_NAME]];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_COMPANY]];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_DEPARTMENT]];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_POSITION]];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_PHONE]];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_MOBILE]];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_FAX]];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_EMAIL] ];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_HOMEPAGE]];
        [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_ADDRESS]];
    //}
    //else
    //{
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_ENG_NAME]];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_ENG_COMPANY]];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_ENG_DEPARTMENT]];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_ENG_POSITION]];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_PHONE]];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_MOBILE]];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_FAX]];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_EMAIL] ];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_HOMEPAGE]];
    //    [kernelRecogTypeArray addObject:[WCKernelRecogTypeModel modelWithTypeCode:ID_BCR_ENG_ADDRESS]];
    //}
    
    return kernelRecogTypeArray;
}


//===============================================================================
//
//===============================================================================
+ (NSMutableArray *)copyKernelRecogLangArrayWithSystemLanguage
{
    // kernel code mapping
	NSMutableDictionary *allLangDict = [[NSMutableDictionary alloc] init];
    WCKernelRecogLangModel *recogLangModel;
    
    
    for(int i=B5_LANG; i<=TH_LANG; i++)
    {
        recogLangModel = [WCKernelRecogLangModel modelWithLangCode:i];
        [allLangDict setObject:recogLangModel forKey:recogLangModel.key];
    }
    
    NSUInteger defaultLanguageCode = -1;
    // !! 先檢查有沒有記錄
    NSString *recogLangOrder = [[NSUserDefaults standardUserDefaults] objectForKey:WCRC_Settings_RecogLangOrder];
    NSString *defaultRecogLangOrder = [self defaultRecogLangOrderWithKernelVersion:WCRecognitionKernelVersion_All];
    
    // !! 沒有記錄時使用預設值
    if(![recogLangOrder length] ||
       [[recogLangOrder componentsSeparatedByString:@"|"] count]<[[defaultRecogLangOrder componentsSeparatedByString:@"|"] count])
    {
        recogLangOrder = defaultRecogLangOrder;
        defaultLanguageCode = [self defaultLanguageCode];
    }

	// generate ouput data
    NSMutableArray *recogLangArray = [[NSMutableArray alloc] init];
    NSArray *tempArray = [recogLangOrder componentsSeparatedByString:@"|"];
    
    for(NSString *langKey in tempArray)
        [recogLangArray addObject:[allLangDict objectForKey:langKey]];
    
    // release temp buffer
    [allLangDict release];

    // 如果有用到預設值
    if (defaultLanguageCode!=-1)
    {
        [self setFirstChoiceRecogLang:defaultLanguageCode inArray:recogLangArray];
    }

    return recogLangArray;
}


//==============================================================================
//
//==============================================================================
+ (NSInteger)defaultLanguageCode
{
    NSString *countryCode = [[[NSLocale currentLocale] objectForKey:NSLocaleCountryCode] lowercaseString];
    
    // see namecard.h
    // 英文
    if([countryCode isEqualToString:@"en"]==YES)
    {
        return EN_LANG;
    }
    // 簡中
    else if([countryCode isEqualToString:@"cn"]==YES)
    {
        return  GB_LANG;
    }
    else
    {
        return  B5_LANG;
    }
}

//===============================================================================
//
//===============================================================================
+ (NSMutableArray *)copyKernelRecogLangArrayWithKernelVersion:(WCRecognitionKernelVersion)kernelVersion
{
    // kernel code mapping
    NSMutableDictionary *allLangDict = [[NSMutableDictionary alloc] init];
    WCKernelRecogLangModel *recogLangModel;
    
    
    for(int i=B5_LANG; i<=TH_LANG; i++)
    {
        recogLangModel = [WCKernelRecogLangModel modelWithLangCode:i];
        [allLangDict setObject:recogLangModel forKey:recogLangModel.key];
    }
    
    NSString *defaultRecogLangOrder = [self defaultRecogLangOrderWithKernelVersion:kernelVersion];
    // reset order by default;
    NSString *recogLangOrder = [self resetRecogLangOrder:nil withDefaultLangOrder:defaultRecogLangOrder];
    
    
    // generate ouput data
    NSMutableArray *recogLangArray = [[NSMutableArray alloc] init];
    NSArray *tempArray = [recogLangOrder componentsSeparatedByString:@"|"];
    
    for(NSString *langKey in tempArray)
        [recogLangArray addObject:[allLangDict objectForKey:langKey]];
    
    // release temp buffer
    [allLangDict release];
    
    
    return recogLangArray;
}


//==============================================================================
//
//==============================================================================
+ (NSString *)defaultRecogLangOrderWithKernelVersion:(WCRecognitionKernelVersion)kernelVersion
{
    PPSystemInfoLanguage systemLanguage = [PPSystemInfoController language];
    
    switch (kernelVersion)
    {
        case WCRecognitionKernelVersion_East:
        {
            switch (systemLanguage)
            {
                case PPSystemInfoLanguage_ChineseTraditional:
                    return @"B5|JP|EN|GB|KS";
                    
                case PPSystemInfoLanguage_ChineseSimplified:
                    return @"GB|JP|EN|B5|KS";
                    
                case PPSystemInfoLanguage_Japanese:
                    return @"JP|EN|B5|GB|KS";
                    
                case PPSystemInfoLanguage_Korean:
                    return @"KS|JP|EN|B5|GB";
                    
                default:
                    return @"EN|JP|B5|GB|KS";
            }
            break;
        }
        case WCRecognitionKernelVersion_West:
        {
            switch (systemLanguage)
            {
                case PPSystemInfoLanguage_French:
                    return @"FR|EN|GE|IT|ES|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_German:
                    return @"GE|EN|FR|IT|ES|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_Italian:
                    return @"IT|EN|FR|GE|ES|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_Spanish:
                    return @"ES|EN|FR|GE|IT|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_Portuguese:
                    return @"PT|EN|FR|GE|IT|ES|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_Dutch:
                    return @"NL|EN|FR|GE|IT|ES|PT|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_English:
                default:
                    return @"EN|FR|GE|IT|ES|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
            }
            break;
        }
        case WCRecognitionKernelVersion_All:
        {
            switch (systemLanguage)
            {
                case PPSystemInfoLanguage_ChineseTraditional:
                    return @"B5|HK|GB|EN|JP|KS|FR|GE|IT|ES|MX|PT|BR|NL|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_ChineseSimplified:
                    return @"GB|B5|HK|EN|JP|KS|FR|GE|IT|ES|MX|PT|BR|NL|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_Japanese:
                    return @"JP|EN|B5|HK|GB|KS|FR|GE|IT|ES|MX|PT|BR|NL|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_Korean:
                    return @"KS|EN|B5|HK|GB|JP|FR|GE|IT|ES|MX|PT|BR|NL|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_French:
                    return @"FR|EN|GE|IT|ES|MX|PT|BR|NL|B5|HK|GB|JP|KS|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_German:
                    return @"DK|EN|FR|GE|IT|ES|MX|PT|BR|NL|B5|HK|GB|JP|KS|PL|HU|CZ|SK|RU|TR|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_Italian:
                    return @"IT|EN|FR|GE|ES|MX|PT|BR|NL|B5|HK|GB|JP|KS|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_Spanish:
                    return @"ES|EN|FR|GE|IT|MX|PT|BR|NL|B5|HK|GB|JP|KS|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_Portuguese:
                    return @"PT|EN|FR|GE|IT|ES|MX|BR|NL|B5|HK|GB|JP|KS|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_Dutch:
                    return @"NL|EN|FR|GE|IT|ES|MX|PT|BR|B5|HK|GB|JP|KS|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
                    
                case PPSystemInfoLanguage_English:
                default:
                    return @"EN|FR|GE|IT|ES|MX|PT|BR|NL|B5|HK|GB|JP|KS|PL|HU|CZ|SK|RU|TR|DK|FI|GR|SE|NO|AR|TH";
            }
            break;
        }
        default:
        {
            switch (systemLanguage)
            {
                case PPSystemInfoLanguage_ChineseTraditional:
                    return @"B5|JP|EN|GB|KS";
                    
                case PPSystemInfoLanguage_ChineseSimplified:
                    return @"GB|JP|EN|B5|KS";
                    
                case PPSystemInfoLanguage_Japanese:
                    return @"JP|EN|B5|GB|KS";
                    
                case PPSystemInfoLanguage_Korean:
                    return @"KS|JP|EN|B5|GB";
                    
                case PPSystemInfoLanguage_French:
                    return @"FR|EN|GE|IT|ES|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_German:
                    return @"GE|EN|FR|IT|ES|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_Italian:
                    return @"IT|EN|FR|GE|ES|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_Spanish:
                    return @"ES|EN|FR|GE|IT|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_Portuguese:
                    return @"PT|EN|FR|GE|IT|ES|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_Dutch:
                    return @"NL|EN|FR|GE|IT|ES|PT|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
                    
                case PPSystemInfoLanguage_English:
                default:
                    return @"EN|FR|GE|IT|ES|PT|NL|MX|BR|PL|HU|CZ|SK|RU|TR|GR|NO|SE|DK|FI|AR";
            }
            break;
        }
    }
}


//===============================================================================
//
//===============================================================================
+ (NSString *)resetRecogLangOrder:(NSString *)recogLangOrder withDefaultLangOrder:(NSString *)defaultLangOrder
{
    
    NSMutableArray *defaultLangOrderArray = [NSMutableArray arrayWithArray:[defaultLangOrder componentsSeparatedByString:@"|"]];
    NSMutableArray *defaultOrderArray = [NSMutableArray arrayWithArray:[recogLangOrder componentsSeparatedByString:@"|"]];
    
    for(int i=0; i<[defaultOrderArray count]; i++)
    {
        NSString *defaultLang = [defaultOrderArray objectAtIndex:i];
        
        for(NSString *newOrderLang in defaultLangOrderArray)
        {
            if([defaultLang isEqualToString:newOrderLang])
            {
                [defaultOrderArray removeObjectAtIndex:i];
                i--;
                break;
            }
        }
    }
    
    NSMutableArray *resultArray = [NSMutableArray arrayWithArray:defaultLangOrderArray];
    [resultArray addObjectsFromArray:defaultOrderArray];
    return [resultArray componentsJoinedByString:@"|"];
}


//===============================================================================
//
//===============================================================================
+ (void)setFirstChoiceRecogLang:(NSInteger)recogLang inArray:(NSMutableArray *)recogLangArray
{
    NSInteger index = 0;
    
    for(WCKernelRecogLangModel *recogLangModel in recogLangArray)
    {
        if(recogLangModel.langCode == recogLang)
            break;
        
        index++;
    }
    
    if(index < [recogLangArray count])
    {
        WCKernelRecogLangModel *moveModel = [[recogLangArray objectAtIndex:index] retain];
        [recogLangArray removeObjectAtIndex:index];
        [recogLangArray insertObject:moveModel atIndex:0];
        [moveModel release];
        
        
        NSMutableString *orderString = [[NSMutableString alloc] init];
        
        for(WCKernelRecogLangModel *recogLangModel in recogLangArray)
        {
            if([orderString length])
                [orderString appendString:@"|"];
            
            [orderString appendFormat:@"%@", recogLangModel.key];
        }
        
        [[NSUserDefaults standardUserDefaults] setValue:orderString forKey:WCRC_Settings_RecogLangOrder];
        [orderString release];
    }
    
}


//===============================================================================
// 濾除株式會社等無用名稱
//===============================================================================
+ (NSString *)trimCompanyPrefix:(NSString *)oriCompanyName
{
    if(![oriCompanyName length])
        return nil;
    
    if(![oriCompanyName isCJK])
        return oriCompanyName;
    
    
    //-------------------------
    // 濾除不需要的字串
    //-------------------------
    NSString *newCompanyName = nil;
    NSString *allTitles = @"株式会社/有限会社/財団法人/社団法人/学校法人/宗教法人/合資会社/合名会社/相互会社/医療法人/独立行政法人/社団法人/農業協同組合/農事組合法人/(株)/(有)/(財)/(資)/(名)/(社)/(協)/(農)/（株）/（有）/（財）/（資）/（名）/（社）/（協）/（農）/㈱/㈲/㈶/㈾/㈴/㈳/㈿";
    NSArray *titleArray = [allTitles componentsSeparatedByString:@"/"];
    
    for(NSString *title in titleArray)
    {
        if([oriCompanyName hasPrefix:title])
        {
            newCompanyName = [oriCompanyName substringFromIndex:[title length]];
            break;
        }
        else if([oriCompanyName hasSuffix:title])
        {
            newCompanyName = [oriCompanyName substringToIndex:[oriCompanyName length]-[title length]];
            break;
        }
    }
    
    if(!newCompanyName)
        newCompanyName = [NSString stringWithString:oriCompanyName];
    
    return newCompanyName;
}


//================================================================================
//
//================================================================================
+ (PPCountry_Code)systemLanguage
{
    PPSystemInfoLanguage systemLanguage = [PPSystemInfoController language];
    
    switch (systemLanguage)
    {
        case PPSystemInfoLanguage_English:              {return Country_Code_EN;}
        case PPSystemInfoLanguage_ChineseTraditional:	{return Country_Code_B5;}
        case PPSystemInfoLanguage_Korean:				{return Country_Code_KS;}
        case PPSystemInfoLanguage_Japanese:				{return Country_Code_JP;}
        case PPSystemInfoLanguage_Spanish:				{return Country_Code_ES;}
        case PPSystemInfoLanguage_German:				{return Country_Code_GE;}
        case PPSystemInfoLanguage_Portuguese:			{return Country_Code_PT;}
        case PPSystemInfoLanguage_Italian:              {return Country_Code_IT;}
        case PPSystemInfoLanguage_ChineseSimplified:	{return Country_Code_GB;}
        case PPSystemInfoLanguage_Dutch:				{return Country_Code_NL;}
        case PPSystemInfoLanguage_French:				{return Country_Code_FR;}
        case PPSystemInfoLanguage_Danish:				{return Country_Code_DK;}
        case PPSystemInfoLanguage_Finnish:				{return Country_Code_FI;}
        case PPSystemInfoLanguage_Norwegian:			{return Country_Code_NO;}
        case PPSystemInfoLanguage_Swedish:				{return Country_Code_SE;}
        case PPSystemInfoLanguage_Russian:				{return Country_Code_RU;}
        case PPSystemInfoLanguage_Polish:				{return Country_Code_PL;}
        case PPSystemInfoLanguage_Turkish:				{return Country_Code_TR;}
        case PPSystemInfoLanguage_Arabic:				{return Country_Code_AR;}
        case PPSystemInfoLanguage_Czech:				{return Country_Code_CZ;}
        case PPSystemInfoLanguage_Greek:				{return Country_Code_GR;}
        case PPSystemInfoLanguage_Slovak:				{return Country_Code_SK;}
        case PPSystemInfoLanguage_Hungarian:			{return Country_Code_HU;}
        default:                                        {return Country_Code_EN;}
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Accessory Class Methods

//================================================================================
// Singleton pattern getter function
//================================================================================
+ (WCRecognitionPreferenceController *)shareWCRecognitionPreferenceController
{
    static id shareWCRecognitionPreferenceController = nil;
	static dispatch_once_t onceToken;
    
	dispatch_once(&onceToken, ^{
		shareWCRecognitionPreferenceController = [[self alloc] init];
	});
    
	return shareWCRecognitionPreferenceController;
}



@end
