//
//  WCPromotionADController.m
//  WorldCardMobile7
//
//  Created by sanhue on 2015/10/22.
//  Copyright © 2015年 penpower. All rights reserved.
//

#import "WCPromotionADController.h"
#import "PPSystemInfoController.h"
//#import "PPPurchaseFlowController.h"
#import "PPPromotionViewController.h"
#import "PPSupportController.h"
#import "WCAppearanceDefine.h"
#import "PPGuideController.h"
#import "PPSettingsController.h"
#import "WCSettingsKey.h"
#import "PPLockScreenController.h"


static BOOL staticCanShowPromotion = YES;

#define WCPromotionADViewBounds_iPad CGRectMake(0, 0, 720, 720)

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCPromotionADController

//==============================================================================
//
//==============================================================================
+ (NSString *)appLicense
{
#if defined (IS_LITE_VERSION)
    
    return LicenseString_Lite;
    
#else
    // 正式版
    return LicenseString_Paid;
#endif
}

//==============================================================================
//
//==============================================================================
+ (NSString *)promotionURLStringWithLicence:(NSString*)licence
{
    NSString *urlString = [NSString stringWithFormat:@"http://mobile.penpower.net/index.asp?%@",
                           [PPSupportController moreAppsURLParamsWithProductName:@"phonekit" license:licence]];
    
    return [urlString stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
}


//==============================================================================
//
//==============================================================================
+ (void)showPhoneKitPromotionFromViewController:(UIViewController *)viewController force:(BOOL)force;
{
    if (staticCanShowPromotion==NO)
    {
        return ;
    }
    
    if([PPGuideController isGuideDisplaying])
    {
        return ;
    }
    
    if ([[PPLockScreenController shareInstance] isLockScreenDisplaying])
    {
        return ;
    }
    
    // !! 取得promotionURL
    NSString *appLicense = [self appLicense];
    NSString *webLink = [[self class] promotionURLStringWithLicence:appLicense];
    if ([webLink length]==0)
    {
        return ;
    }
    
    if (force || [PPSettingsController integerValueWithKey:WCSC_IV_kHasShownPromotion]==NO)
    {
        
        [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
        if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            [PPPromotionViewController showiPadPromotionURL:[NSURL URLWithString:webLink]
                                         fromViewController:viewController
                                                withLicence:appLicense
                                                      style:PromotionStyle_NoRemind
                                                 viewBounds:WCPromotionADViewBounds_iPad
                                           openLinkOutOfApp:NO
                                                 completion:^(NSInteger buttonID) {
                                                     if (!force && buttonID == PPPromotionButtonID_Close)
                                                     {
                                                         [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
                                                     }
                                                 }];
        }
        else
        {
            [PPPromotionViewController showPromotionURL:[NSURL URLWithString:webLink]
                                     fromViewController:viewController
                                            withLicence:appLicense
                                         promotionStyle:PromotionStyle_NoRemind
                                       openLinkOutOfApp:NO
                                             completion:^(NSInteger buttonID) {
                                                 if (!force && buttonID == PPPromotionButtonID_Close)
                                                 {
                                                     [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
                                                 }
                                             }];
        }
    }
}


//==============================================================================
//
//==============================================================================
+ (void)showPromotionFromViewController:(UIViewController *)viewController force:(BOOL)force
{
    if (staticCanShowPromotion==NO)
    {
        return ;
    }
    
    if([PPGuideController isGuideDisplaying])
    {
        return ;
    }
    
    if ([[PPLockScreenController shareInstance] isLockScreenDisplaying])
    {
        return ;
    }
    
    if (force || [PPSettingsController integerValueWithKey:WCSC_IV_kHasShownPromotion]==NO)
    {
        // 7.3.4之後關閉超商取貨
//        if ([PPSystemInfoController locale]==PPSystemInfoLocale_Taiwan)
//        {
//            [PPPurchaseFlowController setPurchaseADViewBackgroundColor:WCAppearanceDefine_NavigationBarColor];
//
//            //////////////////////////////////////////////////
//            // pusrchase畫面要修正
//            // reminder button = NO，每次都會秀，所以跟promotionView一樣
//            if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
//            {
//                __block PPPurchaseFlowController *purchaseFlowController =
//                [[PPPurchaseFlowController alloc] initWithShowReminderButton:NO
//                                                            puuchaseFlowType:PPPurchaseFlowType_PhoneKit
//                                                needHiddenStatusBarAfterFlow:NO
//                                                                  frameStyle:PPPurchaseFrameStyle_iPad];
//                [purchaseFlowController showPurchaseFlowFromViewControllerOniPad:viewController orientation:UIInterfaceOrientationPortrait withResultHandler:^(BOOL result) {
//                    [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
//                    [purchaseFlowController release];
//                }];
//            }
//            else
//            {
//                __block PPPurchaseFlowController *purchaseFlowController =
//                [[PPPurchaseFlowController alloc] initWithShowReminderButton:NO
//                                                            puuchaseFlowType:PPPurchaseFlowType_PhoneKit
//                                                needHiddenStatusBarAfterFlow:NO
//                                                                  frameStyle:PPPurchaseFrameStyle_iPhone];
//                [purchaseFlowController showPurchaseFlowFromViewControllerOniPhone:viewController withResultHandler:^(BOOL result) {
//                    [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
//                    [purchaseFlowController release];
//                }];
//            }
//        }
//        else
        {
            if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
            {
                [PPPromotionViewController showiPadPromotionFromViewController:viewController
                                                                   withLicence:[self appLicense]
                                                                         style:PromotionStyle_NoRemind
                                                                    viewBounds:WCPromotionADViewBounds_iPad
                                                                    completion:^(NSInteger buttonID) {
                                                                        if (buttonID == PPPromotionButtonID_Close)
                                                                        {
                                                                            [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
                                                                        }
                                                                    }];
            }
            else
            {
                [PPPromotionViewController showPromotionFromViewController:viewController
                                                               withLicence:[self appLicense]
                                                            promotionStyle:PromotionStyle_NoRemind
                                                                completion:^(NSInteger buttonID) {
                                                                    if (buttonID == PPPromotionButtonID_Close)
                                                                    {
                                                                        [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
                                                                    }
                                                                }];
            }

        }
    }
}


//==============================================================================
//
//==============================================================================
+ (void)showPromotionByURLFromViewController:(UIViewController *)viewController force:(BOOL)force
{
    if (staticCanShowPromotion==NO)
    {
        return ;
    }
    
    if([PPGuideController isGuideDisplaying])
    {
        return ;
    }
    
    if ([[PPLockScreenController shareInstance] isLockScreenDisplaying])
    {
        return ;
    }
    
    if([viewController isKindOfClass:[PPPromotionViewController class]]==YES)
    {
        return ;
    }
    
    // !! 取得promotionURL
    NSString *webLink = [PPSettingsController stringValueWithKey:WCSC_SV_PromotionURL];
    if ([webLink length]==0)
    {
        return ;
    }
    
    if (force || [PPSettingsController integerValueWithKey:WCSC_IV_kHasShownPromotion]==NO)
    {
        
        [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
       if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
        {
            [PPPromotionViewController showiPadPromotionURL:[NSURL URLWithString:webLink]
                                         fromViewController:viewController
                                                withLicence:[self appLicense]
                                                      style:PromotionStyle_NoRemind
                                                 viewBounds:WCPromotionADViewBounds_iPad
                                           openLinkOutOfApp:NO
                                                 completion:^(NSInteger buttonID) {
                                                     if (!force && buttonID == PPPromotionButtonID_Close)
                                                     {
                                                         [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
                                                     }
                                                 }];
        }
        else
        {
            [PPPromotionViewController showPromotionURL:[NSURL URLWithString:webLink]
                                     fromViewController:viewController
                                            withLicence:[self appLicense]
                                         promotionStyle:PromotionStyle_NoRemind
                                       openLinkOutOfApp:NO
                                             completion:^(NSInteger buttonID) {
                                                 if (!force && buttonID == PPPromotionButtonID_Close)
                                                 {
                                                     [PPSettingsController setIntegerValue:1 withKey:WCSC_IV_kHasShownPromotion];
                                                 }
                                             }];
        }
    }
}



//==============================================================================
//
//==============================================================================
+ (void)supendShowPromotion
{
    staticCanShowPromotion = NO;
}


//==============================================================================
//
//==============================================================================
+ (void)resumeShowPromotion
{
    staticCanShowPromotion = YES;
}
@end
