//
//  WCNewCardFlowDelegate.h
//  WorldCard
//
//  NOTE
//  --------------------------------------------------
//  1. 因為是多層使用，所以WCNewCardFlowDelegate不會包含發送端的instance
//  2. 修改delegate函式時，請一併更新WCNewCardFlowController.m / NCFCBaseFlowController+Private.m
//

#import <Foundation/Foundation.h>

#import "PPStorageSpaceSelectViewController+PublicParameterDefine.h"
#import "WCNewCardFlowController+ParameterDefine.h"

#import "WCCardModel.h"
#import "WCRecogSourceModel.h"
#import "WCABCardModel.h"
#import "WCGroupModel.h"
#import "WCContactAccessFlowController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCNewCardFlow_Error)
{
    WCNewCardFlow_Error_Unknown = 0,
    WCNewCardFlow_Error_ReachMaxNewCardCount,   // 新增數量已滿，無法再新增。
    WCNewCardFlow_Error_SubscribeNow,           // 通知要訂閱
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCCaptureViewController;
@class WCNewCardFlowController;

@protocol WCNewCardFlowDelegate <NSObject>

/**
 *  詢問是否顯示此種錯誤
 *
 *  @param error 錯誤
 *
 *  @return YES, 顯示
 */
- (BOOL)newCardFlowRequesetShowError:(NSError *)error;

/**
 * 取得錯誤的描述訊息，用來顯示在alert中。 (synchronized)
 * 當error來源是外部，或內部無法找到描述訊息時，會透過此函式請求。
 *
 * @param error - NSError
 * @return - Error info string, will be used in alert.
 */
- (NSString *)newCardFlowRequestMessageWithError:(NSError *)error;

/**
 * 回傳PPStorageSpaceSelectControllerSpaceType_Specific的顯示字串
 * @return NSString 有指定cell時，顯示的字串，nil時會顯示MLS_StorageSpecificTitle
 */
- (NSString *)requestSpecificString;


/**
 *  通知外部名片總數，及目前處理的索引
 *  處理方式:顯示目前處理的情況
 *
 *  @param index 索引
 *  @param totalCount 名片數量
 */
- (void)newCardFlowRequestRecogTaskAtIndex:(NSUInteger)index totalCount:(NSUInteger)totalCount;


/**
 * 單張立即辨識，結果由return取得。 (synchronized)
 * 處理方式: call 辨識核心，並將結果回傳
 *
 * @param recogSourceModel - recognition source
 * @param error - return error
 * @return Recognized card mode
 */
- (WCCardModel *)newCardFlowRequestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                                  error:(NSError **)error;


/**
 *  單張辨識，提供名片圖(多張辨識時名片會經過處理)，經由return取得
 *  處理方式: call 辨識核心，並將結果回傳(要用image去做辨識)
 *
 *  @param recogSourceModel recognition source
 *  @param image            要辨識的影像
 *  @param error            return error
 *
 *  @return card mode
 */
- (WCCardModel *)newCardFlowRequestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                                  image:(UIImage *)image
                                                  error:(NSError **)error;



/**
 QRCode 辨識

 *  處理方式: 將sourceString送到辨識元件中，並將結果回傳
 *
 *  @param sourceString 來源字串
 *  @param newCardMode card mode
 *  @param error       return error
 *
 *  @return cardModel
 */
- (WCCardModel *)newCardFlowRequestRecogWithQRCodeString:(NSString *)qrCodeString
                                             newCardMode:(WCNewCardFlowController_Mode)newCardMode
                                                   error:(NSError **)error;


/**
 *  簽名辨識
 *  處理方式: 將sourceString送到辨識元件中，並將結果回傳
 *
 *  @param sourceString 來源字串
 *  @param newCardMode card mode
 *  @param error       return error
 *
 *  @return cardModel
 */
- (WCCardModel *)newCardFlowRequestRecogWithSourceString:(NSString *)sourceString
                                             newCardMode:(WCNewCardFlowController_Mode)newCardMode
                                                   error:(NSError **)error;



- (WCCardModel *)newCardFlowRequestClipRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                          originalCardModel:(WCCardModel *)originalCardModel
                                                      error:(NSError **)error;

/**
 *  取得新增名片預設群組
 *
 *  @return 預設群組
 */
- (NSArray *)newCardFlowRequestCardModelDefaultGroupIDArray;


/**
 * 取得carID所包含的group
 * @param cardID 要取得哪一個聯絡人的group資訊，nil表示全部都要load
 * @return NSMutableArray array of WCGroupModel
 */
- (NSMutableArray *)newCardFlowhWithAllGroupModelsWithCardID:(NSString *)cardID;


/**
 *  回傳group名稱，如是多個會以","分隔
 *
 *  @param groupIDArray 要取得名稱的group ID
 *
 *  @return 回傳group名稱，如是多個會以","分隔
 */
- (NSString *)newCardFlowWithGroupNamesWithGroupIDArray:(NSArray *)groupIDArray;


/**
 *  取得群組是否存在
 *
 *  @param groupNamed 要檢查的群組名稱
 *
 *  @return BOOL YES if exist, else NO
 */
- (BOOL)newCardFlowWithExistGroupNamed:(NSString *)groupNamed;


/**
 * 新增群組
 * @param groupName 要新增的群組名稱
 * @param error 回傳錯誤
 *
 * @return WCGroupModel 新增的groupModel
 */
- (WCGroupModel *)newCardFlowWithGroupModelByNewGroupName:(NSString *)groupName error:(NSError **)error;


/**
 *  查詢已存在群組ID的群組
 *
 *  @param groupName 要查詢的群組名稱
 *
 *  @return WCGroupModel 查詢的群組名稱
 */
- (WCGroupModel *)newCardFlowWithGroupModelByExistGroupName:(NSString *)groupName;


/**
 * 儲存資料 (synchronized)
 * 處理方式: 多張名片辨識時，將名片與圖片存到資料庫或檔案中
 *
 * @param cardModel - WCCardModel that need to be saved
 * @param idPhotoImage - UIImage of ID photo
 * @param frontSideImage - UIImage of card front side
 * @param backSideImage - UIImage of card back side
 * @param error - return error
 * @return - YES if saved success
 */
- (BOOL)newCardFlowRequestSaveWithWCCardModel:(WCCardModel *)cardModel
                                 idPhotoImage:(UIImage *)idPhotoImage
                               frontSideImage:(UIImage *)frontSideImage
                                backSideImage:(UIImage *)backSideImage
                                        error:(NSError **)error;

/**
 * 儲存資料 (synchronized)
 * 處理方式: 單張名片辨識時，將名片與圖片存到資料庫或檔案中
 *
 *  @param cardModel      WCCardModel that need to be saved
 *  @param idPhotoImage   UIImage of ID photo
 *  @param frontSideImage UIImage of card front side
 *  @param backSideImage  UIImage of card back side
 *  @param sourceID       sourceID of System Contact
 *  @param groupID        groupID of System Contact
 *  @param personID       personID of System Contact
 *  @param error          return error
 *
 *  @return YES if saved success
 */
- (BOOL)newCardFlowRequestSaveWithSingleWCCardModel:(WCCardModel *)cardModel
                                       idPhotoImage:(UIImage *)idPhotoImage
                                     frontSideImage:(UIImage *)frontSideImage
                                      backSideImage:(UIImage *)backSideImage
                                           sourceID:(NSString *)sourceID
                                            groupID:(NSString *)groupID
                                           personID:(NSString *)personID
                                              error:(NSError **)error;


/**
 *  儲存匯入資料 (synchronized)
 *
 *  @param cardModel - WCCardModel that need to be saved
 *  @param idPhotoImage - UIImage of ID photo
 *  @param frontSideImage - UIImage of card front side
 *  @param backSideImage - UIImage of card back side
 *  @param error - return error
 *
 *  @return YES if saved success
 */
- (BOOL)newCardFlowRequestSaveWithImportWCCardModel:(WCCardModel *)cardModel
                                       idPhotoImage:(UIImage *)idPhotoImage
                                     frontSideImage:(UIImage *)frontSideImage
                                      backSideImage:(UIImage *)backSideImage
                                              error:(NSError **)error;
/**
 * 儲存從系統聯絡人轉換過來的資料 (synchronized)
 * 處理方式: 將名片與圖片存到資料庫或檔案中
 *
 * @param cardModel - 用來記錄AddressBook的資料及關聯性
 * @param error - return error
 * @return - YES if saved success
 */
- (BOOL)newCardFlowRequestSaveWithWCABCardModel:(WCABCardModel *)cardModel
                                          error:(NSError **)error;


/**
 * 結束通知 (synchronized)
 * 處理方式: release flow controller
 *
 * @param lastError - last error
 */
- (void)newCardFlowDidFinishWithError:(NSError *)lastError ;


/**
 * 電話自動格式化設定
 * @return BOOL 是否要自動格式化電話
 */
- (BOOL)newCardFlowRequestAutoFormatPhoneNumber;

/**
 * 電話加入國碼，電話自動格式化設定為YES時才有用
 * @return BOOL 是否要在電話自動加上國碼
 */
- (BOOL)newCardFlowRequestAppendCountryCode;


/**
 *  是否儲存系統聯絡人
 *
 *  @return YES, 儲存到系統聯絡人
 */
- (BOOL)newCardFlowControllerRequestEnableSaveToiPhoneContact;


/**
 * 取得預設的系統群組 sourceID
 * @return sourceID, detault nil;
 */
- (NSString *)newCardFlowControllerRequestDefaultABSourceID;


/**
 * 取得預設的系統群組 groupID
 * @return groupID, default nil;
 */
- (NSString *)newCardFlowControllerRequestDefaultABGroupID;


/**
 *  基座模式，相機顯示 Promotion
 *
 *  @param captureViewController 相機物件
 */
- (void)newCardFlowControllerShowDockPromotionFromCaptureViewController:(WCCaptureViewController *)captureViewController;


/**
 *  取得是否顯示自訂空間
 *
 *  @return YES, 顯示
 */
- (BOOL)newCardFlowRequesetEnableSpecificSpace;


/**
 *  取得 Gmail 同步帳號
 *
 *  @return Gmail 同步帳號 (沒有回傳nil)
 */
- (NSString *)newCardFlowRequestGoogleSyncAccount;



/**
 取得自訂欄位

 @return 自訂欄位集合
 */
- (NSArray *)newCardFlowControllerRequestCustomFieldInfos;


@optional

/**
 * 多張背景辨識 (non-synchronized)
 * (目前沒有用到)
 *
 * @param recogSourceModels - recognition source array of WCRecogSourceModel
 */
- (void)newCardFlowRequestRecogWithWithSourceModels:(NSMutableArray *)recogSourceModels;


/**
 *  通知空間選擇結果
 *
 *  @param storageSpaceSelectControllerSpaceType 空間型態
 */
- (void)newCardFlowRequestDidSelectStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType;


/**
 *  通知開始辨識
 */
- (void)newCardFlowRequestStartRecognition;


/**
 *  通知結束辨識
 */
- (void)newCardFlowRequestFinishRecognition;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCT (個人帳戶資料專用)

/**
 *  取得登入帳號 guid
 *
 *  @return 登入帳號 guid
 */
- (NSString *)newCardFlowRequestSelfAccountGuid;


/**
 *  取得boss guid
 *
 *  @return boss guid
 */
- (NSString *)newCardFlowRequestBossAccountGuid;


/**
 *  guid取得帳號關係
 *
 *  @param guid 來源 guid
 *
 *  @return guid取得帳號關係
 */
- (NSString *)newCardFlowRequestRelationWithGuid:(NSString *)guid;


/**
 *  取得 guid 對應的 帳號名稱
 *
 *  @param guid 帳號 guid
 *
 *  @return 帳號名稱
 */
- (NSString *)newCardFlowRequestAccountNameWithGuid:(NSString *)guid;


/**
 *  取得帳號匯出權限
 *
 *  @return 帳號匯出權限
 */
- (BOOL)newCardFlowRequestAccountExportAbility;

/**
 *  取得所有帳號列表
 *
 *  @return 取得所有帳號列表
 */
- (NSArray *)newCardFlowRequestAllAccounts;


/**
 *  取得所有帳號列表
 *
 *  @return 取得所有帳號列表
 */
- (BOOL)newCardFlowRequestCheckAndAlertChangeVisibleAccontWithContactAccessFlowController:(WCContactAccessFlowController *)contactAccessFlowController;


/**
 *  取得預設檢視的帳號陣列
 *
 *  @param cardID 名片 id
 *
 *  @return 預設檢視的帳號陣列
 */
- (NSArray *)newCardFlowRequestDefaultSharedAccountGuidsWithCardID:(NSString *)cardID;


/**
 *  取得空間陣列
 *
 *  @return 空間陣列 The array of PPStorageSpaceSelectControllerSpaceType
 */
- (NSMutableArray *)newCardFlowRequestSpaceTypeArray;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCSF專用

/**
 *  取得salesforce picklist items
 *  @param fieldName field name of picklist
 *  @param defaultItemIndex 回傳預設選項的index
 *  @param editable 回傳此欄位是否可編輯
 *
 *  @return array of picklist items
 */
- (NSArray *)newCardFlowRequestSalesforcePicklistItemsWithFieldName:(NSString *)fieldName defaultItemIndex:(NSInteger *)defaultItemIndex editable:(BOOL *)editable;

/**
 *  取得salesforce save as
 *
 *  @return array of save as items
 */
- (NSArray *)newCardFlowRequestSalesforceSupportedSaveAsArray;

@end
